/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactParameters;
import org.springframework.webflow.builder.FlowAssembler;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.XmlFlowBuilder;
import org.springframework.webflow.registry.FlowHolder;
import org.springframework.webflow.registry.FlowRegistrar;
import org.springframework.webflow.registry.FlowRegistry;
import org.springframework.webflow.registry.RefreshableFlowHolder;

public abstract class FlowRegistrarSupport
implements FlowRegistrar {
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected void registerFlow(String flowId, FlowBuilder flowBuilder, FlowRegistry registry) {
        registry.registerFlow(this.createFlowHolder(new FlowAssembler(flowId, flowBuilder)));
    }

    protected void registerFlow(FlowArtifactParameters flowParameters, FlowBuilder flowBuilder, FlowRegistry registry) {
        registry.registerFlow(this.createFlowHolder(new FlowAssembler(flowParameters, flowBuilder)));
    }

    protected void registerXmlFlow(String flowId, Resource location, FlowArtifactFactory flowArtifactFactory, FlowRegistry registry) {
        this.registerFlow(new FlowArtifactParameters(flowId), (FlowBuilder)new XmlFlowBuilder(location, flowArtifactFactory), registry);
    }

    protected void registerXmlFlow(FlowArtifactParameters flowParameters, Resource location, FlowArtifactFactory flowArtifactFactory, FlowRegistry registry) {
        this.registerFlow(flowParameters, (FlowBuilder)new XmlFlowBuilder(location, flowArtifactFactory), registry);
    }

    protected FlowHolder createFlowHolder(FlowAssembler assembler) {
        return new RefreshableFlowHolder(assembler);
    }

    public abstract void registerFlows(FlowRegistry var1, FlowArtifactFactory var2);
}

