/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.struts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.validation.Errors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ActionSupport;
import org.springframework.web.struts.SpringBindingActionForm;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowArtifactException;
import org.springframework.webflow.action.FormObjectAccessor;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.struts.StrutsExternalContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.executor.support.FlowRequestHandler;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class FlowAction
extends ActionSupport {
    protected static final String FLOW_EXECUTOR_BEAN_NAME = "flowExecutor";
    protected static final String FLOW_LOCATOR_BEAN_NAME = "flowLocator";
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentExtractor parameterExtractor;
    static /* synthetic */ Class class$org$springframework$webflow$executor$FlowExecutor;
    static /* synthetic */ Class class$org$springframework$webflow$execution$FlowLocator;

    public void setFlowLocator(FlowLocator flowLocator) {
        this.flowExecutor = new FlowExecutorImpl(flowLocator);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowExecutorArgumentExtractor getParameterExtractor() {
        return this.parameterExtractor;
    }

    public void setParameterExtractor(FlowExecutorArgumentExtractor parameterExtractor) {
        this.parameterExtractor = parameterExtractor;
    }

    protected void onInit() {
        if (this.getFlowExecutor() == null) {
            WebApplicationContext context = this.getWebApplicationContext();
            if (context.containsBean(FLOW_EXECUTOR_BEAN_NAME)) {
                this.setFlowExecutor((FlowExecutor)context.getBean(FLOW_EXECUTOR_BEAN_NAME, class$org$springframework$webflow$executor$FlowExecutor == null ? (class$org$springframework$webflow$executor$FlowExecutor = FlowAction.class$("org.springframework.webflow.executor.FlowExecutor")) : class$org$springframework$webflow$executor$FlowExecutor));
            } else {
                try {
                    this.setFlowLocator((FlowLocator)context.getBean(FLOW_LOCATOR_BEAN_NAME, class$org$springframework$webflow$execution$FlowLocator == null ? (class$org$springframework$webflow$execution$FlowLocator = FlowAction.class$("org.springframework.webflow.execution.FlowLocator")) : class$org$springframework$webflow$execution$FlowLocator));
                }
                catch (NoSuchBeanDefinitionException e) {
                    String message = "No 'flowLocator' or 'flowExecutor' bean definition could be found; to use Spring Web Flow with Struts you must configure this FlowAction with either a FlowLocator (exposing a registry of flow definitions) or a custom FlowExecutor (allowing more configuration options)";
                    throw new FlowArtifactException(FLOW_LOCATOR_BEAN_NAME, class$org$springframework$webflow$execution$FlowLocator == null ? (class$org$springframework$webflow$execution$FlowLocator = FlowAction.class$("org.springframework.webflow.execution.FlowLocator")) : class$org$springframework$webflow$execution$FlowLocator, message, e);
                }
            }
        }
        if (this.getParameterExtractor() == null) {
            this.parameterExtractor = new FlowExecutorArgumentExtractor();
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StrutsExternalContext context = new StrutsExternalContext(mapping, form, this.getServletContext(), request, response);
        ResponseInstruction responseInstruction = this.createRequestHandler().handleFlowRequest(context);
        return this.toActionForward(responseInstruction, mapping, form, request, context);
    }

    protected FlowRequestHandler createRequestHandler() {
        return new FlowRequestHandler(this.getFlowExecutor(), this.getParameterExtractor());
    }

    protected ActionForward toActionForward(ResponseInstruction response, ActionMapping mapping, ActionForm form, HttpServletRequest request, ExternalContext context) {
        if (response.isApplicationView()) {
            ApplicationView forward = (ApplicationView)response.getViewSelection();
            HashMap model = new HashMap(forward.getModel());
            this.parameterExtractor.put(response.getFlowExecutionKey(), model);
            this.parameterExtractor.put(response.getFlowExecutionContext(), model);
            WebUtils.exposeRequestAttributes((ServletRequest)request, model);
            if (form instanceof SpringBindingActionForm) {
                SpringBindingActionForm bindingForm = (SpringBindingActionForm)form;
                bindingForm.expose(this.getCurrentErrors(forward.getModel()), request);
            }
            return this.findActionForward(forward, mapping);
        }
        if (response.isConversationRedirect()) {
            Serializable conversationId = response.getFlowExecutionKey().getConversationId();
            String conversationUrl = this.parameterExtractor.createConversationUrl(conversationId, context);
            return new ActionForward(conversationUrl, true);
        }
        if (response.isExternalRedirect()) {
            String externalUrl = this.parameterExtractor.createExternalUrl((ExternalRedirect)response.getViewSelection(), response.getFlowExecutionKey(), context);
            return new ActionForward(externalUrl, true);
        }
        if (response.isFlowRedirect()) {
            String flowUrl = this.parameterExtractor.createFlowUrl((FlowRedirect)response.getViewSelection(), context);
            return new ActionForward(flowUrl, true);
        }
        if (response.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
    }

    private Errors getCurrentErrors(Map model) {
        return (Errors)model.get(FormObjectAccessor.getCurrentFormErrorsName());
    }

    private ActionForward findActionForward(ApplicationView forward, ActionMapping mapping) {
        ActionForward actionForward = mapping.findForward(forward.getViewName());
        actionForward = actionForward != null ? new ActionForward(actionForward.getName(), actionForward.getPath(), false) : new ActionForward(forward.getViewName(), false);
        return actionForward;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

