/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;

public class Conversation
implements Serializable {
    private static final long serialVersionUID = 3532014613434083365L;
    private LinkedList continuations = new LinkedList();
    private int maxContinuations;
    private ViewSelection currentViewSelection = ViewSelection.NULL_VIEW;
    private AttributeMap scope = new AttributeMap();

    public Conversation(int maxContinuations) {
        Assert.isTrue((maxContinuations > 0 ? 1 : 0) != 0, (String)"'maxContinuations' must be greater than 0");
        this.maxContinuations = maxContinuations;
    }

    public FlowExecutionContinuation getContinuation(Serializable id) {
        ListIterator it = this.continuations.listIterator(this.continuations.size());
        while (it.hasPrevious()) {
            FlowExecutionContinuation continuation = (FlowExecutionContinuation)it.previous();
            if (!continuation.getId().equals(id)) continue;
            return continuation;
        }
        return null;
    }

    public void addContinuation(FlowExecutionContinuation continuation) {
        this.continuations.add(continuation);
        if (this.continuations.size() > this.maxContinuations) {
            this.continuations.removeFirst();
        }
    }

    public int getContinuationCount() {
        return this.continuations.size();
    }

    public FlowExecutionContinuation getCurrentContinuation() {
        return (FlowExecutionContinuation)this.continuations.getLast();
    }

    public ViewSelection getCurrentViewSelection() {
        return this.currentViewSelection;
    }

    public void setCurrentViewSelection(ViewSelection viewSelection) {
        this.currentViewSelection = viewSelection;
    }

    public AttributeMap getScope() {
        return this.scope;
    }

    public void setScope(AttributeMap scope) {
        this.scope = scope;
    }
}

