/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.convert.support.TextToExpression;
import org.springframework.binding.convert.support.TextToExpressions;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.method.TextToMethodSignature;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.webflow.Action;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowArtifactException;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.State;
import org.springframework.webflow.StateExceptionHandler;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.action.LocalBeanInvokingAction;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactParameters;
import org.springframework.webflow.builder.TextToTransitionCriteria;
import org.springframework.webflow.builder.TextToTransitionTargetStateResolver;
import org.springframework.webflow.builder.TextToViewSelector;
import org.springframework.webflow.support.DefaultExpressionParserFactory;

public class DefaultFlowArtifactFactory
implements FlowArtifactFactory {
    private ExpressionParser expressionParser;
    private ConversionService conversionService;
    private ResourceLoader resourceLoader;
    static /* synthetic */ Class class$org$springframework$webflow$Flow;
    static /* synthetic */ Class class$org$springframework$webflow$Action;
    static /* synthetic */ Class class$org$springframework$webflow$FlowAttributeMapper;
    static /* synthetic */ Class class$org$springframework$webflow$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$ViewSelector;
    static /* synthetic */ Class class$org$springframework$webflow$StateExceptionHandler;
    static /* synthetic */ Class class$org$springframework$webflow$TargetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$Transition;

    public void setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Flow getSubflow(String id) throws FlowArtifactException {
        throw new FlowArtifactException(id, class$org$springframework$webflow$Flow == null ? (class$org$springframework$webflow$Flow = DefaultFlowArtifactFactory.class$("org.springframework.webflow.Flow")) : class$org$springframework$webflow$Flow, "Subflow lookup is not supported by this artifact factory");
    }

    public Action getAction(FlowArtifactParameters parameters) throws FlowArtifactException {
        throw new FlowArtifactException(parameters.getId(), class$org$springframework$webflow$Action == null ? (class$org$springframework$webflow$Action = DefaultFlowArtifactFactory.class$("org.springframework.webflow.Action")) : class$org$springframework$webflow$Action, "Unable to lookup action with id '" + parameters.getId() + "'; action lookup is not supported by this artifact factory");
    }

    public FlowAttributeMapper getAttributeMapper(String id) throws FlowArtifactException {
        throw new FlowArtifactException(id, class$org$springframework$webflow$FlowAttributeMapper == null ? (class$org$springframework$webflow$FlowAttributeMapper = DefaultFlowArtifactFactory.class$("org.springframework.webflow.FlowAttributeMapper")) : class$org$springframework$webflow$FlowAttributeMapper, "Unable to lookup attribute mapper with id '" + id + "'; attribute mapper lookup is not supported by this artifact factory");
    }

    public TransitionCriteria getTransitionCriteria(String id) throws FlowArtifactException {
        throw new FlowArtifactException(id, class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = DefaultFlowArtifactFactory.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria, "Unable to lookup transition criteria with id '" + id + "'; transition criteria lookup is not supported by this artifact factory");
    }

    public ViewSelector getViewSelector(String id) throws FlowArtifactException {
        throw new FlowArtifactException(id, class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = DefaultFlowArtifactFactory.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector, "Unable to lookup view selector with id '" + id + "'; view selector lookup is not supported by this artifact factory");
    }

    public StateExceptionHandler getExceptionHandler(String id) throws FlowArtifactException {
        throw new FlowArtifactException(id, class$org$springframework$webflow$StateExceptionHandler == null ? (class$org$springframework$webflow$StateExceptionHandler = DefaultFlowArtifactFactory.class$("org.springframework.webflow.StateExceptionHandler")) : class$org$springframework$webflow$StateExceptionHandler, "Unable to lookup exception handler with id '" + id + "'; state exception handler lookup is not supported by this artifact factory");
    }

    public TargetStateResolver getTargetStateResolver(String id) throws FlowArtifactException {
        throw new FlowArtifactException(id, class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = DefaultFlowArtifactFactory.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver, "Unable to lookup target state resolver with id '" + id + "'; transition target state resolver lookup is not supported by this artifact factory");
    }

    public Flow createFlow(FlowArtifactParameters parameters) throws FlowArtifactException {
        Flow flow = (Flow)this.newInstance(class$org$springframework$webflow$Flow == null ? (class$org$springframework$webflow$Flow = DefaultFlowArtifactFactory.class$("org.springframework.webflow.Flow")) : class$org$springframework$webflow$Flow);
        flow.setId(parameters.getId());
        flow.getAttributeMap().putAll(parameters.getAttributes());
        return flow;
    }

    public State createState(Flow flow, Class stateType, FlowArtifactParameters parameters) throws FlowArtifactException {
        State state = (State)this.newInstance(stateType);
        state.setId(parameters.getId());
        state.setFlow(flow);
        state.getAttributeMap().putAll(parameters.getAttributes());
        return state;
    }

    public Transition createTransition(UnmodifiableAttributeMap attributes) throws FlowArtifactException {
        Transition transition = (Transition)this.newInstance(class$org$springframework$webflow$Transition == null ? (class$org$springframework$webflow$Transition = DefaultFlowArtifactFactory.class$("org.springframework.webflow.Transition")) : class$org$springframework$webflow$Transition);
        transition.getAttributeMap().putAll(attributes);
        return transition;
    }

    private Object newInstance(Class artifactType) {
        return BeanUtils.instantiateClass((Class)artifactType);
    }

    public BeanFactory getServiceRegistry() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Service registry lookup not supported by this artifact factory");
    }

    public ResourceLoader getResourceLoader() throws UnsupportedOperationException {
        if (this.resourceLoader == null) {
            this.setResourceLoader((ResourceLoader)new DefaultResourceLoader());
        }
        return this.resourceLoader;
    }

    public ExpressionParser getExpressionParser() {
        if (this.expressionParser == null) {
            this.setExpressionParser(new DefaultExpressionParserFactory().getExpressionParser());
        }
        return this.expressionParser;
    }

    public ConversionService getConversionService() {
        if (this.conversionService == null) {
            DefaultConversionService service = new DefaultConversionService();
            service.addConverter((Converter)new TextToTransitionCriteria(this));
            service.addConverter((Converter)new TextToViewSelector(this));
            service.addConverter((Converter)new TextToTransitionTargetStateResolver(this));
            service.addConverter((Converter)new TextToExpression(this.getExpressionParser()));
            service.addConverter((Converter)new TextToExpressions(this.getExpressionParser()));
            service.addConverter((Converter)new TextToMethodSignature((ConversionService)service));
            this.setConversionService((ConversionService)service);
        }
        return this.conversionService;
    }

    protected Action toAction(Object artifact, FlowArtifactParameters parameters) {
        if (artifact instanceof Action) {
            return (Action)artifact;
        }
        return new LocalBeanInvokingAction(artifact);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

