/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui.wizard;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.gui.DataSourceDialog;
import com.jaspersoft.jasperserver.irplugin.gui.QualityLabel;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryExplorer;
import com.jaspersoft.jasperserver.irplugin.gui.explorer.ResourceChooser;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.wizard.BaseWizardPanel;
import it.businesslogic.ireport.gui.wizard.GenericWizard;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class NewReportUnitWizard
extends JPanel
implements GenericWizard {
    private String reportFileName = null;
    private BaseWizardPanel wizardPanel = null;
    private JDialog wizardDialog = null;
    private JServer server = null;
    private String parentFolder = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private ResourceDescriptor dataSourceDescriptor = null;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonBrowse;
    private JButton jButtonEditLocalDataSource;
    private JButton jButtonGetCurrentReport;
    private JButton jButtonPickJrxml;
    private JButton jButtonPickResource;
    private JComboBox jComboBoxDatasources;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelResourceFile;
    private JLabel jLabelResourceFile1;
    private JLabel jLabelUriString;
    private JPanel jPanel0;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonLocal;
    private JRadioButton jRadioButtonLocal1;
    private JRadioButton jRadioButtonRepo;
    private JRadioButton jRadioButtonRepo1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldFile;
    private JTextField jTextFieldFileRepo;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUriString;

    public NewReportUnitWizard() {
        this.initComponents();
        this.jTextFieldLabel.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }
        });
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }
        });
        this.jTextFieldFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent evt) {
                if (NewReportUnitWizard.this.wizardPanel != null) {
                    NewReportUnitWizard.this.wizardPanel.updateButtons();
                }
            }
        });
        if (!IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
            this.jPanel2.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(8, 4, 30, 4);
            QualityLabel jlabel = new QualityLabel();
            jlabel.setText("<html><b>" + IRPlugin.getString("reportUnitDialog.useDefaultDatasource", "This server uses a default data source to run the reports and execute queries") + "</b></html>");
            this.jPanel2.add((Component)jlabel, gridBagConstraints);
        }
        if (MainFrame.getMainInstance().getActiveReportFrame() == null) {
            this.jButtonGetCurrentReport.setEnabled(false);
        }
    }

    public void startWizard() {
        this.wizardDialog = new JDialog((Frame)MainFrame.getMainInstance(), true);
        this.wizardPanel = new BaseWizardPanel();
        this.wizardPanel.setGenericWizard((GenericWizard)this);
        this.wizardDialog.getContentPane().add((Component)this.wizardPanel);
        this.wizardDialog.pack();
        this.jTextFieldName.requestFocusInWindow();
        Misc.centerFrame((Component)this.wizardDialog);
        this.wizardDialog.setVisible(true);
    }

    private void initComponents() {
        this.jPanel0 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jLabelDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jLabelResourceFile = new JLabel();
        this.jRadioButtonRepo1 = new JRadioButton();
        this.jTextFieldFileRepo = new JTextField();
        this.jButtonPickJrxml = new JButton();
        this.jRadioButtonLocal1 = new JRadioButton();
        this.jTextFieldFile = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jButtonGetCurrentReport = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabelResourceFile1 = new JLabel();
        this.jRadioButtonRepo = new JRadioButton();
        this.jComboBoxDatasources = new JComboBox();
        this.jButtonPickResource = new JButton();
        this.jRadioButtonLocal = new JRadioButton();
        this.jButtonEditLocalDataSource = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel0.setLayout(new GridBagLayout());
        this.jPanel0.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NewReportUnitWizard.this.jPanel0PropertyChange(evt);
            }
        });
        this.jLabelUriString.setText("Parent folder");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel0.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel0.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel0.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel0.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel0.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel0.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel0.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel0.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel0.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelResourceFile.setText("Locate the main JRXML file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 20, 4);
        this.jPanel1.add((Component)this.jLabelResourceFile, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonRepo1);
        this.jRadioButtonRepo1.setText("From the repository");
        this.jRadioButtonRepo1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jRadioButtonRepo1jRadioButtonRepoActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel1.add((Component)this.jRadioButtonRepo1, gridBagConstraints);
        this.jTextFieldFileRepo.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldFileRepo, gridBagConstraints);
        this.jButtonPickJrxml.setText("Browse");
        this.jButtonPickJrxml.setEnabled(false);
        this.jButtonPickJrxml.setMinimumSize(new Dimension(73, 21));
        this.jButtonPickJrxml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jButtonPickJrxmljButton1ActionPerformed12(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.jPanel1.add((Component)this.jButtonPickJrxml, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonLocal1);
        this.jRadioButtonLocal1.setSelected(true);
        this.jRadioButtonLocal1.setText("Locally Defined");
        this.jRadioButtonLocal1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jRadioButtonLocal1jRadioButtonLocalActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel1.add((Component)this.jRadioButtonLocal1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldFile, gridBagConstraints);
        this.jButtonBrowse.setText("Browse");
        this.jButtonBrowse.setMinimumSize(new Dimension(73, 21));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jButtonBrowseActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.jPanel1.add((Component)this.jButtonBrowse, gridBagConstraints);
        this.jButtonGetCurrentReport.setText("Get source from current opened report");
        this.jButtonGetCurrentReport.setMinimumSize(new Dimension(73, 21));
        this.jButtonGetCurrentReport.setPreferredSize(new Dimension(219, 21));
        this.jButtonGetCurrentReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jButtonGetCurrentReportjButton1ActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.jPanel1.add((Component)this.jButtonGetCurrentReport, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelResourceFile1.setText("Locate the Data Source");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 20, 4);
        this.jPanel2.add((Component)this.jLabelResourceFile1, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonRepo);
        this.jRadioButtonRepo.setText("From the repository");
        this.jRadioButtonRepo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jRadioButtonRepo1jRadioButtonRepoActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel2.add((Component)this.jRadioButtonRepo, gridBagConstraints);
        this.jComboBoxDatasources.setEditable(true);
        this.jComboBoxDatasources.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 4, 2);
        this.jPanel2.add((Component)this.jComboBoxDatasources, gridBagConstraints);
        this.jButtonPickResource.setText("Browse");
        this.jButtonPickResource.setEnabled(false);
        this.jButtonPickResource.setMinimumSize(new Dimension(73, 21));
        this.jButtonPickResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jButtonPickJrxmljButton1ActionPerformed121(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.jPanel2.add((Component)this.jButtonPickResource, gridBagConstraints);
        this.buttonGroup2.add(this.jRadioButtonLocal);
        this.jRadioButtonLocal.setSelected(true);
        this.jRadioButtonLocal.setText("Locally Defined");
        this.jRadioButtonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jRadioButtonLocal1jRadioButtonLocalActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel2.add((Component)this.jRadioButtonLocal, gridBagConstraints);
        this.jButtonEditLocalDataSource.setText("Edit local datasource");
        this.jButtonEditLocalDataSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewReportUnitWizard.this.jButtonEditLocalDataSourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel2.add((Component)this.jButtonEditLocalDataSource, gridBagConstraints);
        this.setLayout(new BorderLayout());
    }

    private void jButtonEditLocalDataSourceActionPerformed(ActionEvent evt) {
        DataSourceDialog dtd = new DataSourceDialog((Frame)MainFrame.getMainInstance(), true);
        dtd.setServer(this.getServer());
        dtd.setParentFolder(this.getParentFolder() + "/<dataSource>");
        dtd.setDoNotStore(true);
        if (this.dataSourceDescriptor != null) {
            dtd.setResource(this.dataSourceDescriptor);
        }
        dtd.setVisible(true);
        if (dtd.getDialogResult() == 0) {
            this.dataSourceDescriptor = dtd.getNewResourceDescriptor();
        }
    }

    private void jRadioButtonLocal1jRadioButtonLocalActionPerformed11(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jButtonPickJrxmljButton1ActionPerformed121(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (!RepositoryExplorer.isDataSource(rd)) {
                JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getString("newReportUnitWizard.selectDatasource", "Please choose a DataSource resource"), "", 2);
                return;
            }
            if (rd == null || rd.getUriString() == null) {
                this.jComboBoxDatasources.setSelectedItem("");
            } else {
                this.jComboBoxDatasources.setSelectedItem(rd.getUriString());
            }
            if (this.wizardPanel != null) {
                this.wizardPanel.updateButtons();
            }
        }
    }

    private void jRadioButtonRepo1jRadioButtonRepoActionPerformed11(ActionEvent evt) {
        this.updateResourceFromType();
    }

    private void jButtonGetCurrentReportjButton1ActionPerformed11(ActionEvent evt) {
        Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        if (report.getFilename() == null) {
            if (JOptionPane.showConfirmDialog(this, IRPlugin.getString("newReportUnitWizard.saveReportNow", "Save the report now?")) == 0) {
                MainFrame.getMainInstance().save(MainFrame.getMainInstance().getActiveReportFrame());
            } else {
                return;
            }
        }
        this.jTextFieldFile.setText(report.getFilename());
    }

    private void jButtonBrowseActionPerformed1(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(MainFrame.getMainInstance().getCurrentDirectory());
        jfc.setDialogTitle(IRPlugin.getString("newReportUnitWizard.pickAFile", "Pick a file..."));
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".xml") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
            }

            public String getDescription() {
                return "JasperReports XML *.xml, *.jrxml";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            this.jTextFieldFile.setText(jfc.getSelectedFile() + "");
            if (this.wizardPanel != null) {
                this.wizardPanel.updateButtons();
            }
        }
    }

    private void jRadioButtonLocal1jRadioButtonLocalActionPerformed1(ActionEvent evt) {
        this.updateJrxmlFromType();
    }

    private void jButtonPickJrxmljButton1ActionPerformed12(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (rd == null || rd.getUriString() == null) {
                this.jTextFieldFileRepo.setText("");
            } else {
                if (!rd.getWsType().equals("jrxml")) {
                    JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getString("newReportUnitWizard.chooseJRXML", "Please choose a JRXML resource"), "", 2);
                    return;
                }
                this.jTextFieldFileRepo.setText(rd.getUriString());
            }
        }
    }

    private void jRadioButtonRepo1jRadioButtonRepoActionPerformed1(ActionEvent evt) {
        this.updateJrxmlFromType();
    }

    private void jPanel0PropertyChange(PropertyChangeEvent evt) {
    }

    public String[] getStepsNames() {
        String[] names = new String[]{IRPlugin.getString("newReportUnitWizard.step.naming", "Naming"), IRPlugin.getString("newReportUnitWizard.step.jrxml", "Main JRXML"), IRPlugin.getString("newReportUnitWizard.step.datasource", "Locate Data Source")};
        return names;
    }

    public String getStepDescription(int step) {
        if (step == 0) {
            return IRPlugin.getString("newReportUnitWizard.stepdesc.naming", "Report name and label");
        }
        if (step == 1) {
            return IRPlugin.getString("newReportUnitWizard.stepdesc.jrxml", "The main JRXML source file");
        }
        if (step == 2) {
            return IRPlugin.getString("newReportUnitWizard.stepdesc.datasource", "Locate the datasource to use with this report");
        }
        if (step == 3) {
            return IRPlugin.getString("newReportUnitWizard.stepdesc.addinputcontrols", "Add input controls and other resources");
        }
        if (step == 4) {
            return IRPlugin.getString("newReportUnitWizard.stepdesc.save", "Save");
        }
        return "";
    }

    public void initWizard() {
    }

    public void finish(int currentStep) {
        if (currentStep > 0) {
            ResourceDescriptor rd = new ResourceDescriptor();
            File resourceFile = null;
            rd.setWsType("reportUnit");
            rd.setDescription(this.jEditorPaneDescription.getText().trim());
            rd.setName(this.jTextFieldName.getText());
            String uri = this.getParentFolder();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + this.jTextFieldName.getText();
            rd.setUriString(uri);
            rd.setLabel(this.jTextFieldLabel.getText().trim());
            rd.setParentFolder(this.getParentFolder());
            rd.setIsNew(true);
            if (IRPlugin.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                ResourceDescriptor tmpDataSourceDescriptor;
                if (this.jRadioButtonRepo.isSelected()) {
                    tmpDataSourceDescriptor = new ResourceDescriptor();
                    tmpDataSourceDescriptor.setWsType("datasource");
                    tmpDataSourceDescriptor.setReferenceUri(this.jComboBoxDatasources.getSelectedItem() + "");
                    tmpDataSourceDescriptor.setIsReference(true);
                } else {
                    if (this.dataSourceDescriptor == null) {
                        JOptionPane.showMessageDialog(this, IRPlugin.getString("newReportUnitWizard.message.datasourceNotDefined", "The local datasource is not correctly defined.\nPress the button \"Edit local datasource\" to fix the problem."));
                        return;
                    }
                    tmpDataSourceDescriptor = this.dataSourceDescriptor;
                    tmpDataSourceDescriptor.setIsReference(false);
                }
                rd.getChildren().add(tmpDataSourceDescriptor);
            }
            ResourceDescriptor jrxmlDescriptor = new ResourceDescriptor();
            jrxmlDescriptor.setWsType("jrxml");
            if (this.jRadioButtonRepo1.isSelected()) {
                jrxmlDescriptor.setIsNew(true);
                jrxmlDescriptor.setMainReport(true);
                jrxmlDescriptor.setIsReference(true);
                jrxmlDescriptor.setReferenceUri(this.jTextFieldFileRepo.getText());
                rd.getChildren().add(jrxmlDescriptor);
            } else {
                jrxmlDescriptor.setName(this.jTextFieldName.getText() + "_jrxml");
                jrxmlDescriptor.setLabel("Main jrxml");
                jrxmlDescriptor.setDescription("Main jrxml");
                jrxmlDescriptor.setIsNew(true);
                jrxmlDescriptor.setHasData(true);
                jrxmlDescriptor.setMainReport(true);
                resourceFile = new File(this.jTextFieldFile.getText());
                if (!resourceFile.exists()) {
                    JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("newReportUnitWizard.message.fileNotFound", "{0}\n\nFile not found!", new Object[]{this.jTextFieldFile.getText()}));
                    return;
                }
                rd.getChildren().add(jrxmlDescriptor);
            }
            try {
                this.newResourceDescriptor = this.getServer().getWSClient().addOrModifyResource(rd, resourceFile);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, IRPlugin.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                ex.printStackTrace();
                return;
            }
        }
        this.getWizardDialog().setVisible(false);
        this.getWizardDialog().dispose();
    }

    public boolean nextStep(int nextStep) {
        if (nextStep == 0 || nextStep == 1 || nextStep == 2) {
            // empty if block
        }
        return true;
    }

    public boolean previousStep(int previousStep) {
        return true;
    }

    public boolean canFinish(int currentStep) {
        if (currentStep < 2) {
            return false;
        }
        if (currentStep == 2) {
            if (this.jRadioButtonRepo.isSelected() && this.jComboBoxDatasources.getSelectedItem() != null && this.jComboBoxDatasources.getSelectedItem().toString().trim().length() > 0) {
                return true;
            }
            if (this.jRadioButtonLocal.isSelected() && this.dataSourceDescriptor != null) {
                return true;
            }
        }
        return true;
    }

    public boolean canNext(int currentStep) {
        if (currentStep == 0) {
            if (this.jTextFieldName.getText().trim().length() > 0 && this.jTextFieldLabel.getText().trim().length() > 0) {
                return true;
            }
        } else if (currentStep == 1) {
            if (this.jRadioButtonRepo1.isSelected() && this.jTextFieldFileRepo.getText().trim().length() > 0) {
                return true;
            }
            if (this.jRadioButtonLocal1.isSelected() && this.jTextFieldFile.getText().trim().length() > 0) {
                return true;
            }
        } else if (currentStep == 2) {
            return false;
        }
        return false;
    }

    public boolean canPrevious(int currentStep) {
        return currentStep > 0;
    }

    public JPanel getStepPanel(int step) {
        if (step == 0) {
            return this.jPanel0;
        }
        if (step == 1) {
            return this.jPanel1;
        }
        if (step == 2) {
            return this.jPanel2;
        }
        return null;
    }

    public BaseWizardPanel getWizardPanel() {
        return this.wizardPanel;
    }

    public void setWizardPanel(BaseWizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public JDialog getWizardDialog() {
        return this.wizardDialog;
    }

    public void setWizardDialog(JDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
    }

    public void updateJrxmlFromType() {
        this.jTextFieldFileRepo.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jButtonPickJrxml.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jTextFieldFile.setEnabled(this.jRadioButtonLocal1.isSelected());
        this.jButtonBrowse.setEnabled(this.jRadioButtonLocal1.isSelected());
        this.jButtonGetCurrentReport.setEnabled(this.jRadioButtonLocal1.isSelected());
        if (this.wizardPanel != null) {
            this.wizardPanel.updateButtons();
        }
    }

    public void updateResourceFromType() {
        this.jComboBoxDatasources.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonPickResource.setEnabled(this.jRadioButtonRepo.isSelected());
        this.jButtonEditLocalDataSource.setEnabled(this.jRadioButtonLocal.isSelected());
        if (this.wizardPanel != null) {
            this.wizardPanel.updateButtons();
        }
    }

    public void setDatasources(List datasources) {
        this.jComboBoxDatasources.removeAllItems();
        for (int i = 0; i < datasources.size(); ++i) {
            Object datasource = datasources.get(i);
            if (datasource instanceof String) {
                this.jComboBoxDatasources.addItem(datasource);
                continue;
            }
            if (!(datasource instanceof ResourceDescriptor)) continue;
            this.jComboBoxDatasources.addItem(((ResourceDescriptor)datasource).getUriString());
        }
        if (this.jComboBoxDatasources.getItemCount() > 0) {
            this.jComboBoxDatasources.setSelectedIndex(0);
        }
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }
}

