/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.selection;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.selection.SelectableFilter;
import com.tonbeller.wcf.selection.SelectionChangeListener;
import com.tonbeller.wcf.selection.SelectionChangeSupport;
import com.tonbeller.wcf.selection.SelectionModel;
import com.tonbeller.wcf.selection.Unselectable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class DefaultSelectionModel
implements SelectionModel {
    Set selection = new HashSet();
    int mode = 2;
    SelectableFilter selectableFilter = null;
    SelectionChangeSupport changeSupport;

    public DefaultSelectionModel() {
        this.changeSupport = new SelectionChangeSupport(this);
    }

    public DefaultSelectionModel(int mode) {
        this.mode = mode;
        this.changeSupport = new SelectionChangeSupport(this);
    }

    public void setComparator(Comparator comp) {
        this.selection = new TreeSet(comp);
    }

    public void add(Object obj) {
        this.selection.add(obj);
    }

    public void remove(Object obj) {
        this.selection.remove(obj);
    }

    public void clear() {
        this.selection.clear();
    }

    public boolean contains(Object obj) {
        return this.selection.contains(obj);
    }

    public int getMode() {
        return this.mode;
    }

    public Set getSelection() {
        return Collections.unmodifiableSet(this.selection);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setSelection(Collection newSelection) {
        this.selection.clear();
        this.selection.addAll(newSelection);
    }

    public void addAll(Collection c) {
        this.selection.addAll(c);
    }

    public boolean isSelectable(Object item) {
        if (item instanceof Unselectable) {
            return false;
        }
        if (this.selectableFilter != null) {
            return this.selectableFilter.isSelectable(item);
        }
        return true;
    }

    public Object getSingleSelection() {
        if (this.selection.isEmpty()) {
            return null;
        }
        if (this.selection.size() == 1) {
            return this.selection.iterator().next();
        }
        throw new IllegalStateException("getSingleSelection: selection contains " + this.selection.size() + " elements");
    }

    public void setSingleSelection(Object selectedObject) {
        this.selection.clear();
        this.selection.add(selectedObject);
    }

    public SelectableFilter getSelectableFilter() {
        return this.selectableFilter;
    }

    public void setSelectableFilter(SelectableFilter filter) {
        this.selectableFilter = filter;
    }

    public void fireSelectionChanged(RequestContext context) {
        this.changeSupport.fireSelectionChanged(context);
    }

    public void addSelectionListener(SelectionChangeListener l) {
        this.changeSupport.addSelectionListener(l);
    }

    public void removeSelectionListener(SelectionChangeListener l) {
        this.changeSupport.removeSelectionListener(l);
    }

    public boolean isEmpty() {
        return this.selection.isEmpty();
    }
}

