/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.convert;

import com.tonbeller.wcf.convert.ConvertException;
import com.tonbeller.wcf.convert.NodeConverterBase;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.ui.FileUploadCtrl;
import com.tonbeller.wcf.utils.XoplonNS;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class FileUploadConverter
extends NodeConverterBase {
    private static Logger logger = Logger.getLogger((Class)FileUploadConverter.class);

    public void convert(Formatter fmt, Map param, Map fileSource, Element element, Object bean) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (FileUploadCtrl.isDisabled(element)) {
            return;
        }
        String id = FileUploadCtrl.getId(element);
        FileItem[] fileItems = (FileItem[])fileSource.get(id);
        if (fileItems != null && fileItems.length > 0) {
            FileItem fileItem = fileItems[0];
            try {
                XoplonNS.removeAttribute(element, "error");
                FileUploadCtrl.setFileName(element, fileItem.getName());
                String model = FileUploadCtrl.getModelReference(element);
                if (bean != null && model.length() > 0) {
                    PropertyUtils.setProperty((Object)bean, (String)model, (Object)fileItem);
                }
            }
            catch (IllegalAccessException e) {
                logger.info((Object)"exception caught", (Throwable)e);
                XoplonNS.setAttribute(element, "error", e.getMessage());
                XoplonNS.setAttribute(element, "value", fileItem.getName());
                throw e;
            }
            catch (NoSuchMethodException e) {
                logger.info((Object)"exception caught", (Throwable)e);
                XoplonNS.setAttribute(element, "error", e.getMessage());
                XoplonNS.setAttribute(element, "value", fileItem.getName());
                throw e;
            }
            catch (InvocationTargetException e) {
                logger.info((Object)"exception caught", (Throwable)e);
                XoplonNS.setAttribute(element, "error", e.getMessage());
                XoplonNS.setAttribute(element, "value", fileItem.getName());
                throw e;
            }
        }
    }

    public void convert(Formatter fmt, Object bean, Element element) throws ConvertException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        try {
            String model = FileUploadCtrl.getModelReference(element);
            if (model.length() == 0) {
                return;
            }
            FileItem value = (FileItem)PropertyUtils.getProperty((Object)bean, (String)model);
            if (value != null) {
                FileUploadCtrl.setFileName(element, value.getName());
            } else {
                FileUploadCtrl.setFileName(element, "");
            }
        }
        catch (IllegalAccessException e) {
            XoplonNS.setAttribute(element, "error", e.getMessage());
            throw e;
        }
        catch (NoSuchMethodException e) {
            XoplonNS.setAttribute(element, "error", e.getMessage());
            throw e;
        }
        catch (InvocationTargetException e) {
            XoplonNS.setAttribute(element, "error", e.getMessage());
            throw e;
        }
    }
}

