/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSchema {
    private static final Logger LOGGER = Logger.getLogger(JdbcSchema.class);
    private static final MondrianResource mres = MondrianResource.instance();
    private static final Map<DataSource, SoftReference<JdbcSchema>> dbMap = new HashMap<DataSource, SoftReference<JdbcSchema>>();
    private static final int SWEEP_COUNT = 10;
    private static int sweepDBCount = 0;
    private static Factory factory;
    public static final int UNKNOWN_COLUMN_USAGE = 1;
    public static final int FOREIGN_KEY_COLUMN_USAGE = 2;
    public static final int MEASURE_COLUMN_USAGE = 4;
    public static final int LEVEL_COLUMN_USAGE = 8;
    public static final int FACT_COUNT_COLUMN_USAGE = 16;
    public static final int IGNORE_COLUMN_USAGE = 32;
    public static final String UNKNOWN_COLUMN_NAME = "UNKNOWN";
    public static final String FOREIGN_KEY_COLUMN_NAME = "FOREIGN_KEY";
    public static final String MEASURE_COLUMN_NAME = "MEASURE";
    public static final String LEVEL_COLUMN_NAME = "LEVEL";
    public static final String FACT_COUNT_COLUMN_NAME = "FACT_COUNT";
    public static final String IGNORE_COLUMN_NAME = "IGNORE";
    private DataSource dataSource;
    private String schema;
    private String catalog;
    private boolean allTablesLoaded;
    private final SortedMap<String, Table> tables = new TreeMap<String, Table>();

    public Logger getLogger() {
        return LOGGER;
    }

    private static void makeFactory() {
        if (factory == null) {
            String classname = MondrianProperties.instance().JdbcFactoryClass.get();
            if (classname == null) {
                factory = new StdFactory();
            } else {
                try {
                    Class<?> clz = Class.forName(classname);
                    factory = (Factory)clz.newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw JdbcSchema.mres.BadJdbcFactoryClassName.ex(classname);
                }
                catch (InstantiationException ex) {
                    throw JdbcSchema.mres.BadJdbcFactoryInstantiation.ex(classname);
                }
                catch (IllegalAccessException ex) {
                    throw JdbcSchema.mres.BadJdbcFactoryAccess.ex(classname);
                }
            }
        }
    }

    public static synchronized JdbcSchema makeDB(DataSource dataSource) {
        JdbcSchema.makeFactory();
        JdbcSchema db = null;
        SoftReference<JdbcSchema> ref = dbMap.get(dataSource);
        if (ref != null) {
            db = ref.get();
        }
        if (db == null) {
            db = factory.makeDB(dataSource);
            dbMap.put(dataSource, new SoftReference<JdbcSchema>(db));
        }
        JdbcSchema.sweepDB();
        return db;
    }

    public static synchronized void clearDB(DataSource dataSource) {
        JdbcSchema.makeFactory();
        SoftReference<JdbcSchema> ref = dbMap.get(dataSource);
        if (ref != null) {
            JdbcSchema db = ref.get();
            if (db != null) {
                factory.clearDB(db);
                db.clear();
            } else {
                dbMap.remove(dataSource);
            }
        }
        JdbcSchema.sweepDB();
    }

    public static synchronized void removeDB(DataSource dataSource) {
        JdbcSchema db;
        JdbcSchema.makeFactory();
        SoftReference<JdbcSchema> ref = dbMap.remove(dataSource);
        if (ref != null && (db = ref.get()) != null) {
            factory.removeDB(db);
            db.remove();
        }
        JdbcSchema.sweepDB();
    }

    private static void sweepDB() {
        if (sweepDBCount++ > 10) {
            Iterator<SoftReference<JdbcSchema>> it = dbMap.values().iterator();
            while (it.hasNext()) {
                SoftReference<JdbcSchema> ref = it.next();
                if (ref != null && ref.get() != null) continue;
                try {
                    it.remove();
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)ex);
                }
            }
            sweepDBCount = 0;
        }
    }

    public static boolean isUniqueColumnType(Set<UsageType> columnType) {
        return columnType.size() == 1;
    }

    public static String convertColumnTypeToName(Set<UsageType> columnType) {
        if (columnType.size() == 1) {
            return columnType.iterator().next().name();
        }
        StringBuilder buf = new StringBuilder();
        int k = 0;
        for (UsageType usage : columnType) {
            if (k++ > 0) {
                buf.append('|');
            }
            buf.append(usage.name());
        }
        return buf.toString();
    }

    public static SqlQuery.Datatype getDatatype(int javaType) {
        switch (javaType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return SqlQuery.Datatype.Integer;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return SqlQuery.Datatype.Numeric;
            }
            case 16: {
                return SqlQuery.Datatype.Boolean;
            }
            case 91: {
                return SqlQuery.Datatype.Date;
            }
            case 92: {
                return SqlQuery.Datatype.Time;
            }
            case 93: {
                return SqlQuery.Datatype.Timestamp;
            }
        }
        return SqlQuery.Datatype.String;
    }

    public static boolean isText(int javaType) {
        switch (javaType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    JdbcSchema(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void load() throws SQLException {
        this.loadTables();
    }

    protected void clear() {
        this.allTablesLoaded = false;
        this.schema = null;
        this.catalog = null;
        this.tables.clear();
    }

    protected void remove() {
        this.clear();
        this.dataSource = null;
    }

    void resetAllTablesLoaded() {
        this.allTablesLoaded = false;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSchemaName(String schema) {
        this.schema = schema;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public void setCatalogName(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalogName() {
        return this.catalog;
    }

    public synchronized Collection<Table> getTables() {
        return this.getTablesMap().values();
    }

    public synchronized Table getTable(String tableName) {
        return (Table)this.getTablesMap().get(tableName);
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "");
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("JdbcSchema:");
        String subprefix = prefix + "  ";
        String subsubprefix = subprefix + "  ";
        pw.print(subprefix);
        pw.println("Tables: [");
        for (Table table : this.getTablesMap().values()) {
            table.print(pw, subsubprefix);
        }
        pw.print(subprefix);
        pw.println("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTables() throws SQLException {
        if (!this.allTablesLoaded) {
            Connection conn = this.getDataSource().getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            String schema = this.getSchemaName();
            String catalog = this.getCatalogName();
            String[] tableTypes = new String[]{"TABLE", "VIEW"};
            String tableName = "%";
            ResultSet rs = null;
            try {
                rs = dmd.getTables(catalog, schema, tableName, tableTypes);
                if (rs != null) {
                    while (rs.next()) {
                        this.addTable(rs);
                    }
                } else {
                    this.getLogger().debug((Object)"ERROR: rs == null");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.allTablesLoaded = true;
        }
    }

    protected void addTable(ResultSet rs) throws SQLException {
        String name = rs.getString(3);
        String tableType = rs.getString(4);
        Table table = new Table(name, tableType);
        this.tables.put(table.getName(), table);
    }

    private SortedMap<String, Table> getTablesMap() {
        return this.tables;
    }

    public static synchronized void clearAllDBs() {
        factory = null;
        JdbcSchema.makeFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Table {
        private final String name;
        private Map<String, Column> columnMap;
        private int totalColumnSize;
        private TableUsageType tableUsageType;
        private final String tableType;
        public MondrianDef.Table table;
        private boolean allColumnsLoaded;

        private Table(String name, String tableType) {
            this.name = name;
            this.tableUsageType = TableUsageType.UNKNOWN;
            this.tableType = tableType;
        }

        public void load() throws SQLException {
            this.loadColumns();
        }

        public String getName() {
            return this.name;
        }

        public int getTotalColumnSize() {
            return this.totalColumnSize;
        }

        public int getNumberOfRows() {
            return -1;
        }

        public Collection<Column> getColumns() {
            return this.getColumnMap().values();
        }

        public Iterator<Column.Usage> getColumnUsages(UsageType usageType) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CTIterator
            implements Iterator<Column.Usage> {
                private final Iterator<Column> columnIter;
                private final UsageType columnType;
                private Iterator<Column.Usage> usageIter;
                private Column.Usage nextObject;

                CTIterator(Collection<Column> columns, UsageType columnType) {
                    this.columnIter = columns.iterator();
                    this.columnType = columnType;
                }

                @Override
                public boolean hasNext() {
                    Column.Usage usage;
                    while (true) {
                        if (this.usageIter == null || !this.usageIter.hasNext()) {
                            if (!this.columnIter.hasNext()) {
                                this.nextObject = null;
                                return false;
                            }
                            Column c = this.columnIter.next();
                            this.usageIter = c.getUsages().iterator();
                            continue;
                        }
                        usage = this.usageIter.next();
                        if (usage.getUsageType() == this.columnType) break;
                    }
                    this.nextObject = usage;
                    return true;
                }

                @Override
                public Column.Usage next() {
                    return this.nextObject;
                }

                @Override
                public void remove() {
                    this.usageIter.remove();
                }
            }
            return new CTIterator(this.getColumns(), usageType);
        }

        public Column getColumn(String columnName) {
            return this.getColumnMap().get(columnName);
        }

        public boolean constainsColumn(String columnName) {
            return this.getColumnMap().containsKey(columnName);
        }

        public void setTableUsageType(TableUsageType tableUsageType) {
            if (this.tableUsageType != TableUsageType.UNKNOWN && this.tableUsageType != tableUsageType) {
                throw mres.AttemptToChangeTableUsage.ex(this.getName(), this.tableUsageType.name(), tableUsageType.name());
            }
            this.tableUsageType = tableUsageType;
        }

        public TableUsageType getTableUsageType() {
            return this.tableUsageType;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.print(this.getName());
            pw.print(", type=");
            pw.print(this.getTableType());
            pw.print(", usage=");
            pw.println(this.getTableUsageType().name());
            pw.print(subprefix);
            pw.print("totalColumnSize=");
            pw.println(this.getTotalColumnSize());
            pw.print(subprefix);
            pw.println("Columns: [");
            for (Column column : this.getColumnMap().values()) {
                column.print(pw, subsubprefix);
                pw.println();
            }
            pw.print(subprefix);
            pw.println("]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadColumns() throws SQLException {
            if (!this.allColumnsLoaded) {
                Connection conn = JdbcSchema.this.getDataSource().getConnection();
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    String schema = JdbcSchema.this.getSchemaName();
                    String catalog = JdbcSchema.this.getCatalogName();
                    String tableName = this.getName();
                    String columnNamePattern = "%";
                    ResultSet rs = null;
                    try {
                        Map<String, Column> map = this.getColumnMap();
                        rs = dmd.getColumns(catalog, schema, tableName, columnNamePattern);
                        while (rs.next()) {
                            String name = rs.getString(4);
                            int type = rs.getInt(5);
                            String typeName = rs.getString(6);
                            int columnSize = rs.getInt(7);
                            int decimalDigits = rs.getInt(9);
                            int numPrecRadix = rs.getInt(10);
                            int charOctetLength = rs.getInt(16);
                            String isNullable = rs.getString(18);
                            Column column = new Column(name);
                            column.setType(type);
                            column.setTypeName(typeName);
                            column.setColumnSize(columnSize);
                            column.setDecimalDigits(decimalDigits);
                            column.setNumPrecRadix(numPrecRadix);
                            column.setCharOctetLength(charOctetLength);
                            column.setIsNullable(!"NO".equals(isNullable));
                            map.put(name, column);
                            this.totalColumnSize += column.getColumnSize();
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
                this.allColumnsLoaded = true;
            }
        }

        private Map<String, Column> getColumnMap() {
            if (this.columnMap == null) {
                this.columnMap = new HashMap<String, Column>();
            }
            return this.columnMap;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Column {
            private final String name;
            private int type;
            private String typeName;
            private int columnSize;
            private int decimalDigits;
            private int numPrecRadix;
            private int charOctetLength;
            private boolean isNullable;
            public final MondrianDef.Column column;
            private final List<Usage> usages;
            private final Set<UsageType> usageTypes = Util.enumSetNoneOf(UsageType.class);

            private Column(String name) {
                this.name = name;
                this.column = new MondrianDef.Column(Table.this.getName(), name);
                this.usages = new ArrayList<Usage>();
            }

            public String getName() {
                return this.name;
            }

            private void setType(int type) {
                this.type = type;
            }

            public int getType() {
                return this.type;
            }

            private void setTypeName(String typeName) {
                this.typeName = typeName;
            }

            public String getTypeName() {
                return this.typeName;
            }

            public Table getTable() {
                return Table.this;
            }

            public SqlQuery.Datatype getDatatype() {
                return JdbcSchema.getDatatype(this.getType());
            }

            private void setColumnSize(int columnSize) {
                this.columnSize = columnSize;
            }

            public int getColumnSize() {
                return this.columnSize;
            }

            private void setDecimalDigits(int decimalDigits) {
                this.decimalDigits = decimalDigits;
            }

            public int getDecimalDigits() {
                return this.decimalDigits;
            }

            private void setNumPrecRadix(int numPrecRadix) {
                this.numPrecRadix = numPrecRadix;
            }

            public int getNumPrecRadix() {
                return this.numPrecRadix;
            }

            private void setCharOctetLength(int charOctetLength) {
                this.charOctetLength = charOctetLength;
            }

            public int getCharOctetLength() {
                return this.charOctetLength;
            }

            private void setIsNullable(boolean isNullable) {
                this.isNullable = isNullable;
            }

            public boolean isNullable() {
                return this.isNullable;
            }

            public int numberOfUsages() {
                return this.usages.size();
            }

            public boolean hasUsage() {
                return this.usages.size() != 0;
            }

            public boolean hasUsage(UsageType columnType) {
                return this.usageTypes.contains((Object)columnType);
            }

            public List<Usage> getUsages() {
                return this.usages;
            }

            public Iterator<Usage> getUsages(UsageType usageType) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ColumnTypeIterator
                implements Iterator<Usage> {
                    private final Iterator<Usage> usageIter;
                    private final UsageType usageType;
                    private Usage nextUsage;

                    ColumnTypeIterator(List<Usage> usages, UsageType columnType) {
                        this.usageIter = usages.iterator();
                        this.usageType = columnType;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.usageIter.hasNext()) {
                            Usage usage = this.usageIter.next();
                            if (usage.getUsageType() != this.usageType) continue;
                            this.nextUsage = usage;
                            return true;
                        }
                        this.nextUsage = null;
                        return false;
                    }

                    @Override
                    public Usage next() {
                        return this.nextUsage;
                    }

                    @Override
                    public void remove() {
                        this.usageIter.remove();
                    }
                }
                return new ColumnTypeIterator(this.getUsages(), usageType);
            }

            public Usage newUsage(UsageType usageType) {
                this.usageTypes.add(usageType);
                Usage usage = new Usage(usageType);
                this.usages.add(usage);
                return usage;
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                pw.print(prefix);
                pw.print("name=");
                pw.print(this.getName());
                pw.print(", typename=");
                pw.print(this.getTypeName());
                pw.print(", size=");
                pw.print(this.getColumnSize());
                switch (this.getType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        pw.print(", decimalDigits=");
                        pw.print(this.getDecimalDigits());
                        pw.print(", numPrecRadix=");
                        pw.print(this.getNumPrecRadix());
                        break;
                    }
                    case 1: 
                    case 12: {
                        pw.print(", charOctetLength=");
                        pw.print(this.getCharOctetLength());
                        break;
                    }
                }
                pw.print(", isNullable=");
                pw.print(this.isNullable());
                if (this.hasUsage()) {
                    pw.print(" Usages [");
                    for (Usage usage : this.getUsages()) {
                        pw.print('(');
                        usage.print(pw, prefix);
                        pw.print(')');
                    }
                    pw.println("]");
                }
            }

            public class Usage {
                private final UsageType usageType;
                private String symbolicName;
                private RolapAggregator aggregator;
                public RolapStar.Measure rMeasure;
                public MondrianDef.Relation relation;
                public MondrianDef.Expression joinExp;
                public String levelColumnName;
                public RolapStar.Column rColumn;
                public RolapStar.Table rTable;
                public String rightJoinConditionColumnName;
                public String usagePrefix;

                Usage(UsageType usageType) {
                    this.usageType = usageType;
                }

                public Column getColumn() {
                    return Column.this;
                }

                public UsageType getUsageType() {
                    return this.usageType;
                }

                public void setSymbolicName(String symbolicName) {
                    this.symbolicName = symbolicName;
                }

                public String getSymbolicName() {
                    return this.symbolicName;
                }

                public void setAggregator(RolapAggregator aggregator) {
                    this.aggregator = aggregator;
                }

                public RolapAggregator getAggregator() {
                    return this.aggregator;
                }

                public String toString() {
                    StringWriter sw = new StringWriter(64);
                    PrintWriter pw = new PrintWriter(sw);
                    this.print(pw, "");
                    pw.flush();
                    return sw.toString();
                }

                public void print(PrintWriter pw, String prefix) {
                    if (this.getSymbolicName() != null) {
                        pw.print("symbolicName=");
                        pw.print(this.getSymbolicName());
                    }
                    if (this.getAggregator() != null) {
                        pw.print(", aggregator=");
                        pw.print(this.getAggregator().getName());
                    }
                    pw.print(", columnType=");
                    pw.print(this.getUsageType().name());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TableUsageType {
        UNKNOWN,
        FACT,
        AGG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UsageType {
        UNKNOWN,
        FOREIGN_KEY,
        MEASURE,
        LEVEL,
        FACT_COUNT,
        IGNORE;

    }

    public static class StdFactory
    implements Factory {
        StdFactory() {
        }

        public JdbcSchema makeDB(DataSource dataSource) {
            JdbcSchema db = new JdbcSchema(dataSource);
            return db;
        }

        public void clearDB(JdbcSchema db) {
        }

        public void removeDB(JdbcSchema db) {
        }
    }

    public static interface Factory {
        public JdbcSchema makeDB(DataSource var1);

        public void clearDB(JdbcSchema var1);

        public void removeDB(JdbcSchema var1);
    }
}

