/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.ResultStyle;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellReader;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.sql.SqlQuery;
import mondrian.util.Format;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapEvaluator
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(RolapEvaluator.class);
    private static final Object nullResult = new Object();
    private final RolapMember[] currentMembers;
    private final Evaluator parent;
    protected CellReader cellReader;
    private final int depth;
    private Member expandingMember;
    private boolean nonEmpty;
    protected final RolapEvaluatorRoot root;
    private int iterationLength;
    private boolean evalAxes;
    private final Member[] calcMembers;
    private int calcMemberCount;
    protected List<List<RolapMember>> aggregationLists;
    private final List<Member> slicerMembers;
    private final MondrianProperties.SolveOrderModeEnum solveOrderMode;

    protected RolapEvaluator(RolapEvaluatorRoot root, RolapEvaluator parent) {
        this.solveOrderMode = Util.lookup(MondrianProperties.SolveOrderModeEnum.class, MondrianProperties.instance().SolveOrderMode.get().toUpperCase(), MondrianProperties.SolveOrderModeEnum.ABSOLUTE);
        this.iterationLength = 1;
        this.root = root;
        this.parent = parent;
        if (parent == null) {
            this.depth = 0;
            this.nonEmpty = false;
            this.evalAxes = false;
            this.cellReader = null;
            this.currentMembers = new RolapMember[root.cube.getDimensions().length];
            this.calcMembers = new Member[this.currentMembers.length];
            this.calcMemberCount = 0;
            this.slicerMembers = new ArrayList<Member>();
            this.aggregationLists = null;
        } else {
            this.depth = parent.depth + 1;
            this.nonEmpty = parent.nonEmpty;
            this.evalAxes = parent.evalAxes;
            this.cellReader = parent.cellReader;
            this.currentMembers = (RolapMember[])parent.currentMembers.clone();
            this.calcMembers = (Member[])parent.calcMembers.clone();
            this.calcMemberCount = parent.calcMemberCount;
            this.slicerMembers = new ArrayList<Member>(parent.slicerMembers);
            this.aggregationLists = parent.aggregationLists != null ? new ArrayList<List<RolapMember>>(parent.aggregationLists) : null;
        }
    }

    public RolapEvaluator(RolapEvaluatorRoot root) {
        this(root, null);
        Dimension[] dimensions;
        SchemaReader scr = this.root.schemaReader;
        for (Dimension dimension : dimensions = this.root.cube.getDimensions()) {
            int ordinal = dimension.getOrdinal(this.root.cube);
            Hierarchy hier = dimension.getHierarchy();
            RolapMember member = (RolapMember)scr.getHierarchyDefaultMember(hier);
            if (member == null) {
                throw MondrianResource.instance().InvalidHierarchyCondition.ex(hier.getUniqueName());
            }
            HierarchyUsage hierarchyUsage = this.root.cube.getFirstUsage(hier);
            if (hierarchyUsage != null) {
                member.makeUniqueName(hierarchyUsage);
            }
            this.currentMembers[ordinal] = member;
            if (!member.isCalculated()) continue;
            this.addCalcMember(member);
        }
        root.init(this);
    }

    public static Evaluator create(Query query) {
        RolapEvaluatorRoot root = new RolapEvaluatorRoot(query);
        return new RolapEvaluator(root);
    }

    @Override
    public RolapCube getMeasureCube() {
        RolapCube measureCube = null;
        if (this.currentMembers[0] instanceof RolapStoredMeasure) {
            measureCube = ((RolapStoredMeasure)((Object)this.currentMembers[0])).getCube();
        }
        return measureCube;
    }

    @Override
    public boolean needToReturnNullForUnrelatedDimension(Member[] members) {
        RolapCube virtualCube = this.getCube();
        RolapCube baseCube = this.getMeasureCube();
        if (virtualCube.isVirtual() && baseCube != null) {
            Set<Dimension> nonJoiningDimensions;
            if (virtualCube.shouldIgnoreUnrelatedDimensions(baseCube.getName())) {
                return false;
            }
            if (MondrianProperties.instance().IgnoreMeasureForNonJoiningDimension.get() && !(nonJoiningDimensions = baseCube.nonJoiningDimensions(members)).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    protected final Logger getLogger() {
        return LOGGER;
    }

    @Override
    public final Member[] getMembers() {
        return this.currentMembers;
    }

    public final List<List<RolapMember>> getAggregationLists() {
        return this.aggregationLists;
    }

    final void setCellReader(CellReader cellReader) {
        this.cellReader = cellReader;
    }

    @Override
    public final RolapCube getCube() {
        return this.root.cube;
    }

    @Override
    public final Query getQuery() {
        return this.root.query;
    }

    @Override
    public final int getDepth() {
        return this.depth;
    }

    @Override
    public final Evaluator getParent() {
        return this.parent;
    }

    @Override
    public final SchemaReader getSchemaReader() {
        return this.root.schemaReader;
    }

    @Override
    public Date getQueryStartTime() {
        return this.root.getQueryStartTime();
    }

    public SqlQuery.Dialect getDialect() {
        return this.root.currentDialect;
    }

    @Override
    public final RolapEvaluator push(Member[] members) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push(Member member) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push() {
        return this._push();
    }

    protected RolapEvaluator _push() {
        this.getQuery().checkCancelOrTimeout();
        return new RolapEvaluator(this.root, this);
    }

    @Override
    public final Evaluator pop() {
        return this.parent;
    }

    public final Evaluator pushAggregation(List list) {
        RolapEvaluator newEvaluator = this._push();
        newEvaluator.addToAggregationList(list);
        this.clearHierarchyFromRegularContext(list, newEvaluator);
        return newEvaluator;
    }

    private void addToAggregationList(List list) {
        if (this.aggregationLists == null) {
            this.aggregationLists = new ArrayList<List<RolapMember>>();
        }
        this.aggregationLists.add(list);
    }

    private void clearHierarchyFromRegularContext(List list, RolapEvaluator newEvaluator) {
        if (this.containsTuple(list)) {
            Member[] tuple;
            for (Member member : tuple = (Member[])list.get(0)) {
                newEvaluator.setContext(member.getHierarchy().getAllMember());
            }
        } else {
            newEvaluator.setContext(((RolapMember)list.get(0)).getHierarchy().getAllMember());
        }
    }

    private boolean containsTuple(List rolapList) {
        return rolapList.get(0) instanceof Member[];
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof RolapEvaluator)) {
            return false;
        }
        RolapEvaluator that = (RolapEvaluator)obj;
        return Arrays.equals(this.currentMembers, that.currentMembers);
    }

    public final int hashCode() {
        return Util.hashArray(0, this.currentMembers);
    }

    public final void setSlicerContext(Member member) {
        this.setContext(member);
        this.slicerMembers.add(member);
    }

    public final List<Member> getSlicerMembers() {
        return this.slicerMembers;
    }

    @Override
    public final Member setContext(Member member) {
        RolapMember m = (RolapMember)member;
        int ordinal = m.getDimension().getOrdinal(this.root.cube);
        RolapMember previous = this.currentMembers[ordinal];
        if (m.equals((OlapElement)previous)) {
            return m;
        }
        if (previous.isCalculated()) {
            this.removeCalcMember(previous);
        }
        this.currentMembers[ordinal] = m;
        if (m.isCalculated()) {
            this.addCalcMember(m);
        }
        return previous;
    }

    @Override
    public final void setContext(List<Member> memberList) {
        int i = 0;
        for (Member member : memberList) {
            if (member == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapEvaluator.setContext: member == null  , count=" + i));
                }
                assert (false);
            } else {
                this.setContext(member);
            }
            ++i;
        }
    }

    @Override
    public final void setContext(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            Member member = members[i];
            if (member == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapEvaluator.setContext: member == null  , count=" + i));
                }
                assert (false);
                continue;
            }
            this.setContext(member);
        }
    }

    @Override
    public final RolapMember getContext(Dimension dimension) {
        return this.currentMembers[dimension.getOrdinal(this.root.cube)];
    }

    @Override
    public final Object evaluateCurrent() {
        Member maxSolveMember = this.peekCalcMember();
        if (maxSolveMember == null) {
            Object o = this.cellReader.get(this);
            if (o == Util.nullValue) {
                return null;
            }
            return o;
        }
        RolapMember defaultMember = this.root.defaultMembers[maxSolveMember.getDimension().getOrdinal(this.root.cube)];
        RolapEvaluator evaluator = this.push(defaultMember);
        evaluator.setExpanding(maxSolveMember);
        Exp exp = maxSolveMember.getExpression();
        Calc calc = this.root.getCompiled(exp, true, null);
        Object o = calc.evaluate(evaluator);
        if (o == Util.nullValue) {
            return null;
        }
        return o;
    }

    private void setExpanding(Member member) {
        this.expandingMember = member;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            RolapEvaluator.checkRecursion((RolapEvaluator)this.parent);
        }
    }

    Member getExpanding() {
        return this.expandingMember;
    }

    private static void checkRecursion(RolapEvaluator eval) {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.expandingMember != null) break;
            eval = (RolapEvaluator)eval.getParent();
        }
        block1: for (RolapEvaluator eval2 = (RolapEvaluator)eval.getParent(); eval2 != null; eval2 = (RolapEvaluator)eval2.getParent()) {
            if (eval2.expandingMember != eval.expandingMember) continue;
            for (int i = 0; i < eval.currentMembers.length; ++i) {
                RolapMember member = eval2.currentMembers[i];
                if (member == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("RolapEvaluator.checkRecursion: member == null  , count=" + i));
                    continue;
                }
                RolapMember parentMember = eval.getContext(member.getDimension());
                if (member != parentMember) continue block1;
            }
            throw FunUtil.newEvalException(null, "Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuilder buf = new StringBuilder("{");
        int frameCount = 0;
        for (RolapEvaluator eval = this; eval != null; eval = (RolapEvaluator)eval.getParent()) {
            if (eval.expandingMember == null) continue;
            if (frameCount++ > 0) {
                buf.append(", ");
            }
            buf.append("(");
            int memberCount = 0;
            for (RolapMember m : eval.currentMembers) {
                if (m == m.getHierarchy().getDefaultMember()) continue;
                if (memberCount++ > 0) {
                    buf.append(", ");
                }
                buf.append(m.getUniqueName());
            }
            buf.append(")");
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public final Object getProperty(String name, Object defaultValue) {
        Object o = defaultValue;
        int maxSolve = Integer.MIN_VALUE;
        for (int i = 0; i < this.currentMembers.length; ++i) {
            int solve;
            RolapMember member = this.currentMembers[i];
            if (member == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("RolapEvaluator.getProperty: member == null  , count=" + i));
                continue;
            }
            Object p = member.getPropertyValue(name);
            if (p == null || (solve = member.getSolveOrder()) <= maxSolve) continue;
            o = p;
            maxSolve = solve;
        }
        return o;
    }

    @Override
    public final String getFormatString() {
        Exp formatExp = (Exp)this.getProperty(Property.FORMAT_EXP.name, null);
        if (formatExp == null) {
            return "Standard";
        }
        Calc formatCalc = this.root.getCompiled(formatExp, true, null);
        Object o = formatCalc.evaluate(this);
        if (o == null) {
            return "Standard";
        }
        return o.toString();
    }

    private Format getFormat() {
        String formatString = this.getFormatString();
        return this.getFormat(formatString);
    }

    private Format getFormat(String formatString) {
        return Format.get(formatString, this.root.connection.getLocale());
    }

    @Override
    public final Locale getConnectionLocale() {
        return this.root.connection.getLocale();
    }

    @Override
    public final String format(Object o) {
        if (o == Util.nullValue) {
            Format format = this.getFormat();
            return format.format(null);
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        Format format = this.getFormat();
        return format.format(o);
    }

    @Override
    public final String format(Object o, String formatString) {
        if (o == Util.nullValue) {
            Format format = this.getFormat(formatString);
            return format.format(null);
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        Format format = this.getFormat(formatString);
        return format.format(o);
    }

    private Object getExpResultCacheKey(ExpCacheDescriptor descriptor) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(descriptor.getExp());
        int[] dimensionOrdinals = descriptor.getDependentDimensionOrdinals();
        for (int i = 0; i < dimensionOrdinals.length; ++i) {
            int dimensionOrdinal = dimensionOrdinals[i];
            RolapMember member = this.currentMembers[dimensionOrdinal];
            if (member == null) {
                this.getLogger().debug((Object)("RolapEvaluator.getExpResultCacheKey: member == null; dimensionOrdinal=" + i));
                continue;
            }
            key.add(member);
        }
        return key;
    }

    @Override
    public final Object getCachedResult(ExpCacheDescriptor cacheDescriptor) {
        Object key = this.getExpResultCacheKey(cacheDescriptor);
        Object result = this.root.getCacheResult(key);
        if (result == null) {
            boolean aggCacheDirty = this.cellReader.isDirty();
            int aggregateCacheMissCountBefore = this.cellReader.getMissCount();
            result = cacheDescriptor.evaluate(this);
            int aggregateCacheMissCountAfter = this.cellReader.getMissCount();
            boolean isValidResult = !aggCacheDirty && aggregateCacheMissCountBefore == aggregateCacheMissCountAfter;
            this.root.putCacheResult(key, result == null ? nullResult : result, isValidResult);
        } else if (result == nullResult) {
            result = null;
        }
        return result;
    }

    public final void clearExpResultCache(boolean clearValidResult) {
        this.root.clearResultCache(clearValidResult);
    }

    @Override
    public final boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public final void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    @Override
    public final RuntimeException newEvalException(Object context, String s) {
        return FunUtil.newEvalException((FunDef)context, s);
    }

    @Override
    public final Object evaluateNamedSet(String name, Exp exp) {
        return this.root.evaluateNamedSet(name, exp);
    }

    @Override
    public final int getMissCount() {
        return this.cellReader.getMissCount();
    }

    @Override
    public final Object getParameterValue(ParameterSlot slot) {
        return this.root.getParameterValue(slot);
    }

    final void addCalcMember(Member member) {
        assert (member != null);
        assert (member.isCalculated());
        this.calcMembers[this.calcMemberCount++] = member;
    }

    private Member peekCalcMember() {
        switch (this.calcMemberCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.calcMembers[0];
            }
        }
        switch (this.solveOrderMode) {
            case ABSOLUTE: {
                return this.getAbsoluteMaxSolveOrder(this.calcMembers);
            }
            case SCOPED: {
                return this.getScopedMaxSolveOrder(this.calcMembers);
            }
        }
        throw Util.unexpected(this.solveOrderMode);
    }

    private Member getAbsoluteMaxSolveOrder(Member[] calcMembers) {
        Member maxSolveMember = calcMembers[0];
        int maxSolve = maxSolveMember.getSolveOrder();
        for (int i = 1; i < this.calcMemberCount; ++i) {
            Member member = calcMembers[i];
            int solve = member.getSolveOrder();
            if (solve < maxSolve || solve <= maxSolve && member.getDimension().getOrdinal(this.root.cube) >= maxSolveMember.getDimension().getOrdinal(this.root.cube)) continue;
            maxSolve = solve;
            maxSolveMember = member;
        }
        return maxSolveMember;
    }

    private Member getScopedMaxSolveOrder(Member[] calcMembers) {
        Member maxSolveMember = null;
        ScopedMaxSolveOrderFinderState state = ScopedMaxSolveOrderFinderState.START;
        block6: for (int i = 0; i < this.calcMemberCount; ++i) {
            Member member = calcMembers[i];
            switch (state) {
                case START: {
                    maxSolveMember = member;
                    if (this.foundAggregateFunction(maxSolveMember.getExpression())) {
                        state = ScopedMaxSolveOrderFinderState.AGG_SCOPE;
                        continue block6;
                    }
                    if (maxSolveMember.isCalculatedInQuery()) {
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    continue block6;
                }
                case AGG_SCOPE: {
                    if (this.foundAggregateFunction(member.getExpression())) {
                        if (member.getSolveOrder() <= maxSolveMember.getSolveOrder() && (member.getSolveOrder() != maxSolveMember.getSolveOrder() || member.getDimension().getOrdinal(this.root.cube) >= maxSolveMember.getDimension().getOrdinal(this.root.cube))) continue block6;
                        maxSolveMember = member;
                        continue block6;
                    }
                    if (member.isCalculatedInQuery()) {
                        maxSolveMember = member;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    maxSolveMember = member;
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    continue block6;
                }
                case CUBE_SCOPE: {
                    if (this.foundAggregateFunction(member.getExpression())) continue block6;
                    if (member.isCalculatedInQuery()) {
                        maxSolveMember = member;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    if (member.getSolveOrder() <= maxSolveMember.getSolveOrder() && (member.getSolveOrder() != maxSolveMember.getSolveOrder() || member.getDimension().getOrdinal(this.root.cube) >= maxSolveMember.getDimension().getOrdinal(this.root.cube))) continue block6;
                    maxSolveMember = member;
                    continue block6;
                }
                case QUERY_SCOPE: {
                    if (this.foundAggregateFunction(member.getExpression()) || !member.isCalculatedInQuery() || member.getSolveOrder() <= maxSolveMember.getSolveOrder() && (member.getSolveOrder() != maxSolveMember.getSolveOrder() || member.getDimension().getOrdinal(this.root.cube) >= maxSolveMember.getDimension().getOrdinal(this.root.cube))) continue block6;
                    maxSolveMember = member;
                }
            }
        }
        return maxSolveMember;
    }

    private boolean foundAggregateFunction(Exp exp) {
        if (exp instanceof ResolvedFunCall) {
            ResolvedFunCall resolvedFunCall = (ResolvedFunCall)exp;
            if (resolvedFunCall.getFunDef() instanceof AggregateFunDef) {
                return true;
            }
            for (Exp argExp : resolvedFunCall.getArgs()) {
                if (!this.foundAggregateFunction(argExp)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeCalcMember(Member previous) {
        for (int i = 0; i < this.calcMemberCount; ++i) {
            Member calcMember = this.calcMembers[i];
            if (calcMember != previous) continue;
            --this.calcMemberCount;
            this.calcMembers[i] = this.calcMembers[this.calcMemberCount];
            this.calcMembers[this.calcMemberCount] = null;
        }
    }

    @Override
    public final int getIterationLength() {
        return this.iterationLength;
    }

    @Override
    public final void setIterationLength(int length) {
        this.iterationLength = length;
    }

    @Override
    public final boolean isEvalAxes() {
        return this.evalAxes;
    }

    @Override
    public final void setEvalAxes(boolean evalAxes) {
        this.evalAxes = evalAxes;
    }

    @Override
    public boolean shouldIgnoreUnrelatedDimensions() {
        return this.getCube().shouldIgnoreUnrelatedDimensions(this.getMeasureCube().getName());
    }

    protected static class RolapEvaluatorRoot {
        final Map<Object, Object> expResultCache = new HashMap<Object, Object>();
        final Map<Object, Object> tmpExpResultCache = new HashMap<Object, Object>();
        final RolapCube cube;
        final RolapConnection connection;
        final SchemaReader schemaReader;
        final Map<List<Object>, Calc> compiledExps = new HashMap<List<Object>, Calc>();
        private final Query query;
        private final Date queryStartTime;
        final SqlQuery.Dialect currentDialect;
        private final RolapMember[] defaultMembers;

        public RolapEvaluatorRoot(Query query) {
            this.query = query;
            this.cube = (RolapCube)query.getCube();
            this.connection = (RolapConnection)query.getConnection();
            this.schemaReader = query.getSchemaReader(true);
            this.queryStartTime = new Date();
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            for (Dimension dimension : this.cube.getDimensions()) {
                list.add((RolapMember)this.schemaReader.getHierarchyDefaultMember(dimension.getHierarchy()));
            }
            this.defaultMembers = list.toArray(new RolapMember[list.size()]);
            this.currentDialect = SqlQuery.Dialect.create(this.schemaReader.getDataSource());
        }

        final Calc getCompiled(Exp exp, boolean scalar, ResultStyle resultStyle) {
            List<Object> key = Arrays.asList(new Object[]{exp, scalar, resultStyle});
            Calc calc = this.compiledExps.get(key);
            if (calc == null) {
                calc = this.query.compileExpression(exp, scalar, resultStyle);
                this.compiledExps.put(key, calc);
            }
            return calc;
        }

        protected Object evaluateNamedSet(String name, Exp exp) {
            throw new UnsupportedOperationException();
        }

        protected void init(Evaluator evaluator) {
        }

        public Object getParameterValue(ParameterSlot slot) {
            throw new UnsupportedOperationException();
        }

        public final void putCacheResult(Object key, Object result, boolean isValidResult) {
            if (isValidResult) {
                this.expResultCache.put(key, result);
            } else {
                this.tmpExpResultCache.put(key, result);
            }
        }

        public final Object getCacheResult(Object key) {
            Object result = this.expResultCache.get(key);
            if (result == null) {
                result = this.tmpExpResultCache.get(key);
            }
            return result;
        }

        public final void clearResultCache(boolean clearValidResult) {
            if (clearValidResult) {
                this.expResultCache.clear();
            }
            this.tmpExpResultCache.clear();
        }

        public Date getQueryStartTime() {
            return this.queryStartTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScopedMaxSolveOrderFinderState {
        START,
        AGG_SCOPE,
        CUBE_SCOPE,
        QUERY_SCOPE;

    }
}

