/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.vba;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.InvalidArgumentException;
import mondrian.olap.Util;
import mondrian.olap.fun.JavaFunDef;

public class Vba {
    private static final long MILLIS_IN_A_DAY = 86400000L;
    private static final DateFormatSymbols DATE_FORMAT_SYMBOLS = new DateFormatSymbols(Locale.getDefault());

    @JavaFunDef.FunctionName(value="CBool")
    @JavaFunDef.Signature(value="CBool(expression)")
    @JavaFunDef.Description(value="Returns an expression that has been converted to a Variant of subtype Boolean.")
    public static boolean cBool(Object expression) {
        if (expression instanceof Boolean) {
            return (Boolean)expression;
        }
        int i = Vba.cInt(expression);
        return i != 0;
    }

    @JavaFunDef.FunctionName(value="CByte")
    @JavaFunDef.Signature(value="CByte(expression)")
    @JavaFunDef.Description(value="Returns an expression that has been converted to a Variant of subtype Byte.")
    public static byte cByte(Object expression) {
        if (expression instanceof Byte) {
            return (Byte)expression;
        }
        int i = Vba.cInt(expression);
        return (byte)i;
    }

    @JavaFunDef.FunctionName(value="CDate")
    @JavaFunDef.Signature(value="CDate(date)")
    @JavaFunDef.Description(value="Returns an expression that has been converted to a Variant of subtype Date.")
    public static Date cDate(Object expression) {
        String str = String.valueOf(expression);
        if (expression instanceof Date) {
            return (Date)expression;
        }
        if (expression == null) {
            return null;
        }
        try {
            return DateFormat.getTimeInstance().parse(str);
        }
        catch (ParseException ex0) {
            try {
                return DateFormat.getDateTimeInstance().parse(str);
            }
            catch (ParseException ex1) {
                try {
                    return DateFormat.getDateInstance().parse(str);
                }
                catch (ParseException ex2) {
                    throw new InvalidArgumentException("Invalid parameter. expression parameter of CDate function must be formatted correctly (" + String.valueOf(expression) + ")");
                }
            }
        }
    }

    @JavaFunDef.FunctionName(value="CDbl")
    @JavaFunDef.Signature(value="CDbl(expression)")
    @JavaFunDef.Description(value="Returns an expression that has been converted to a Variant of subtype Double.")
    public static double cDbl(Object expression) {
        if (expression instanceof Number) {
            Number number = (Number)expression;
            return number.doubleValue();
        }
        String s = String.valueOf(expression);
        return new Double(s).intValue();
    }

    @JavaFunDef.FunctionName(value="CInt")
    @JavaFunDef.Signature(value="CInt(expression)")
    @JavaFunDef.Description(value="Returns an expression that has been converted to a Variant of subtype Integer.")
    public static int cInt(Object expression) {
        if (expression instanceof Number) {
            Number number = (Number)expression;
            int intValue = number.intValue();
            if (number instanceof Float || number instanceof Double) {
                double doubleValue = number.doubleValue();
                if (doubleValue == (double)intValue) {
                    return intValue;
                }
                double doubleDouble = doubleValue * 2.0;
                if (doubleDouble == Math.floor(doubleDouble)) {
                    return (int)Math.round(doubleValue / 2.0) * 2;
                }
                return (int)Math.round(doubleValue);
            }
            return intValue;
        }
        String s = String.valueOf(expression);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return new Double(s).intValue();
        }
    }

    @JavaFunDef.FunctionName(value="Fix")
    @JavaFunDef.Signature(value="Fix(number)")
    @JavaFunDef.Description(value="Returns the integer portion of a number. If negative, returns the negative number greater than or equal to the number.")
    public static int fix(Object number) {
        if (number instanceof Number) {
            int v = ((Number)number).intValue();
            double dv = ((Number)number).doubleValue();
            if (v < 0 && (double)v < dv) {
                ++v;
            }
            return v;
        }
        throw new InvalidArgumentException("Invalid parameter. number parameter " + number + " of Int function must be " + "of type number");
    }

    @JavaFunDef.FunctionName(value="Hex")
    @JavaFunDef.Description(value="Returns a String representing the hexadecimal value of a number.")
    @JavaFunDef.Signature(value="Hex(number)")
    public static String hex(Object number) {
        if (number instanceof Number) {
            return Integer.toHexString(((Number)number).intValue()).toUpperCase();
        }
        throw new InvalidArgumentException("Invalid parameter. number parameter " + number + " of Hex function must be " + "of type number");
    }

    @JavaFunDef.FunctionName(value="Int")
    @JavaFunDef.Signature(value="Int(number)")
    @JavaFunDef.Description(value="Returns the integer portion of a number. If negative, returns the negative number less than or equal to the number.")
    public static int int_(Object number) {
        if (number instanceof Number) {
            int v = ((Number)number).intValue();
            double dv = ((Number)number).doubleValue();
            if (v < 0 && (double)v > dv) {
                --v;
            }
            return v;
        }
        throw new InvalidArgumentException("Invalid parameter. number parameter " + number + " of Int function must be " + "of type number");
    }

    @JavaFunDef.FunctionName(value="Oct")
    @JavaFunDef.Signature(value="Oct(number)")
    @JavaFunDef.Description(value="Returns a Variant (String) representing the octal value of a number.")
    public static String oct(Object number) {
        if (number instanceof Number) {
            return Integer.toOctalString(((Number)number).intValue());
        }
        throw new InvalidArgumentException("Invalid parameter. number parameter " + number + " of Oct function must be " + "of type number");
    }

    @JavaFunDef.FunctionName(value="Str")
    @JavaFunDef.Signature(value="Str(number)")
    @JavaFunDef.Description(value="Returns a Variant (String) representation of a number.")
    public static String str(Object number) {
        if (number instanceof Number) {
            if (((Number)number).doubleValue() >= 0.0) {
                return " " + number.toString();
            }
            return number.toString();
        }
        throw new InvalidArgumentException("Invalid parameter. number parameter " + number + " of Str function must be " + "of type number");
    }

    @JavaFunDef.FunctionName(value="Val")
    @JavaFunDef.Signature(value="Val(string)")
    @JavaFunDef.Description(value="Returns the numbers contained in a string as a numeric value of appropriate type.")
    public static double val(String string) {
        if ((string = string.replaceAll("\\s", "")).startsWith("&H")) {
            string = string.substring(2);
            Pattern p = Pattern.compile("[0-9a-fA-F]*");
            Matcher m = p.matcher(string);
            m.find();
            return Integer.parseInt(m.group(), 16);
        }
        if (string.startsWith("&O")) {
            string = string.substring(2);
            Pattern p = Pattern.compile("[0-7]*");
            Matcher m = p.matcher(string);
            m.find();
            return Integer.parseInt(m.group(), 8);
        }
        Pattern p = Pattern.compile("-?[0-9]*[.]?[0-9]*");
        Matcher m = p.matcher(string);
        m.find();
        return Double.parseDouble(m.group());
    }

    @JavaFunDef.FunctionName(value="DateAdd")
    @JavaFunDef.Signature(value="DateAdd(interval, number, date)")
    @JavaFunDef.Description(value="Returns a Variant (Date) containing a date to which a specified time interval has been added.")
    public static Date dateAdd(String intervalName, double number, Date date) {
        Interval interval = Interval.valueOf(intervalName);
        double floor = Math.floor(number);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (floor != number) {
            double ceil = Math.ceil(number);
            interval.add(calendar, (int)ceil);
            long ceilMillis = calendar.getTimeInMillis();
            calendar.setTime(date);
            interval.add(calendar, (int)floor);
            long floorMillis = calendar.getTimeInMillis();
            long amount = (long)((double)(ceilMillis - floorMillis) * (number - floor));
            calendar.add(6, (int)(amount / 86400000L));
            calendar.add(14, (int)(amount % 86400000L));
        } else {
            interval.add(calendar, (int)floor);
        }
        return calendar.getTime();
    }

    @JavaFunDef.FunctionName(value="DateDiff")
    @JavaFunDef.Signature(value="DateDiff(interval, date1, date2[, firstdayofweek[, firstweekofyear]])")
    @JavaFunDef.Description(value="Returns a Variant (Long) specifying the number of time intervals between two specified dates.")
    public static long dateDiff(String interval, Date date1, Date date2) {
        return Vba._dateDiff(interval, date1, date2, 1, FirstWeekOfYear.vbFirstJan1);
    }

    @JavaFunDef.FunctionName(value="DateDiff")
    @JavaFunDef.Signature(value="DateDiff(interval, date1, date2[, firstdayofweek[, firstweekofyear]])")
    @JavaFunDef.Description(value="Returns a Variant (Long) specifying the number of time intervals between two specified dates.")
    public static long dateDiff(String interval, Date date1, Date date2, int firstDayOfWeek) {
        return Vba._dateDiff(interval, date1, date2, firstDayOfWeek, FirstWeekOfYear.vbFirstJan1);
    }

    @JavaFunDef.FunctionName(value="DateDiff")
    @JavaFunDef.Signature(value="DateDiff(interval, date1, date2[, firstdayofweek[, firstweekofyear]])")
    @JavaFunDef.Description(value="Returns a Variant (Long) specifying the number of time intervals between two specified dates.")
    public static long dateDiff(String interval, Date date1, Date date2, int firstDayOfWeek, int firstWeekOfYear) {
        return Vba._dateDiff(interval, date1, date2, firstDayOfWeek, FirstWeekOfYear.values()[firstWeekOfYear]);
    }

    private static long _dateDiff(String intervalName, Date date1, Date date2, int firstDayOfWeek, FirstWeekOfYear firstWeekOfYear) {
        Interval interval = Interval.valueOf(intervalName);
        Calendar calendar1 = Calendar.getInstance();
        firstWeekOfYear.apply(calendar1);
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        firstWeekOfYear.apply(calendar2);
        calendar2.setTime(date2);
        return interval.diff(calendar1, calendar2, firstDayOfWeek);
    }

    @JavaFunDef.FunctionName(value="DatePart")
    @JavaFunDef.Signature(value="DatePart(interval, date[,firstdayofweek[, firstweekofyear]])")
    @JavaFunDef.Description(value="Returns a Variant (Integer) containing the specified part of a given date.")
    public static int datePart(String interval, Date date) {
        return Vba._datePart(interval, date, 1, FirstWeekOfYear.vbFirstJan1);
    }

    @JavaFunDef.FunctionName(value="DatePart")
    @JavaFunDef.Signature(value="DatePart(interval, date[,firstdayofweek[, firstweekofyear]])")
    @JavaFunDef.Description(value="Returns a Variant (Integer) containing the specified part of a given date.")
    public static int datePart(String interval, Date date, int firstDayOfWeek) {
        return Vba._datePart(interval, date, firstDayOfWeek, FirstWeekOfYear.vbFirstJan1);
    }

    @JavaFunDef.FunctionName(value="DatePart")
    @JavaFunDef.Signature(value="DatePart(interval, date[,firstdayofweek[, firstweekofyear]])")
    @JavaFunDef.Description(value="Returns a Variant (Integer) containing the specified part of a given date.")
    public static int datePart(String interval, Date date, int firstDayOfWeek, int firstWeekOfYear) {
        return Vba._datePart(interval, date, firstDayOfWeek, FirstWeekOfYear.values()[firstWeekOfYear]);
    }

    private static int _datePart(String intervalName, Date date, int firstDayOfWeek, FirstWeekOfYear firstWeekOfYear) {
        Interval interval = Interval.valueOf(intervalName);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (interval) {
            case w: 
            case ww: {
                firstWeekOfYear.apply(calendar);
                calendar.setFirstDayOfWeek(firstDayOfWeek);
            }
        }
        return interval.datePart(calendar);
    }

    @JavaFunDef.FunctionName(value="Date")
    @JavaFunDef.Signature(value="Date")
    @JavaFunDef.Description(value="Returns a Variant (Date) containing the current system date.")
    public static Date date() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @JavaFunDef.FunctionName(value="DateSerial")
    @JavaFunDef.Signature(value="DateSerial(year, month, day)")
    @JavaFunDef.Description(value="Returns a Variant (Date) for a specified year, month, and day.")
    public static Date dateSerial(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    @JavaFunDef.FunctionName(value="DateValue")
    @JavaFunDef.Signature(value="DateValue(date)")
    @JavaFunDef.Description(value="Returns a Variant (Date).")
    public static Date dateValue(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @JavaFunDef.FunctionName(value="Day")
    @JavaFunDef.Signature(value="Day(date)")
    @JavaFunDef.Description(value="Returns a Variant (Integer) specifying a whole number between 1 and 31, inclusive, representing the day of the month.")
    public static int day(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    @JavaFunDef.FunctionName(value="Hour")
    @JavaFunDef.Signature(value="Hour(time)")
    @JavaFunDef.Description(value="Returns a Variant (Integer) specifying a whole number between 0 and 23, inclusive, representing the hour of the day.")
    public static int hour(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return calendar.get(11);
    }

    @JavaFunDef.FunctionName(value="Minute")
    @JavaFunDef.Signature(value="Minute(time)")
    @JavaFunDef.Description(value="Returns a Variant (Integer) specifying a whole number between 0 and 59, inclusive, representing the minute of the hour.")
    public static int minute(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return calendar.get(12);
    }

    @JavaFunDef.FunctionName(value="Month")
    @JavaFunDef.Signature(value="Month(date)")
    @JavaFunDef.Description(value="Returns a Variant (Integer) specifying a whole number between 1 and 12, inclusive, representing the month of the year.")
    public static int month(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        return month + 1;
    }

    @JavaFunDef.FunctionName(value="Now")
    @JavaFunDef.Signature(value="Now()")
    @JavaFunDef.Description(value="Returns a Variant (Date) specifying the current date and time according your computer's system date and time.")
    public static Date now() {
        return new Date();
    }

    @JavaFunDef.FunctionName(value="Second")
    @JavaFunDef.Signature(value="Second(time)")
    @JavaFunDef.Description(value="Returns a Variant (Integer) specifying a whole number between 0 and 59, inclusive, representing the second of the minute.")
    public static int second(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return calendar.get(13);
    }

    @JavaFunDef.FunctionName(value="Time")
    @JavaFunDef.Signature(value="Time()")
    @JavaFunDef.Description(value="Returns a Variant (Date) indicating the current system time.")
    public static Date time() {
        return new Date();
    }

    @JavaFunDef.FunctionName(value="TimeSerial")
    @JavaFunDef.Signature(value="TimeSerial(hour, minute, second)")
    @JavaFunDef.Description(value="Returns a Variant (Date) containing the time for a specific hour, minute, and second.")
    public static Date timeSerial(int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    @JavaFunDef.FunctionName(value="TimeValue")
    @JavaFunDef.Signature(value="TimeValue(time)")
    @JavaFunDef.Description(value="Returns a Variant (Date) containing the time.")
    public static Date timeValue(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(time);
        calendar.set(1970, 0, 1);
        return calendar.getTime();
    }

    @JavaFunDef.FunctionName(value="Timer")
    @JavaFunDef.Signature(value="Timer()")
    @JavaFunDef.Description(value="Returns a Single representing the number of seconds elapsed since midnight.")
    public static float timer() {
        Calendar calendar = Calendar.getInstance();
        long now = calendar.getTimeInMillis();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long midnight = calendar.getTimeInMillis();
        return (float)(now - midnight) / 1000.0f;
    }

    @JavaFunDef.FunctionName(value="Weekday")
    @JavaFunDef.Signature(value="Weekday(date[, firstDayOfWeek])")
    @JavaFunDef.Description(value="Returns a Variant (Integer) containing a whole number representing the day of the week.")
    public static int weekday(Date date) {
        return Vba.weekday(date, 1);
    }

    @JavaFunDef.FunctionName(value="Weekday")
    @JavaFunDef.Signature(value="Weekday(date[, firstDayOfWeek])")
    @JavaFunDef.Description(value="Returns a Variant (Integer) containing a whole number representing the day of the week.")
    public static int weekday(Date date, int firstDayOfWeek) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekday = calendar.get(7);
        weekday -= firstDayOfWeek - 1;
        weekday = (weekday + 6) % 7 + 1;
        return weekday;
    }

    @JavaFunDef.FunctionName(value="Year")
    @JavaFunDef.Signature(value="Year(date)")
    @JavaFunDef.Description(value="Returns a Variant (Integer) containing a whole number representing the year.")
    public static int year(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    @JavaFunDef.FunctionName(value="DDB")
    @JavaFunDef.Signature(value="DDB(cost, salvage, life, period[, factor])")
    @JavaFunDef.Description(value="Returns a Double specifying the depreciation of an asset for a specific time period using the double-declining balance method or some other method you specify.")
    public static double dDB(double cost, double salvage, double life, double period) {
        return Vba.dDB(cost, salvage, life, period, 2.0);
    }

    @JavaFunDef.FunctionName(value="DDB")
    @JavaFunDef.Signature(value="DDB(cost, salvage, life, period[, factor])")
    @JavaFunDef.Description(value="Returns a Double specifying the depreciation of an asset for a specific time period using the double-declining balance method or some other method you specify.")
    public static double dDB(double cost, double salvage, double life, double period, double factor) {
        return (cost - salvage) * factor / life * period;
    }

    @JavaFunDef.FunctionName(value="FV")
    @JavaFunDef.Signature(value="FV(rate, nper, pmt[, pv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the future value of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double fV(double rate, double nPer, double pmt) {
        return Vba.fV(rate, nPer, pmt, 0.0, false);
    }

    @JavaFunDef.FunctionName(value="FV")
    @JavaFunDef.Signature(value="FV(rate, nper, pmt[, pv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the future value of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double fV(double rate, double nPer, double pmt, double pv) {
        return Vba.fV(rate, nPer, pmt, pv, false);
    }

    @JavaFunDef.FunctionName(value="FV")
    @JavaFunDef.Signature(value="FV(rate, nper, pmt[, pv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the future value of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double fV(double rate, double nPer, double pmt, double pv, boolean type) {
        if (rate == 0.0) {
            return -(pv + nPer * pmt);
        }
        double r1 = rate + 1.0;
        return (1.0 - Math.pow(r1, nPer)) * (type ? r1 : 1.0) * pmt / rate - pv * Math.pow(r1, nPer);
    }

    @JavaFunDef.FunctionName(value="IPmt")
    @JavaFunDef.Signature(value="IPmt(rate, per, nper, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the interest payment for a given period of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double iPmt(double rate, double per, double nPer, double PV) {
        return Vba.iPmt(rate, per, nPer, PV, 0.0);
    }

    @JavaFunDef.FunctionName(value="IPmt")
    @JavaFunDef.Signature(value="IPmt(rate, per, nper, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the interest payment for a given period of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double iPmt(double rate, double per, double nPer, double PV, double fv) {
        return Vba.iPmt(rate, per, nPer, PV, fv, false);
    }

    @JavaFunDef.FunctionName(value="IPmt")
    @JavaFunDef.Signature(value="IPmt(rate, per, nper, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the interest payment for a given period of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double iPmt(double rate, double per, double nPer, double PV, double fv, boolean due) {
        double pmtVal = Vba.pmt(rate, nPer, PV, fv, due);
        double pValm1 = PV - Vba.pV(rate, per - 1.0, pmtVal, fv, due);
        return -pValm1 * rate;
    }

    @JavaFunDef.FunctionName(value="IRR")
    @JavaFunDef.Signature(value="IRR(values()[, guess])")
    @JavaFunDef.Description(value="Returns a Double specifying the internal rate of return for a series of periodic cash flows (payments and receipts).")
    public static double IRR(double[] valueArray) {
        return Vba.IRR(valueArray, 0.1);
    }

    @JavaFunDef.FunctionName(value="IRR")
    @JavaFunDef.Signature(value="IRR(values()[, guess])")
    @JavaFunDef.Description(value="Returns a Double specifying the internal rate of return for a series of periodic cash flows (payments and receipts).")
    public static double IRR(double[] valueArray, double guess) {
        double minGuess = 0.0;
        double maxGuess = 1.0;
        int r = 1;
        if (valueArray[0] > 0.0) {
            r = -1;
        }
        for (int i = 0; i < 30; ++i) {
            double totalPv = 0.0;
            for (int j = 0; j < valueArray.length; ++j) {
                totalPv += valueArray[j] / Math.pow(1.0 + guess, j);
            }
            if (maxGuess - minGuess < 1.0E-7) {
                return guess;
            }
            if (totalPv * (double)r < 0.0) {
                maxGuess = guess;
            } else {
                minGuess = guess;
            }
            guess = (maxGuess + minGuess) / 2.0;
        }
        return -1.0;
    }

    @JavaFunDef.FunctionName(value="MIRR")
    @JavaFunDef.Signature(value="MIRR(values(), finance_rate, reinvest_rate)")
    @JavaFunDef.Description(value="Returns a Double specifying the modified internal rate of return for a series of periodic cash flows (payments and receipts).")
    public static double MIRR(double[] valueArray, double financeRate, double reinvestRate) {
        double reNPV = 0.0;
        double fiNPV = 0.0;
        for (int j = 0; j < valueArray.length; ++j) {
            if (valueArray[j] > 0.0) {
                reNPV += valueArray[j] / Math.pow(1.0 + reinvestRate, j);
                continue;
            }
            fiNPV += valueArray[j] / Math.pow(1.0 + financeRate, j);
        }
        double ratio = -reNPV * Math.pow(1.0 + reinvestRate, valueArray.length) / (fiNPV * (1.0 + financeRate));
        return Math.pow(ratio, 1.0 / (double)(valueArray.length - 1)) - 1.0;
    }

    @JavaFunDef.FunctionName(value="NPer")
    @JavaFunDef.Signature(value="NPer(rate, pmt, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the number of periods for an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double nPer(double rate, double pmt, double pv, double fv, boolean due) {
        if (rate == 0.0) {
            return -(fv + pv) / pmt;
        }
        double r1 = rate + 1.0;
        double ryr = (due ? r1 : 1.0) * pmt / rate;
        double a1 = ryr - fv < 0.0 ? Math.log(fv - ryr) : Math.log(ryr - fv);
        double a2 = ryr - fv < 0.0 ? Math.log(-pv - ryr) : Math.log(pv + ryr);
        double a3 = Math.log(r1);
        return (a1 - a2) / a3;
    }

    @JavaFunDef.FunctionName(value="NPV")
    @JavaFunDef.Signature(value="NPV(rate, values())")
    @JavaFunDef.Description(value="Returns a Double specifying the net present value of an investment based on a series of periodic cash flows (payments and receipts) and a discount rate.")
    public static double nPV(double r, double[] cfs) {
        double r1;
        double npv = 0.0;
        double trate = r1 = r + 1.0;
        int iSize = cfs.length;
        for (int i = 0; i < iSize; ++i) {
            npv += cfs[i] / trate;
            trate *= r1;
        }
        return npv;
    }

    @JavaFunDef.FunctionName(value="PPmt")
    @JavaFunDef.Signature(value="PPmt(rate, per, nper, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the principal payment for a given period of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double pPmt(double rate, double per, double nPer, double PV) {
        return Vba.pPmt(rate, per, nPer, PV, 0.0);
    }

    @JavaFunDef.FunctionName(value="PPmt")
    @JavaFunDef.Signature(value="PPmt(rate, per, nper, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the principal payment for a given period of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double pPmt(double rate, double per, double nPer, double PV, double fv) {
        return Vba.pPmt(rate, per, nPer, PV, fv, false);
    }

    @JavaFunDef.FunctionName(value="PPmt")
    @JavaFunDef.Signature(value="PPmt(rate, per, nper, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the principal payment for a given period of an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double pPmt(double rate, double per, double nPer, double PV, double fv, boolean due) {
        return Vba.pmt(rate, nPer, PV, fv, due) - Vba.iPmt(rate, per, nPer, PV, fv, due);
    }

    @JavaFunDef.FunctionName(value="Pmt")
    @JavaFunDef.Signature(value="Pmt(rate, nper, pv[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the payment for an annuity based on periodic, fixed payments and a fixed interest rate.")
    public static double pmt(double rate, double nPer, double pv, double fv, boolean due) {
        if (rate == 0.0) {
            return -(fv + pv) / nPer;
        }
        double r1 = rate + 1.0;
        return (fv + pv * Math.pow(r1, nPer)) * rate / ((due ? r1 : 1.0) * (1.0 - Math.pow(r1, nPer)));
    }

    @JavaFunDef.FunctionName(value="PV")
    @JavaFunDef.Signature(value="PV(rate, nper, pmt[, fv[, type]])")
    @JavaFunDef.Description(value="Returns a Double specifying the present value of an annuity based on periodic, fixed payments to be paid in the future and a fixed interest rate.")
    public static double pV(double rate, double nper, double pmt, double fv, boolean due) {
        if (rate == 0.0) {
            return -(nper * pmt + fv);
        }
        double r1 = rate + 1.0;
        return ((1.0 - Math.pow(r1, nper)) / rate * (due ? r1 : 1.0) * pmt - fv) / Math.pow(r1, nper);
    }

    @JavaFunDef.FunctionName(value="Rate")
    @JavaFunDef.Signature(value="Rate(nper, pmt, pv[, fv[, type[, guess]]])")
    @JavaFunDef.Description(value="Returns a Double specifying the interest rate per period for an annuity.")
    public static double rate(double nPer, double pmt, double PV) {
        return Vba.rate(nPer, pmt, PV, 0.0);
    }

    @JavaFunDef.FunctionName(value="Rate")
    @JavaFunDef.Signature(value="Rate(nper, pmt, pv[, fv[, type[, guess]]])")
    @JavaFunDef.Description(value="Returns a Double specifying the interest rate per period for an annuity.")
    public static double rate(double nPer, double pmt, double PV, double fv) {
        return Vba.rate(nPer, pmt, PV, fv, false);
    }

    @JavaFunDef.FunctionName(value="Rate")
    @JavaFunDef.Signature(value="Rate(nper, pmt, pv[, fv[, type[, guess]]])")
    @JavaFunDef.Description(value="Returns a Double specifying the interest rate per period for an annuity.")
    public static double rate(double nPer, double pmt, double PV, double fv, boolean type) {
        return Vba.rate(nPer, pmt, PV, fv, type, 0.1);
    }

    @JavaFunDef.FunctionName(value="Rate")
    @JavaFunDef.Signature(value="Rate(nper, pmt, pv[, fv[, type[, guess]]])")
    @JavaFunDef.Description(value="Returns a Double specifying the interest rate per period for an annuity.")
    public static double rate(double nPer, double pmt, double PV, double fv, boolean due, double guess) {
        if (nPer <= 0.0) {
            throw new InvalidArgumentException("number of payment periods must be larger than 0");
        }
        double minGuess = 0.0;
        double maxGuess = 1.0;
        int r = 1;
        if (PV < fv) {
            r = -1;
        }
        for (int n = 0; n < 30; ++n) {
            double gFV = Vba.fV(guess, nPer, pmt, PV, due);
            double diff = gFV - fv;
            if (maxGuess - minGuess < 1.0E-7) {
                return guess;
            }
            if (diff * (double)r < 0.0) {
                maxGuess = guess;
            } else {
                minGuess = guess;
            }
            guess = (maxGuess + minGuess) / 2.0;
        }
        return -1.0;
    }

    @JavaFunDef.FunctionName(value="SLN")
    @JavaFunDef.Signature(value="SLN(cost, salvage, life)")
    @JavaFunDef.Description(value="Returns a Double specifying the straight-line depreciation of an asset for a single period.")
    public static double sLN(double cost, double salvage, double life) {
        return (cost - salvage) / life;
    }

    @JavaFunDef.FunctionName(value="SYD")
    @JavaFunDef.Signature(value="SYD(cost, salvage, life, period)")
    @JavaFunDef.Description(value="Returns a Double specifying the sum-of-years' digits depreciation of an asset for a specified period.")
    public static double sYD(double cost, double salvage, double life, double period) {
        return (cost - salvage) * (life / (period * (period + 1.0) / 2.0));
    }

    @JavaFunDef.FunctionName(value="IsArray")
    @JavaFunDef.Signature(value="IsArray(varname)")
    @JavaFunDef.Description(value="Returns a Boolean value indicating whether a variable is an array.")
    public boolean isArray(Object varName) {
        return false;
    }

    @JavaFunDef.FunctionName(value="IsDate")
    @JavaFunDef.Signature(value="IsDate(varname)")
    @JavaFunDef.Description(value="Returns a Boolean value indicating whether an expression can be converted to a date..")
    public static boolean isDate(Object expression) {
        try {
            Date val = Vba.cDate(expression);
            return val != null;
        }
        catch (InvalidArgumentException e) {
            return false;
        }
    }

    @JavaFunDef.FunctionName(value="IsError")
    @JavaFunDef.Signature(value="IsError(varname)")
    @JavaFunDef.Description(value="Returns a Boolean value indicating whether an expression is an error value.")
    public boolean isError(Object expression) {
        return expression instanceof Throwable;
    }

    @JavaFunDef.FunctionName(value="IsMissing")
    @JavaFunDef.Signature(value="IsMissing(varname)")
    @JavaFunDef.Description(value="Returns a Boolean value indicating whether an optional Variant argument has been passed to a procedure.")
    public boolean isMissing(Object argName) {
        return false;
    }

    @JavaFunDef.FunctionName(value="IsNull")
    @JavaFunDef.Signature(value="IsNull(varname)")
    @JavaFunDef.Description(value="Returns a Boolean value that indicates whether an expression contains no valid data (Null).")
    public boolean isNull(Object expression) {
        return expression == null;
    }

    @JavaFunDef.FunctionName(value="IsNumeric")
    @JavaFunDef.Signature(value="IsNumeric(varname)")
    @JavaFunDef.Description(value="Returns a Boolean value indicating whether an expression can be evaluated as a number.")
    public boolean isNumeric(Object expression) {
        return expression instanceof Number;
    }

    @JavaFunDef.FunctionName(value="IsObject")
    @JavaFunDef.Signature(value="IsObject(varname)")
    @JavaFunDef.Description(value="Returns a Boolean value indicating whether an identifier represents an object variable.")
    public boolean isObject(Object expression) {
        return false;
    }

    @JavaFunDef.FunctionName(value="TypeName")
    @JavaFunDef.Signature(value="TypeName(varname)")
    @JavaFunDef.Description(value="Returns a String that provides information about a variable.")
    public static String typeName(Object varName) {
        if (varName == null) {
            return "NULL";
        }
        String name = varName.getClass().getName();
        if (name.lastIndexOf(".") >= 0) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    @JavaFunDef.FunctionName(value="Abs")
    @JavaFunDef.Signature(value="Abs(number)")
    @JavaFunDef.Description(value="Returns a value of the same type that is passed to it specifying the absolute value of a number.")
    public static double abs(double number) {
        return Math.abs(number);
    }

    @JavaFunDef.FunctionName(value="Atn")
    @JavaFunDef.Signature(value="Atn(number)")
    @JavaFunDef.Description(value="Returns a Double specifying the arctangent of a number.")
    public static double atn(double number) {
        return Math.atan(number);
    }

    @JavaFunDef.FunctionName(value="Cos")
    @JavaFunDef.Signature(value="Cos(number)")
    @JavaFunDef.Description(value="Returns a Double specifying the cosine of an angle.")
    public static double cos(double number) {
        return Math.cos(number);
    }

    @JavaFunDef.FunctionName(value="Exp")
    @JavaFunDef.Signature(value="Exp(number)")
    @JavaFunDef.Description(value="Returns a Double specifying e (the base of natural logarithms) raised to a power.")
    public static double exp(double number) {
        return Math.exp(number);
    }

    @JavaFunDef.FunctionName(value="Log")
    @JavaFunDef.Signature(value="Log(number)")
    @JavaFunDef.Description(value="Returns a Double specifying the natural logarithm of a number.")
    public static double log(double number) {
        return Math.log(number);
    }

    @JavaFunDef.FunctionName(value="Round")
    @JavaFunDef.Signature(value="Round(number[, numDigitsAfterDecimal])")
    @JavaFunDef.Description(value="Returns a number rounded to a specified number of decimal places.")
    public static double round(double number) {
        return Math.round(number);
    }

    @JavaFunDef.FunctionName(value="Round")
    @JavaFunDef.Signature(value="Round(number[, numDigitsAfterDecimal])")
    @JavaFunDef.Description(value="Returns a number rounded to a specified number of decimal places.")
    public static double round(double number, int numDigitsAfterDecimal) {
        if (numDigitsAfterDecimal == 0) {
            return Math.round(number);
        }
        double shift = Math.pow(10.0, numDigitsAfterDecimal);
        double numberScaled = number * shift;
        double resultScaled = Math.round(numberScaled);
        return resultScaled / shift;
    }

    @JavaFunDef.FunctionName(value="Sgn")
    @JavaFunDef.Signature(value="Sgn(number)")
    @JavaFunDef.Description(value="Returns a Variant (Integer) indicating the sign of a number.")
    public static int sgn(double number) {
        return number < 0.0 ? -1 : (number > 0.0 ? 1 : 0);
    }

    @JavaFunDef.FunctionName(value="Sin")
    @JavaFunDef.Signature(value="Sin(number)")
    @JavaFunDef.Description(value="Returns a Double specifying the sine of an angle.")
    public static double sin(double number) {
        return Math.sin(number);
    }

    @JavaFunDef.FunctionName(value="Sqr")
    @JavaFunDef.Signature(value="Sqr(number)")
    @JavaFunDef.Description(value="Returns a Double specifying the square root of a number.")
    public static double sqr(double number) {
        return Math.sqrt(number);
    }

    @JavaFunDef.FunctionName(value="Tan")
    @JavaFunDef.Signature(value="Tan(number)")
    @JavaFunDef.Description(value="Returns a Double specifying the tangent of an angle.")
    public static double tan(double number) {
        return Math.tan(number);
    }

    @JavaFunDef.FunctionName(value="Asc")
    @JavaFunDef.Signature(value="Asc(string)")
    @JavaFunDef.Description(value="Returns an Integer representing the character code corresponding to the first letter in a string.")
    public static int asc(String string) {
        return string.charAt(0);
    }

    @JavaFunDef.FunctionName(value="AscB")
    @JavaFunDef.Signature(value="AscB(string)")
    @JavaFunDef.Description(value="See Asc.")
    public static int ascB(String string) {
        return (byte)string.charAt(0);
    }

    @JavaFunDef.FunctionName(value="AscW")
    @JavaFunDef.Signature(value="AscW(string)")
    @JavaFunDef.Description(value="See Asc.")
    public static int ascW(String string) {
        return Vba.asc(string);
    }

    @JavaFunDef.FunctionName(value="Chr")
    @JavaFunDef.Signature(value="Chr(charcode)")
    @JavaFunDef.Description(value="Returns a String containing the character associated with the specified character code.")
    public static String chr(int charCode) {
        return new String(new char[]{(char)charCode});
    }

    @JavaFunDef.FunctionName(value="ChrB")
    @JavaFunDef.Signature(value="ChrB(charcode)")
    @JavaFunDef.Description(value="See Chr.")
    public static String chrB(int charCode) {
        return new String(new byte[]{(byte)charCode});
    }

    @JavaFunDef.FunctionName(value="ChrW")
    @JavaFunDef.Signature(value="ChrW(charcode)")
    @JavaFunDef.Description(value="See Chr.")
    public static String chrW(int charCode) {
        return new String(new char[]{(char)charCode});
    }

    @JavaFunDef.FunctionName(value="FormatCurrency")
    @JavaFunDef.Signature(value="FormatCurrency(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a currency value using the currency symbol defined in the system control panel.")
    public static String formatCurrency(Object expression) {
        return Vba.formatCurrency(expression, -1, -2, -2, -2);
    }

    @JavaFunDef.FunctionName(value="FormatCurrency")
    @JavaFunDef.Signature(value="FormatCurrency(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a currency value using the currency symbol defined in the system control panel.")
    public static String formatCurrency(Object expression, int numDigitsAfterDecimal) {
        return Vba.formatCurrency(expression, numDigitsAfterDecimal, -2, -2, -2);
    }

    @JavaFunDef.FunctionName(value="FormatCurrency")
    @JavaFunDef.Signature(value="FormatCurrency(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a currency value using the currency symbol defined in the system control panel.")
    public static String formatCurrency(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit) {
        return Vba.formatCurrency(expression, numDigitsAfterDecimal, includeLeadingDigit, -2, -2);
    }

    @JavaFunDef.FunctionName(value="FormatCurrency")
    @JavaFunDef.Signature(value="FormatCurrency(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a currency value using the currency symbol defined in the system control panel.")
    public static String formatCurrency(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit, int useParensForNegativeNumbers) {
        return Vba.formatCurrency(expression, numDigitsAfterDecimal, includeLeadingDigit, useParensForNegativeNumbers, -2);
    }

    @JavaFunDef.FunctionName(value="FormatCurrency")
    @JavaFunDef.Signature(value="FormatCurrency(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a currency value using the currency symbol defined in the system control panel.")
    public static String formatCurrency(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit, int useParensForNegativeNumbers, int groupDigits) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getCurrencyInstance();
        if (numDigitsAfterDecimal != -1) {
            format.setMaximumFractionDigits(numDigitsAfterDecimal);
            format.setMinimumFractionDigits(numDigitsAfterDecimal);
        }
        if (includeLeadingDigit != -2) {
            if (includeLeadingDigit != 0) {
                format.setMinimumIntegerDigits(1);
            } else {
                format.setMinimumIntegerDigits(0);
            }
        }
        if (useParensForNegativeNumbers != -2) {
            // empty if block
        }
        if (groupDigits != -2) {
            if (groupDigits != 0) {
                format.setGroupingUsed(false);
            } else {
                format.setGroupingUsed(true);
            }
        }
        return format.format(expression);
    }

    @JavaFunDef.FunctionName(value="FormatDateTime")
    @JavaFunDef.Signature(value="FormatDateTime(Date[,NamedFormat])")
    @JavaFunDef.Description(value="Returns an expression formatted as a date or time.")
    public static String formatDateTime(Date date) {
        return Vba.formatDateTime(date, 0);
    }

    @JavaFunDef.FunctionName(value="FormatDateTime")
    @JavaFunDef.Signature(value="FormatDateTime(Date[,NamedFormat])")
    @JavaFunDef.Description(value="Returns an expression formatted as a date or time.")
    public static String formatDateTime(Date date, int namedFormat) {
        switch (namedFormat) {
            case 1: {
                return DateFormat.getDateInstance(1).format(date);
            }
            case 2: {
                return DateFormat.getDateInstance(3).format(date);
            }
            case 3: {
                return DateFormat.getTimeInstance(1).format(date);
            }
            case 4: {
                return DateFormat.getTimeInstance(3).format(date);
            }
        }
        return DateFormat.getDateTimeInstance().format(date);
    }

    @JavaFunDef.FunctionName(value="FormatNumber")
    @JavaFunDef.Signature(value="FormatNumber(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a number.")
    public static String formatNumber(Object expression) {
        return Vba.formatNumber(expression, -1);
    }

    @JavaFunDef.FunctionName(value="FormatNumber")
    @JavaFunDef.Signature(value="FormatNumber(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a number.")
    public static String formatNumber(Object expression, int numDigitsAfterDecimal) {
        return Vba.formatNumber(expression, numDigitsAfterDecimal, -1);
    }

    @JavaFunDef.FunctionName(value="FormatNumber")
    @JavaFunDef.Signature(value="FormatNumber(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a number.")
    public static String formatNumber(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit) {
        return Vba.formatNumber(expression, numDigitsAfterDecimal, includeLeadingDigit, -1);
    }

    @JavaFunDef.FunctionName(value="FormatNumber")
    @JavaFunDef.Signature(value="FormatNumber(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a number.")
    public static String formatNumber(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit, int useParensForNegativeNumbers) {
        return Vba.formatNumber(expression, numDigitsAfterDecimal, includeLeadingDigit, useParensForNegativeNumbers, -1);
    }

    @JavaFunDef.FunctionName(value="FormatNumber")
    @JavaFunDef.Signature(value="FormatNumber(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a number.")
    public static String formatNumber(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit, int useParensForNegativeNumbers, int groupDigits) {
        NumberFormat format = NumberFormat.getNumberInstance();
        if (numDigitsAfterDecimal != -1) {
            format.setMaximumFractionDigits(numDigitsAfterDecimal);
            format.setMinimumFractionDigits(numDigitsAfterDecimal);
        }
        if (includeLeadingDigit != -1) {
            if (includeLeadingDigit != 0) {
                format.setMinimumIntegerDigits(1);
            } else {
                format.setMinimumIntegerDigits(0);
            }
        }
        if (useParensForNegativeNumbers != -1) {
            if (useParensForNegativeNumbers != 0) {
                DecimalFormat dformat = (DecimalFormat)format;
                dformat.setNegativePrefix("(");
                dformat.setNegativeSuffix(")");
            } else {
                DecimalFormat dformat = (DecimalFormat)format;
                dformat.setNegativePrefix("" + dformat.getDecimalFormatSymbols().getMinusSign());
                dformat.setNegativeSuffix("");
            }
        }
        if (groupDigits != -1) {
            format.setGroupingUsed(groupDigits != 0);
        }
        return format.format(expression);
    }

    @JavaFunDef.FunctionName(value="FormatPercent")
    @JavaFunDef.Signature(value="FormatPercent(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a percentage (multipled by 100) with a trailing % character.")
    public static String formatPercent(Object expression) {
        return Vba.formatPercent(expression, -1);
    }

    @JavaFunDef.FunctionName(value="FormatPercent")
    @JavaFunDef.Signature(value="FormatPercent(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a percentage (multipled by 100) with a trailing % character.")
    public static String formatPercent(Object expression, int numDigitsAfterDecimal) {
        return Vba.formatPercent(expression, numDigitsAfterDecimal, -1);
    }

    @JavaFunDef.FunctionName(value="FormatPercent")
    @JavaFunDef.Signature(value="FormatPercent(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a percentage (multipled by 100) with a trailing % character.")
    public static String formatPercent(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit) {
        return Vba.formatPercent(expression, numDigitsAfterDecimal, includeLeadingDigit, -1);
    }

    @JavaFunDef.FunctionName(value="FormatPercent")
    @JavaFunDef.Signature(value="FormatPercent(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a percentage (multipled by 100) with a trailing % character.")
    public static String formatPercent(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit, int useParensForNegativeNumbers) {
        return Vba.formatPercent(expression, numDigitsAfterDecimal, includeLeadingDigit, useParensForNegativeNumbers, -1);
    }

    @JavaFunDef.FunctionName(value="FormatPercent")
    @JavaFunDef.Signature(value="FormatPercent(Expression[,NumDigitsAfterDecimal [,IncludeLeadingDigit [,UseParensForNegativeNumbers [,GroupDigits]]]])")
    @JavaFunDef.Description(value="Returns an expression formatted as a percentage (multipled by 100) with a trailing % character.")
    public static String formatPercent(Object expression, int numDigitsAfterDecimal, int includeLeadingDigit, int useParensForNegativeNumbers, int groupDigits) {
        NumberFormat format = NumberFormat.getPercentInstance();
        if (numDigitsAfterDecimal != -1) {
            format.setMaximumFractionDigits(numDigitsAfterDecimal);
            format.setMinimumFractionDigits(numDigitsAfterDecimal);
        }
        if (includeLeadingDigit != -1) {
            if (includeLeadingDigit != 0) {
                format.setMinimumIntegerDigits(1);
            } else {
                format.setMinimumIntegerDigits(0);
            }
        }
        if (useParensForNegativeNumbers != -1) {
            if (useParensForNegativeNumbers != 0) {
                DecimalFormat dformat = (DecimalFormat)format;
                dformat.setNegativePrefix("(");
                dformat.setNegativeSuffix("" + dformat.getDecimalFormatSymbols().getPercent() + ")");
            } else {
                DecimalFormat dformat = (DecimalFormat)format;
                dformat.setNegativePrefix("" + dformat.getDecimalFormatSymbols().getMinusSign());
                dformat.setNegativeSuffix("" + dformat.getDecimalFormatSymbols().getPercent());
            }
        }
        if (groupDigits != -1) {
            format.setGroupingUsed(groupDigits != 0);
        }
        return format.format(expression);
    }

    @JavaFunDef.FunctionName(value="InStrRev")
    @JavaFunDef.Signature(value="InstrRev(stringcheck, stringmatch[, start[, compare]])")
    @JavaFunDef.Description(value="Returns the position of an occurrence of one string within another, from the end of string.")
    public static int inStrRev(String stringCheck, String stringMatch) {
        return Vba.inStrRev(stringCheck, stringMatch, -1);
    }

    @JavaFunDef.FunctionName(value="InStrRev")
    @JavaFunDef.Signature(value="InstrRev(stringcheck, stringmatch[, start[, compare]])")
    @JavaFunDef.Description(value="Returns the position of an occurrence of one string within another, from the end of string.")
    public static int inStrRev(String stringCheck, String stringMatch, int start) {
        return Vba.inStrRev(stringCheck, stringMatch, start, 0);
    }

    @JavaFunDef.FunctionName(value="InStrRev")
    @JavaFunDef.Signature(value="InstrRev(stringcheck, stringmatch[, start[, compare]])")
    @JavaFunDef.Description(value="Returns the position of an occurrence of one string within another, from the end of string.")
    public static int inStrRev(String stringCheck, String stringMatch, int start, int compare) {
        if (start == 0 || start < -1) {
            throw new InvalidArgumentException("start must be -1 or a location in the string to start");
        }
        if (start != -1) {
            return stringCheck.lastIndexOf(stringMatch, start - 1) + 1;
        }
        return stringCheck.lastIndexOf(stringMatch) + 1;
    }

    @JavaFunDef.FunctionName(value="LCase")
    @JavaFunDef.Signature(value="LCase(string)")
    @JavaFunDef.Description(value="Returns a String that has been converted to lowercase.")
    public static String lCase(String string) {
        return string.toLowerCase();
    }

    @JavaFunDef.FunctionName(value="LTrim")
    @JavaFunDef.Signature(value="LTrim(string)")
    @JavaFunDef.Description(value="Returns a Variant (String) containing a copy of a specified string without leading spaces.")
    public static String lTrim(String string) {
        int i;
        int n = string.length();
        for (i = 0; i < n && string.charAt(i) <= ' '; ++i) {
        }
        return string.substring(i);
    }

    @JavaFunDef.FunctionName(value="Left")
    @JavaFunDef.Signature(value="Left(string, length)")
    @JavaFunDef.Description(value="Returns a specified number of characters from the left side of a string.")
    public static String left(String string, int length) {
        int stringLength = string.length();
        if (length >= stringLength) {
            return string;
        }
        return string.substring(0, length);
    }

    @JavaFunDef.FunctionName(value="Mid")
    @JavaFunDef.Signature(value="Mid(value, beginIndex[, length])")
    @JavaFunDef.Description(value="Returns a specified number of characters from a string.")
    public static String mid(String value, int beginIndex) {
        int length = value.length();
        return Vba.mid(value, beginIndex, length);
    }

    @JavaFunDef.FunctionName(value="Mid")
    @JavaFunDef.Signature(value="Mid(value, beginIndex[, length])")
    @JavaFunDef.Description(value="Returns a specified number of characters from a string.")
    public static String mid(String value, int beginIndex, int length) {
        int endIndex;
        if (beginIndex < 0) {
            throw new InvalidArgumentException("Invalid parameter. Start parameter of Mid function can't be negative");
        }
        if (length < 0) {
            throw new InvalidArgumentException("Invalid parameter. Length parameter of Mid function can't be negative");
        }
        if (beginIndex >= value.length()) {
            return "";
        }
        if (beginIndex != 0) {
            --beginIndex;
        }
        return (endIndex = beginIndex + length) >= value.length() ? value.substring(beginIndex) : value.substring(beginIndex, endIndex);
    }

    @JavaFunDef.FunctionName(value="MonthName")
    @JavaFunDef.Signature(value="MonthName(month, abbreviate)")
    @JavaFunDef.Description(value="Returns a string indicating the specified month.")
    public static String monthName(int month, boolean abbreviate) {
        return (abbreviate ? Vba.getDateFormatSymbols().getShortMonths() : Vba.getDateFormatSymbols().getMonths())[--month];
    }

    private static DateFormatSymbols getDateFormatSymbols() {
        return DATE_FORMAT_SYMBOLS;
    }

    @JavaFunDef.FunctionName(value="RTrim")
    @JavaFunDef.Signature(value="RTrim(string)")
    @JavaFunDef.Description(value="Returns a Variant (String) containing a copy of a specified string without trailing spaces.")
    public static String rTrim(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && string.charAt(i) <= ' '; --i) {
        }
        return string.substring(0, i + 1);
    }

    @JavaFunDef.FunctionName(value="Replace")
    @JavaFunDef.Signature(value="Replace(expression, find, replace[, start[, count[, compare]]])")
    @JavaFunDef.Description(value="Returns a string in which a specified substring has been replaced with another substring a specified number of times.")
    public static String replace(String expression, String find, String replace, int start, int count, int compare) {
        Util.discard((int)compare);
        return Vba._replace(expression, find, replace, start, count);
    }

    @JavaFunDef.FunctionName(value="Replace")
    @JavaFunDef.Signature(value="Replace(expression, find, replace[, start[, count[, compare]]])")
    @JavaFunDef.Description(value="Returns a string in which a specified substring has been replaced with another substring a specified number of times.")
    public static String replace(String expression, String find, String replace, int start, int count) {
        return Vba._replace(expression, find, replace, start, count);
    }

    @JavaFunDef.FunctionName(value="Replace")
    @JavaFunDef.Signature(value="Replace(expression, find, replace[, start[, count[, compare]]])")
    @JavaFunDef.Description(value="Returns a string in which a specified substring has been replaced with another substring a specified number of times.")
    public static String replace(String expression, String find, String replace, int start) {
        return Vba._replace(expression, find, replace, start, -1);
    }

    @JavaFunDef.FunctionName(value="Replace")
    @JavaFunDef.Signature(value="Replace(expression, find, replace[, start[, count[, compare]]])")
    @JavaFunDef.Description(value="")
    public static String replace(String expression, String find, String replace) {
        return Vba._replace(expression, find, replace, 1, -1);
    }

    private static String _replace(String expression, String find, String replace, int start, int count) {
        int j;
        StringBuilder buf = new StringBuilder(expression);
        int i = 0;
        int pos = start - 1;
        while (i++ != count && (j = buf.indexOf(find, pos)) != -1) {
            buf.replace(j, j + find.length(), replace);
            pos = j + replace.length();
        }
        return buf.toString();
    }

    @JavaFunDef.FunctionName(value="Right")
    @JavaFunDef.Signature(value="Right(string, length)")
    @JavaFunDef.Description(value="Returns a Variant (String) containing a specified number of characters from the right side of a string.")
    public static String right(String string, int length) {
        int stringLength = string.length();
        if (length >= stringLength) {
            return string;
        }
        return string.substring(stringLength - length, stringLength);
    }

    @JavaFunDef.FunctionName(value="Space")
    @JavaFunDef.Signature(value="Space(number)")
    @JavaFunDef.Description(value="Returns a Variant (String) consisting of the specified number of spaces.")
    public static String space(int number) {
        return Vba.string(number, ' ');
    }

    @JavaFunDef.FunctionName(value="StrComp")
    @JavaFunDef.Signature(value="StrComp(string1, string2[, compare])")
    @JavaFunDef.Description(value="Returns a Variant (Integer) indicating the result of a string comparison.")
    public static int strComp(String string1, String string2) {
        return Vba.strComp(string1, string2, 0);
    }

    @JavaFunDef.FunctionName(value="StrComp")
    @JavaFunDef.Signature(value="StrComp(string1, string2[, compare])")
    @JavaFunDef.Description(value="Returns a Variant (Integer) indicating the result of a string comparison.")
    public static int strComp(String string1, String string2, int compare) {
        assert (string1 != null);
        assert (string2 != null);
        return string1.compareTo(string2);
    }

    @JavaFunDef.FunctionName(value="StrReverse")
    @JavaFunDef.Signature(value="StrReverse(string)")
    @JavaFunDef.Description(value="Returns a string in which the character order of a specified string is reversed.")
    public static String strReverse(String expression) {
        char[] chars = expression.toCharArray();
        int i = 0;
        for (int j = chars.length - 1; i < j; ++i, --j) {
            char c = chars[i];
            chars[i] = chars[j];
            chars[j] = c;
        }
        return new String(chars);
    }

    @JavaFunDef.FunctionName(value="String")
    @JavaFunDef.Signature(value="String(number, character)")
    @JavaFunDef.Description(value="")
    public static String string(int number, char character) {
        if (character == '\u0000') {
            return "";
        }
        char[] chars = new char[number];
        Arrays.fill(chars, (char)(character % 256));
        return new String(chars);
    }

    @JavaFunDef.FunctionName(value="Trim")
    @JavaFunDef.Signature(value="Trim(string)")
    @JavaFunDef.Description(value="Returns a Variant (String) containing a copy of a specified string without leading and trailing spaces.")
    public static String trim(String string) {
        return string.trim();
    }

    @JavaFunDef.FunctionName(value="WeekdayName")
    @JavaFunDef.Signature(value="WeekdayName(weekday, abbreviate, firstdayofweek)")
    @JavaFunDef.Description(value="Returns a string indicating the specified day of the week.")
    public static String weekdayName(int weekday, boolean abbreviate, int firstDayOfWeek) {
        Calendar calendar = Calendar.getInstance();
        if (firstDayOfWeek == 0) {
            firstDayOfWeek = calendar.getFirstDayOfWeek();
        }
        weekday += firstDayOfWeek - 1;
        if ((weekday = (weekday - 1) % 7 + 1) <= 0) {
            weekday += 7;
        }
        return (abbreviate ? Vba.getDateFormatSymbols().getShortWeekdays() : Vba.getDateFormatSymbols().getWeekdays())[weekday];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FirstWeekOfYear
    extends Enum<FirstWeekOfYear> {
        public static final /* enum */ FirstWeekOfYear vbUseSystem = new FirstWeekOfYear(0, "Use the NLS API setting.");
        public static final /* enum */ FirstWeekOfYear vbFirstJan1 = new FirstWeekOfYear(1, "Start with week in which January 1 occurs (default).");
        public static final /* enum */ FirstWeekOfYear vbFirstFourDays = new FirstWeekOfYear(2, "Start with the first week that has at least four days in the new year.");
        public static final /* enum */ FirstWeekOfYear vbFirstFullWeek = new FirstWeekOfYear(3, "Start with first full week of the year.");
        private static final /* synthetic */ FirstWeekOfYear[] $VALUES;

        public static final FirstWeekOfYear[] values() {
            return (FirstWeekOfYear[])$VALUES.clone();
        }

        public static FirstWeekOfYear valueOf(String name) {
            return Enum.valueOf(FirstWeekOfYear.class, name);
        }

        private FirstWeekOfYear(int code, String desc) {
            assert (code == this.ordinal());
            assert (desc != null);
        }

        void apply(Calendar calendar) {
            switch (this) {
                case vbUseSystem: {
                    break;
                }
                case vbFirstJan1: {
                    calendar.setMinimalDaysInFirstWeek(1);
                    break;
                }
                case vbFirstFourDays: {
                    calendar.setMinimalDaysInFirstWeek(4);
                    break;
                }
                case vbFirstFullWeek: {
                    calendar.setMinimalDaysInFirstWeek(7);
                }
            }
        }

        static {
            $VALUES = new FirstWeekOfYear[]{vbUseSystem, vbFirstJan1, vbFirstFourDays, vbFirstFullWeek};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Interval
    extends Enum<Interval> {
        public static final /* enum */ Interval yyyy = new Interval("Year", 1);
        public static final /* enum */ Interval q = new Interval("Quarter", -1);
        public static final /* enum */ Interval m = new Interval("Month", 2);
        public static final /* enum */ Interval y = new Interval("Day of year", 6);
        public static final /* enum */ Interval d = new Interval("Day", 5);
        public static final /* enum */ Interval w = new Interval("Weekday", 7);
        public static final /* enum */ Interval ww = new Interval("Week", 3);
        public static final /* enum */ Interval h = new Interval("Hour", 11);
        public static final /* enum */ Interval n = new Interval("Minute", 12);
        public static final /* enum */ Interval s = new Interval("Second", 13);
        private final int dateField;
        private static final /* synthetic */ Interval[] $VALUES;

        public static final Interval[] values() {
            return (Interval[])$VALUES.clone();
        }

        public static Interval valueOf(String name) {
            return Enum.valueOf(Interval.class, name);
        }

        private Interval(String desc, int dateField) {
            Util.discard((Object)desc);
            this.dateField = dateField;
        }

        void add(Calendar calendar, int amount) {
            switch (this) {
                case q: {
                    calendar.add(2, amount * 3);
                    break;
                }
                default: {
                    calendar.add(this.dateField, amount);
                }
            }
        }

        Calendar floor(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(calendar.getTime());
            this.floorInplace(calendar2);
            return calendar2;
        }

        private void floorInplace(Calendar calendar) {
            switch (this) {
                case yyyy: {
                    calendar.set(6, 1);
                    d.floorInplace(calendar);
                    break;
                }
                case q: {
                    int month = calendar.get(2);
                    month -= month % 3;
                    calendar.set(2, month);
                    calendar.set(5, 1);
                    d.floorInplace(calendar);
                    break;
                }
                case m: {
                    calendar.set(5, 1);
                    d.floorInplace(calendar);
                    break;
                }
                case w: {
                    int dow = calendar.get(7);
                    int firstDayOfWeek = calendar.getFirstDayOfWeek();
                    if (dow != firstDayOfWeek) {
                        if (dow > firstDayOfWeek) {
                            int roll = firstDayOfWeek - dow;
                            assert (roll < 0);
                            calendar.roll(7, roll);
                        } else {
                            int roll = firstDayOfWeek - dow - 7;
                            assert (roll < 0);
                            calendar.roll(7, roll);
                        }
                    }
                    d.floorInplace(calendar);
                    break;
                }
                case y: 
                case d: {
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    break;
                }
                case h: {
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    break;
                }
                case n: {
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    break;
                }
                case s: {
                    calendar.set(14, 0);
                }
            }
        }

        int diff(Calendar calendar1, Calendar calendar2, int firstDayOfWeek) {
            switch (this) {
                case q: {
                    return m.diff(calendar1, calendar2, firstDayOfWeek) / 3;
                }
            }
            return this.floor(calendar1).get(this.dateField) - this.floor(calendar2).get(this.dateField);
        }

        int datePart(Calendar calendar) {
            switch (this) {
                case q: {
                    return (m.datePart(calendar) + 2) / 3;
                }
                case m: {
                    return calendar.get(this.dateField) + 1;
                }
                case w: {
                    int dayOfWeek = calendar.get(this.dateField);
                    dayOfWeek -= calendar.getFirstDayOfWeek() - 1;
                    if ((dayOfWeek %= 7) <= 0) {
                        dayOfWeek += 7;
                    }
                    return dayOfWeek;
                }
            }
            return calendar.get(this.dateField);
        }

        static {
            $VALUES = new Interval[]{yyyy, q, m, y, d, w, ww, h, n, s};
        }
    }
}

