/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StrToSetFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();
    private static final int BEFORE_SEG = 0;
    private static final int IN_BRACKET_SEG = 1;
    private static final int AFTER_SEG = 2;
    private static final int IN_SEG = 3;

    private StrToSetFunDef(int[] parameterTypes) {
        super("StrToSet", "<Set> StrToSet(<String>[, <Dimension>...])", "Constructs a set from a string expression.", Syntax.Function, 8, parameterTypes);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final StringCalc stringCalc = compiler.compileString(call.getArg(0));
        SetType type = (SetType)call.getType();
        Type elementType = type.getElementType();
        if (elementType instanceof MemberType) {
            final Hierarchy hierarchy = elementType.getHierarchy();
            return new AbstractListCalc(call, new Calc[]{stringCalc}){

                public List evaluateList(Evaluator evaluator) {
                    String string = stringCalc.evaluateString(evaluator);
                    return StrToSetFunDef.parseMemberList(evaluator, string, hierarchy);
                }
            };
        }
        TupleType tupleType = (TupleType)elementType;
        final Hierarchy[] hierarchies = new Hierarchy[tupleType.elementTypes.length];
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            hierarchies[i] = tupleType.elementTypes[i].getHierarchy();
        }
        return new AbstractListCalc(call, new Calc[]{stringCalc}){

            public List evaluateList(Evaluator evaluator) {
                String string = stringCalc.evaluateString(evaluator);
                return StrToSetFunDef.parseTupleList(evaluator, string, hierarchies);
            }
        };
    }

    private static List<Member[]> parseTupleList(Evaluator evaluator, String string, Hierarchy[] hierarchies) {
        char c;
        ArrayList<Member[]> tupleList = new ArrayList<Member[]>();
        Member[] members = new Member[hierarchies.length];
        int i = 0;
        while ((c = string.charAt(i++)) == ' ') {
        }
        if (c != '{') {
            throw StrToSetFunDef.fail(string, i, "{");
        }
        do {
            i = StrToSetFunDef.parseTuple(evaluator, string, i, members, hierarchies);
            tupleList.add((Member[])members.clone());
            while ((c = string.charAt(i++)) == ' ') {
            }
        } while (c == ',');
        if (c == '}') {
            return tupleList;
        }
        throw StrToSetFunDef.fail(string, i, ", or }");
    }

    static int parseTuple(Evaluator evaluator, String string, int i, Member[] members, Hierarchy[] hierarchies) {
        char c;
        block5: {
            while ((c = string.charAt(i++)) == ' ') {
            }
            if (c != '(') {
                throw StrToSetFunDef.fail(string, i, "(");
            }
            int j = 0;
            do {
                i = StrToSetFunDef.parseMember(evaluator, string, i, members, hierarchies, j);
                while ((c = string.charAt(i++)) == ' ') {
                }
                if (++j >= hierarchies.length) break block5;
            } while (c == ',' || c != ')');
            throw Util.newInternal("too few members");
        }
        if (c != ')') {
            throw Util.newInternal("expected ')");
        }
        return i;
    }

    private static List<Member> parseMemberList(Evaluator evaluator, String string, Hierarchy hierarchy) {
        char c;
        Hierarchy[] hierarchies = new Hierarchy[]{hierarchy};
        ArrayList<Member> memberList = new ArrayList<Member>();
        Member[] members = new Member[]{null};
        int i = 0;
        while ((c = string.charAt(i++)) == ' ') {
        }
        if (c != '{') {
            throw StrToSetFunDef.fail(string, i, "{");
        }
        do {
            i = StrToSetFunDef.parseMember(evaluator, string, i, members, hierarchies, 0);
            memberList.add(members[0]);
            while ((c = string.charAt(i++)) == ' ') {
            }
        } while (c == ',');
        if (c == '}') {
            return memberList;
        }
        throw StrToSetFunDef.fail(string, i, ", or }");
    }

    static int parseMember(Evaluator evaluator, String string, int i, Member[] members, Hierarchy[] hierarchies, int j) {
        Member member;
        int k = string.length();
        ArrayList<Id.Segment> nameList = new ArrayList<Id.Segment>();
        int state = 0;
        int start = 0;
        block22: while (i < k) {
            switch (state) {
                case 0: {
                    char c = string.charAt(i);
                    switch (c) {
                        case '[': {
                            start = ++i;
                            state = 1;
                            continue block22;
                        }
                        case ' ': {
                            ++i;
                            continue block22;
                        }
                        case ',': 
                        case '}': {
                            break block22;
                        }
                        case '.': {
                            throw Util.newInternal("unexpected: '.'");
                        }
                    }
                    state = 3;
                    start = i;
                    continue block22;
                }
                case 3: {
                    char c = string.charAt(i);
                    switch (c) {
                        case '.': {
                            nameList.add(new Id.Segment(string.substring(start, i), Id.Quoting.UNQUOTED));
                            state = 0;
                            ++i;
                        }
                    }
                    ++i;
                    continue block22;
                }
                case 1: {
                    char c = string.charAt(i);
                    switch (c) {
                        case ']': {
                            nameList.add(new Id.Segment(string.substring(start, i), Id.Quoting.QUOTED));
                            ++i;
                            state = 2;
                            continue block22;
                        }
                    }
                    ++i;
                    continue block22;
                }
                case 2: {
                    char c = string.charAt(i);
                    switch (c) {
                        case ' ': {
                            ++i;
                            continue block22;
                        }
                        case '.': {
                            state = 0;
                            ++i;
                            continue block22;
                        }
                    }
                    break block22;
                }
                default: {
                    throw Util.newInternal("unexpected state: " + state);
                }
            }
        }
        members[j] = member = (Member)Util.lookupCompound(evaluator.getSchemaReader(), evaluator.getCube(), nameList, true, 6);
        if (member.getHierarchy() != hierarchies[j]) {
            throw Util.newInternal("member is of wrong hierarchy");
        }
        return i;
    }

    private static RuntimeException fail(String string, int i, String expecting) {
        throw Util.newInternal("expected '" + expecting + "' at position " + i + " in '" + string + "'");
    }

    @Override
    public Exp createCall(Validator validator, Exp[] args) {
        int argCount = args.length;
        if (argCount <= 1) {
            throw MondrianResource.instance().MdxFuncArgumentsNum.ex(this.getName());
        }
        for (int i = 1; i < argCount; ++i) {
            Exp arg = args[i];
            if (arg instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)arg;
                Dimension dimension = dimensionExpr.getDimension();
                args[i] = new HierarchyExpr(dimension.getHierarchy());
                continue;
            }
            if (arg instanceof HierarchyExpr) continue;
            throw MondrianResource.instance().MdxFuncNotHier.ex(i + 1, this.getName());
        }
        return super.createCall(validator, args);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        switch (args.length) {
            case 1: {
                return new SetType(null);
            }
            case 2: {
                Type argType = args[1].getType();
                return new SetType(new MemberType(argType.getDimension(), argType.getHierarchy(), argType.getLevel(), null));
            }
        }
        ArrayList<MemberType> list = new ArrayList<MemberType>();
        for (int i = 1; i < args.length; ++i) {
            Exp arg = args[i];
            Type argType = arg.getType();
            list.add(new MemberType(argType.getDimension(), argType.getHierarchy(), argType.getLevel(), null));
        }
        Type[] types = list.toArray(new Type[list.size()]);
        return new SetType(new TupleType(types));
    }

    private static class ResolverImpl
    extends ResolverBase {
        ResolverImpl() {
            super("StrToSet", "StrToSet(<String Expression>)", "Constructs a set from a string expression.", Syntax.Function);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length < 1) {
                return null;
            }
            Type type = args[0].getType();
            if (!(type instanceof StringType)) {
                return null;
            }
            for (int i = 1; i < args.length; ++i) {
                Exp exp = args[i];
                if (exp instanceof DimensionExpr) continue;
                return null;
            }
            int[] argTypes = new int[args.length];
            argTypes[0] = 9;
            for (int i = 1; i < argTypes.length; ++i) {
                argTypes[i] = 3;
            }
            return new StrToSetFunDef(argTypes);
        }

        public FunDef getFunDef() {
            return new StrToSetFunDef(new int[]{9});
        }
    }
}

