/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue.formatter;

import java.io.StringWriter;
import java.io.Writer;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.formatter.BarcodeFormatter;
import net.sourceforge.barbecue.formatter.FormattingException;
import net.sourceforge.barbecue.output.OutputException;
import net.sourceforge.barbecue.output.SVGOutput;

public class SVGFormatter
implements BarcodeFormatter {
    private static final String[] UNITS = new String[]{"in", "px", "cm", "mm"};
    private final Writer out;
    private String units;
    private double scalar;

    public static String formatAsSVG(Barcode barcode) throws FormattingException {
        StringWriter stringWriter = new StringWriter();
        new SVGFormatter(stringWriter).format(barcode);
        return stringWriter.toString();
    }

    public SVGFormatter(Writer writer) {
        this(writer, 0.0078125, "in");
    }

    public SVGFormatter(Writer writer, double d, String string) {
        this.out = writer;
        this.setSVGScalar(d, string);
    }

    public void format(Barcode barcode) throws FormattingException {
        try {
            barcode.output(new SVGOutput(this.out, barcode.getFont(), barcode.getForeground(), barcode.getBackground(), this.scalar, this.units));
        }
        catch (OutputException outputException) {
            throw new FormattingException(outputException.getMessage(), outputException);
        }
    }

    public void setSVGScalar(double d, String string) {
        this.validateUnits(string);
        this.scalar = d;
        this.units = string;
    }

    private void validateUnits(String string) {
        boolean bl = false;
        for (int i = 0; i < UNITS.length && !string.equals(UNITS[i]); ++i) {
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < UNITS.length; ++i) {
                String string2 = UNITS[i];
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string2);
            }
            throw new IllegalArgumentException("SVG Units must be one of " + stringBuffer.toString());
        }
    }
}

