/*
// $Id$
// This software is subject to the terms of the Common Public License
// Agreement, available at the following URL:
// http://www.opensource.org/licenses/cpl.html.
// Copyright (C) 2007-2009 Jaspersoft
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package mondrian.test;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import mondrian.spi.Dialect;
import mondrian.spi.Dialect.DatabaseProduct;
import mondrian.spi.Dialect.NullCollation;
import mondrian.spi.DialectManager;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

/**
 * Make a known dialect unknown
 *
 * @author swood
 */
public class UnknownDialectWrapper extends JdbcDialectImpl {

    Dialect wrappedDialect;

    public static final JdbcDialectFactory FACTORY =
        new JdbcDialectFactory(
            UnknownDialectWrapper.class,
            DatabaseProduct.UNKNOWN);

    public UnknownDialectWrapper(Connection conn)
        throws SQLException {
        super(conn);
        wrappedDialect = DialectManager.createDialect(null, conn);
    }

    public DatabaseProduct getDatabaseProduct() {
        return DatabaseProduct.UNKNOWN;
    }

    protected String deduceProductName(DatabaseMetaData databaseMetaData) {
            return "UnknownDialectWrapper";
    }

    public String toUpper(String expr) {
        return wrappedDialect.toUpper(expr);
    }

    public String caseWhenElse(String cond, String thenExpr, String elseExpr) {
        return wrappedDialect.caseWhenElse(cond, thenExpr, elseExpr);
    }

    public String quoteIdentifier(String val) {
        return wrappedDialect.quoteIdentifier(val);
    }

    public void quoteIdentifier(String val, StringBuilder buf) {
        wrappedDialect.quoteIdentifier(val, buf);
    }

    public String quoteIdentifier(String qual, String name) {
        return wrappedDialect.quoteIdentifier(qual, name);
    }

    public void quoteIdentifier(StringBuilder buf, String... names) {
        wrappedDialect.quoteIdentifier(buf, names);
    }

    public String getQuoteIdentifierString() {
        return wrappedDialect.getQuoteIdentifierString();
    }

    public void quoteStringLiteral(StringBuilder buf, String s) {
        wrappedDialect.quoteStringLiteral(buf, s);
    }

    public void quoteNumericLiteral(StringBuilder buf, String value) {
        wrappedDialect.quoteNumericLiteral(buf, value);
    }

    public void quoteBooleanLiteral(StringBuilder buf, String value) {
        wrappedDialect.quoteBooleanLiteral(buf, value);
    }

    public void quoteDateLiteral(StringBuilder buf, String value) {
        wrappedDialect.quoteDateLiteral(buf, value);
    }

    public void quoteTimeLiteral(StringBuilder buf, String value) {
        wrappedDialect.quoteTimeLiteral(buf, value);
    }

    public void quoteTimestampLiteral(StringBuilder buf, String value) {
        wrappedDialect.quoteTimestampLiteral(buf, value);
    }

    public boolean requiresAliasForFromQuery() {
        return wrappedDialect.requiresAliasForFromQuery();
    }

    public boolean allowsAs() {
        return wrappedDialect.allowsAs();
    }

    public boolean allowsFromQuery() {
        return wrappedDialect.allowsFromQuery();
    }

    public boolean allowsCompoundCountDistinct() {
        return wrappedDialect.allowsCompoundCountDistinct();
    }

    public boolean allowsCountDistinct() {
        return wrappedDialect.allowsCountDistinct();
    }

    public boolean allowsMultipleCountDistinct() {
        return wrappedDialect.allowsMultipleCountDistinct();
    }

    public boolean allowsMultipleDistinctSqlMeasures() {
        return wrappedDialect.allowsMultipleDistinctSqlMeasures();
    }

    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return wrappedDialect.generateInline(columnNames, columnTypes, valueList);
    }

    public boolean needsExponent(Object value, String valueString) {
        return wrappedDialect.needsExponent(value, valueString);
    }

    public void quote(StringBuilder buf, Object value, Datatype datatype) {
        wrappedDialect.quote(buf, value, datatype);
    }

    public boolean allowsDdl() {
        return wrappedDialect.allowsDdl();
    }

    public NullCollation getNullCollation() {
        return wrappedDialect.getNullCollation();
    }

    public String generateOrderItem(String expr, boolean nullable, boolean ascending) {
        return wrappedDialect.generateOrderItem(expr, nullable, ascending);
    }

    public boolean supportsGroupByExpressions() {
        return wrappedDialect.supportsGroupByExpressions();
    }

    public boolean supportsGroupingSets() {
        return wrappedDialect.supportsGroupingSets();
    }

    public boolean supportsUnlimitedValueList() {
        return wrappedDialect.supportsUnlimitedValueList();
    }

    public boolean requiresGroupByAlias() {
        return wrappedDialect.requiresGroupByAlias();
    }

    public boolean requiresOrderByAlias() {
        return wrappedDialect.requiresOrderByAlias();
    }

    public boolean allowsOrderByAlias() {
        return wrappedDialect.allowsOrderByAlias();
    }

    public boolean supportsMultiValueInExpr() {
        return wrappedDialect.supportsMultiValueInExpr();
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return wrappedDialect.supportsResultSetConcurrency(type, concurrency);
    }

    public int getMaxColumnNameLength() {
        return wrappedDialect.getMaxColumnNameLength();
    }

    public boolean allowsDialectSharing() {
        return wrappedDialect.allowsDialectSharing();
    }

}
// End UnknownDialectWrapper.java