/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.dto;

import java.util.List;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;

/**
 * @author Ionut Nedelcu (ionutned@users.sourceforge.net)
 * @version $Id: FolderWrapper.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */
public class FolderWrapper implements java.io.Serializable
{
	private Folder actualFolder;
	private boolean edit;
	private List allFolders;

	public List getAllFolders() {
		return allFolders;
	}

	public void setAllFolders(List allFolders) {
		this.allFolders = allFolders;
	}
	
	public FolderWrapper(Folder folder)
	{
		actualFolder = folder;
	}

	public Folder getActualFolder()
	{
		return actualFolder;
	}

	public void setActualFolder(Folder actualFolder)
	{
		this.actualFolder = actualFolder;
	}

	public boolean isEdit()
	{
		return edit;
	}

	public void setEdit(boolean edit)
	{
		this.edit = edit;
	}
}
