/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;

/**
 * @author Ionut Nedelcu (ionutned@users.sourceforge.net)
 * @version $Id
 */
public class ConfigurationBean
{
	private MessageSource messages;

	private int paginatorItemsPerPage;
	private int paginatorPagesRange;
	private boolean reportLevelConfigurable;
	
	private boolean paginationForSinglePageReport;
	
	private String calendarInputJsp;

    private int userItemsPerPage;

    private int roleItemsPerPage;

    private int tenantItemsPerPage;

    private String userNameNotSupportedSymbols;

    private String roleNameNotSupportedSymbols;

    private String userNameSeparator;

    private String defaultRole;

    private String passwordMask;

    private List viewReportsFilterList;
    
    private List outputFolderFilterList;
    private List outputFolderFilterPatterns;

	private String tenantNameNotSupportedSymbols;

    private String tenantIdNotSupportedSymbols;

    private String resourceIdNotSupportedSymbols;

    private String publicFolderUri;

    private String themeDefaultName;
    private String themeFolderName;
    private String themeServletPrefix;

    private String dateFormat;
    private String currentYearDateFormat;
    private String timestampFormat;

    private int entitiesPerPage;
    private String tempFolderUri;
    private String organizationsFolderUri;

    /**
	 * @return Returns the reportLevelConfigurable.
	 */
	public boolean isReportLevelConfigurable() {
		return reportLevelConfigurable;
	}

	/**
	 * @param reportLevelConfigurable The reportLevelConfigurable to set.
	 */
	public void setReportLevelConfigurable(boolean reportLevelConfigurable) {
		this.reportLevelConfigurable = reportLevelConfigurable;
	}

	public Map getAllFileResourceTypes() {
		Map allTypes = new LinkedHashMap();
        allTypes.put(ResourceDescriptor.TYPE_ACCESS_GRANT_SCHEMA,
				    messages.getMessage(JasperServerConst.TYPE_RSRC_ACCESS_GRANT_SCHEMA, null, "Access Grant Schema", LocaleContextHolder.getLocale())); // pro-only
        allTypes.put(FileResource.TYPE_CSS,
                    messages.getMessage(JasperServerConst.TYPE_RSRC_CSS_FILE, null, "CSS File", LocaleContextHolder.getLocale()));
        allTypes.put(FileResource.TYPE_FONT,
					messages.getMessage(JasperServerConst.TYPE_RSRC_FONT, null, "Font", LocaleContextHolder.getLocale()));
        allTypes.put(FileResource.TYPE_IMAGE,
					messages.getMessage(JasperServerConst.TYPE_RSRC_IMAGE, null, "Image", LocaleContextHolder.getLocale()));
        allTypes.put(FileResource.TYPE_JAR,
					messages.getMessage(JasperServerConst.TYPE_RSRC_CLASS_JAR, null, "Jar", LocaleContextHolder.getLocale()));
        allTypes.put(FileResource.TYPE_JRXML,
					messages.getMessage(JasperServerConst.TYPE_RSRC_SUB_REPORT, null, "Jrxml", LocaleContextHolder.getLocale()));
        allTypes.put(ResourceDescriptor.TYPE_MONDRIAN_SCHEMA,
					messages.getMessage(JasperServerConst.TYPE_RSRC_OLAP_SCHEMA, null, "OLAP Schema", LocaleContextHolder.getLocale()));
        allTypes.put(FileResource.TYPE_RESOURCE_BUNDLE,
					messages.getMessage(JasperServerConst.TYPE_RSRC_RESOURCE_BUNDLE, null, "Properties", LocaleContextHolder.getLocale()));
        allTypes.put(FileResource.TYPE_STYLE_TEMPLATE,
				    messages.getMessage(JasperServerConst.TYPE_RSRC_STYLE_TEMPLATE, null, "Style Template", LocaleContextHolder.getLocale()));
        allTypes.put(FileResource.TYPE_XML,
				    messages.getMessage(JasperServerConst.TYPE_RSRC_XML_FILE, null, "XML File", LocaleContextHolder.getLocale()));
		return allTypes;
	}

	public static class DataSourceType {
		private final Class type;
		private final String typeValue;
		private final String labelMessage;
		
		public DataSourceType(final Class type, final String typeValue, final String labelMessage) {
			this.type = type;
			this.typeValue = typeValue;
			this.labelMessage = labelMessage;
		}

		public String getLabelMessage() {
			return labelMessage;
		}

		public Class getType() {
			return type;
		}

		public String getTypeValue() {
			return typeValue;
		}
	}
	
	private final static DataSourceType[] DATA_SOURCE_TYPES = new DataSourceType[] {
		new DataSourceType(JdbcReportDataSource.class, JasperServerConstImpl.getJDBCDatasourceType(), "dataSource.jdbc"),
		new DataSourceType(JndiJdbcReportDataSource.class, JasperServerConstImpl.getJNDIDatasourceType(), "dataSource.jndi"),
		new DataSourceType(BeanReportDataSource.class, JasperServerConstImpl.getBeanDatasourceType(), "dataSource.bean"),
	};
	
	public List getDataSourceTypes() {
		ArrayList types = new ArrayList(DATA_SOURCE_TYPES.length);
		for (int i = 0; i < DATA_SOURCE_TYPES.length; i++) {
			types.add(DATA_SOURCE_TYPES[i]);
		}
		return types;
	}

	public int getPaginatorItemsPerPage()
	{
		return paginatorItemsPerPage;
	}

	public void setPaginatorItemsPerPage(int paginatorItemsPerPage)
	{
		this.paginatorItemsPerPage = paginatorItemsPerPage;
	}

	public int getPaginatorPagesRange()
	{
		return paginatorPagesRange;
	}

	public void setPaginatorPagesRange(int paginatorPagesRange)
	{
		this.paginatorPagesRange = paginatorPagesRange;
	}


	public MessageSource getMessages()
	{
		return messages;
	}

	public void setMessages(MessageSource messages)
	{
		this.messages = messages;
	}

	public boolean isPaginationForSinglePageReport() {
		return paginationForSinglePageReport;
	}

	public void setPaginationForSinglePageReport(
			boolean paginationForSinglePageReport) {
		this.paginationForSinglePageReport = paginationForSinglePageReport;
	}

	public String getCalendarInputJsp() {
		return calendarInputJsp;
	}

	public void setCalendarInputJsp(String calendarInputJsp) {
		this.calendarInputJsp = calendarInputJsp;
	}

    public int getUserItemsPerPage() {
        return userItemsPerPage;
    }

    public void setUserItemsPerPage(int userItemsPerPage) {
        this.userItemsPerPage = userItemsPerPage;
    }

    public int getRoleItemsPerPage() {
        return roleItemsPerPage;
    }

    public void setRoleItemsPerPage(int roleItemsPerPage) {
        this.roleItemsPerPage = roleItemsPerPage;
    }

    public int getTenantItemsPerPage() {
        return tenantItemsPerPage;
    }

    public void setTenantItemsPerPage(int tenantItemsPerPage) {
        this.tenantItemsPerPage = tenantItemsPerPage;
    }

    public String getUserNameSeparator() {
        return userNameSeparator;
    }

    public void setUserNameSeparator(String userNameSeparator) {
        this.userNameSeparator = userNameSeparator;
    }

    public String getUserNameNotSupportedSymbols() {
        return userNameNotSupportedSymbols;
    }

    public void setUserNameNotSupportedSymbols(String userNameNotSupportedSymbols) {
        this.userNameNotSupportedSymbols = userNameNotSupportedSymbols;
    }

    public String getRoleNameNotSupportedSymbols() {
        return roleNameNotSupportedSymbols;
    }

    public void setRoleNameNotSupportedSymbols(String roleNameNotSupportedSymbols) {
        this.roleNameNotSupportedSymbols = roleNameNotSupportedSymbols;
    }

    public String getDefaultRole() {
        return defaultRole;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    public String getPasswordMask() {
        return passwordMask;
    }

    public void setPasswordMask(String passwordMask) {
        this.passwordMask = passwordMask;
    }

    public List getViewReportsFilterList() {
        return viewReportsFilterList;
    }

    public void setViewReportsFilterList(List viewReportsFilterList) {
        this.viewReportsFilterList = viewReportsFilterList;
    }

    public List getOutputFolderFilterList() {
		return outputFolderFilterList;
	}

	public void setOutputFolderFilterList(List outputFolderFilterList) {
		this.outputFolderFilterList = outputFolderFilterList;
		compileOutputFolderFilterPatterns();
	}

	protected void compileOutputFolderFilterPatterns() {
		if (outputFolderFilterList == null) {
			outputFolderFilterPatterns = new ArrayList(0);
		} else {
			outputFolderFilterPatterns = new ArrayList(outputFolderFilterList.size());
			for (Iterator it = outputFolderFilterList.iterator(); it.hasNext();) {
				String filter = (String) it.next();
				Pattern filterPattern = Pattern.compile(filter);
				outputFolderFilterPatterns.add(filterPattern);
			}
		}
	}

	public List getOutputFolderFilterPatterns() {
		return outputFolderFilterPatterns;
	}

    public String getTenantNameNotSupportedSymbols() {
        return tenantNameNotSupportedSymbols;
    }

    public void setTenantNameNotSupportedSymbols(String tenantNameNotSupportedSymbols) {
        this.tenantNameNotSupportedSymbols = tenantNameNotSupportedSymbols;
    }

    public String getTenantIdNotSupportedSymbols() {
        return tenantIdNotSupportedSymbols;
    }

    public void setTenantIdNotSupportedSymbols(String tenantIdNotSupportedSymbols) {
        this.tenantIdNotSupportedSymbols = tenantIdNotSupportedSymbols;
    }

    public String getResourceIdNotSupportedSymbols() {
        return resourceIdNotSupportedSymbols;
    }

    public void setResourceIdNotSupportedSymbols(String resourceIdNotSupportedSymbols) {
        this.resourceIdNotSupportedSymbols = resourceIdNotSupportedSymbols;    
    }

    public String getPublicFolderUri() {
        return publicFolderUri;
    }

    public void setPublicFolderUri(String publicFolderUri) {
        this.publicFolderUri = publicFolderUri;
    }

    public String getThemeDefaultName() {
        return themeDefaultName;
    }

    public void setThemeDefaultName(String themeDefaultName) {
        this.themeDefaultName = themeDefaultName;
    }

    public String getThemeFolderName() {
        return themeFolderName;
    }

    public void setThemeFolderName(String themeFolderName) {
        this.themeFolderName = themeFolderName;
    }

    public String getThemeServletPrefix() {
        return themeServletPrefix;
    }

    public void setThemeServletPrefix(String themeServletPrefix) {
        this.themeServletPrefix = themeServletPrefix;
    }

    public String getDateFormat() {
        return dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getCurrentYearDateFormat() {
        return currentYearDateFormat;
    }

    public void setCurrentYearDateFormat(String currentYearDateFormat) {
        this.currentYearDateFormat = currentYearDateFormat;
    }

    public String getTimestampFormat() {
        return timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public int getEntitiesPerPage() {
        return entitiesPerPage;
    }

    public void setEntitiesPerPage(int entitiesPerPage) {
        this.entitiesPerPage = entitiesPerPage;
    }

    public String getTempFolderUri() {
        return tempFolderUri;
    }

    public void setTempFolderUri(String tempFolderUri) {
        this.tempFolderUri = tempFolderUri;
    }

    public String getOrganizationsFolderUri() {
        return organizationsFolderUri;
    }

    public void setOrganizationsFolderUri(String organizationsFolderUri) {
        this.organizationsFolderUri = organizationsFolderUri;
    }
}
