/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.cascade.cache;

import java.util.*;

/**
 * SessionCacheImpl
 * @author jwhang
 * @version $Id: SessionCacheImpl.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */

public class SessionCacheImpl implements SessionCache {

    private String userGuid; //combination of username and tenant.
    private long lastInteraction = System.currentTimeMillis(); //used for marking sessions for cleanup.
    private Map<String,Object> cacheInfoPool = Collections.synchronizedMap(new HashMap<String,Object>());

    public SessionCacheImpl(String userGuid){
        this.userGuid = userGuid;
    }

    public String getUserGuid() {
        return userGuid;
    }

    protected void setUserGuid(String userGuid) {
        this.userGuid = userGuid;
    }

    public long getLastInteraction() {
        return lastInteraction;
    }

    protected void setLastInteraction(long lastInteraction) {
        this.lastInteraction = lastInteraction;
    }

    public void setCacheInfo(Class controller, String lookupKey, Object cacheInfo){
        setLastInteraction(System.currentTimeMillis());
        cacheInfoPool.put(lookupKey, cacheInfo);
    }

    public Object getCacheInfo(Class controller, Object lookupKey){
        setLastInteraction(System.currentTimeMillis());
        try {
            return cacheInfoPool.get(lookupKey);
        } catch (Exception e){
            //TODO: log error.
            //Any failure should cause the control logic's default mechanism for yielding results to fire.
            return null;
        }
    }
}
