/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.war.action.hyperlinks;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: LocalPageHyperlinkProducerFactory.java 19932 2010-12-11 15:24:29Z tmatyashovsky $
 */
public class LocalPageHyperlinkProducerFactory implements HyperlinkProducerFlowFactory, JRHyperlinkProducer, Serializable {

	private static final long serialVersionUID = 1L;

	private String navigateToPageFunction;
	
	public JRHyperlinkProducer getHyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
		return this;
	}
	
	public String getHyperlink(JRPrintHyperlink hyperlink) {
		Integer page = hyperlink.getHyperlinkPage();
		String ref;
		if (page == null) {
			ref = null;
		} else {
			int pageIdx = page.intValue() - 1;
			ref = "javascript:" + getNavigateToPageFunction() + "(" + pageIdx + ");";
		}
		return ref;
	}

	public String getNavigateToPageFunction() {
		return navigateToPageFunction;
	}

	public void setNavigateToPageFunction(String navigateToPageFunction) {
		this.navigateToPageFunction = navigateToPageFunction;
	}

}
