/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.export.Parameters;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Additional resources for testing get imported here
 * @author swood
 */
public class SampleDataImportTest extends BaseExportTestCase {

    protected static Log log = LogFactory.getLog(SampleDataImportTest.class);

    public SampleDataImportTest(String name) {

    	super(name);
    }

    public void testDemoSampleImport() throws Exception {
        File importDirFile = new File(TEST_BASE_DIR +
                                        FILE_SEPARATOR +
                                        "test-classes" +
                                        FILE_SEPARATOR +
                                        "exportedResources");

        // Load all folders and ZIPs as individual imports and ZIPs

        File[] files = importDirFile.listFiles();

        if (files != null) {

            for (File f : files) {
                Parameters importParams = createParameters();

                try {
                    if (f.isDirectory()) {
                        importParams.addParameterValue(PARAM_IMPORT_DIR, f.toString());
                        log.info("processing directory: " + f);
                    } else if (f.getName().endsWith(".zip")) {
                        importParams.addParameterValue(PARAM_IMPORT_ZIP, f.toString());
                        log.info("processing zip: " + f);
                    } else {
                        log.info("skipping file: " + f);
                    }

                    if (importParams.getParameterNames().hasNext()) {
                        performImport(importParams);
                    }
                } catch (Exception e) {
                    log.error("Error importing file " + f, e);
                    throw e;
                }
            }
        } else {
            log.warn("no files in: " + importDirFile);
        }

    }

}
