/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author swood
 */
        
public class MockStringAuthenticationProvider implements AuthenticationProvider {
    
    private static Log log = LogFactory.getLog(MockStringAuthenticationProvider.class);

    private GrantedAuthority[] grantedAuthorities;
    
    public Authentication authenticate(Authentication auth) throws AuthenticationException {

        log.debug("Initial authentication is: " + auth);
        
        // Only the password "password" is valid

        if (!(auth.getCredentials() instanceof String) || !(((String) auth.getCredentials()).equalsIgnoreCase(AuthenticationTest.testExternalPassword)) ) {
            log.debug("invalid credentials. was " + auth.getCredentials());
            return null;
        }

        UsernamePasswordAuthenticationToken token = null;

        if (auth.getPrincipal() instanceof String) {
            token = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), AuthenticationTest.testExternalPassword, getGrantedAuthorities());
        } else if (auth.getPrincipal() instanceof UserDetails) {
            UserDetails ud = (UserDetails) auth.getPrincipal();

            token = new UsernamePasswordAuthenticationToken(ud.getUsername(), AuthenticationTest.testExternalPassword, getGrantedAuthorities());
        } else {
            
            log.debug("principal is an unknown class: " + auth.getPrincipal().getClass().getName());
            return null;
        }

        log.debug("Setting authentication to: " + token);

        return token;

    }

    public boolean supports(Class arg0) {
        return true;
    }

    public GrantedAuthority[] getGrantedAuthorities() {
        return grantedAuthorities;
    }

    public void setGrantedAuthorities(GrantedAuthority[] grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
    }

}

