package com.jaspersoft.jasperserver.rest.test;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GETTest extends RESTTest {
    
	@Before
	public void setUp() {
    	super.setUp(); 
    	httpReq = new HttpGet();
     }
	
	/** GET TESTS **/
    //returns a list of resources under the folder
	@Test 
    public void Get200ListResources() throws Exception{
    	httpRes = executeCall(httpReq, "/resources/ContentFiles"); 
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
	
    //returns a list of resources under the folder
	@Test 
    public void Get200ListResourcesWithTypeParameter() throws Exception{
		List<NameValuePair> qparams = new ArrayList<NameValuePair>();
    	qparams.add(new BasicNameValuePair("type", "olapMondrianCon"));
    	
		httpRes = executeCall(httpReq, "/resources/analysis/connections", qparams);
    	
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
	
    //returns a list of resources under the folder
	@Test 
    public void Get200ListResourcesWithFileTypeParameter() throws Exception
    {
		
		putSampleImageFileResource(SAMPLE_IMAGE_FILE_SERVER_PATH);
		putSampleFile(SAMPLE_PROPERITES_RD, SAMPLE_PROPERTIES_BIN, SAMPLE_PROPERTIES_SERVER_PATH); //adding a properties file
				
		List<NameValuePair> qparams = new ArrayList<NameValuePair>();
    	qparams.add(new BasicNameValuePair("type", "prop"));
    	
		httpRes = executeCall(httpReq, TEST_DIRECTORY, qparams);
    	
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    	
    	deleteResource(SAMPLE_IMAGE_FILE_SERVER_PATH);
    	deleteResource(SAMPLE_PROPERTIES_SERVER_PATH);
    }
	
	@Test 
    public void Get404NonExistingResource() throws Exception{
    	httpRes = executeCall(httpReq, "/resource/ContentFiles/A/Random/URL"); 
    	Assert.assertTrue("basic response check did not pass", isValidResposnse(404));
    }
	
	@Test 
    public void Get404NonExistingResources() throws Exception{
    	httpRes = executeCall(httpReq, "/resources/ContentFiles/A/Random/URL"); 
    	Assert.assertTrue("basic response check did not pass", isValidResposnse(404));
    }
	
	
	
	/** GET TESTS **/
    //returns a list of resources under the folder
	@Test 
    public void Get200Job() throws Exception{
    	//putJob();
		httpRes = executeCall(httpReq, "/job/1"); 
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
    //trying to resources in a bad url
	@Test 
    public void Get200JobSummery() throws Exception{
    	httpRes = executeCall(httpReq, "/jobsummeries/reports/samples/AllAccounts"); 
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
//    //
//    public void testGet200ListResource() throws Exception{
//    	String path = "ContentFiles/pdf";
//    	
//    	//executing the request
//    	httpResponse = executeCall(httpGet, "/resources/"+path);
//    	
//    	assertTrue("basic response check did not pass", isValidResposnse());
//    }
}
