package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.DeleteService;
import com.jaspersoft.jasperserver.remote.services.GetService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;

import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: carbiv
 * Date: 7/22/11
 * Time: 3:18 PM
 * To change this template use File | Settings | File Templates.
 */
public class RESTJob extends RESTAbstractService {

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException
    {
        try {
            // Get the uri of the resource
            long jobId = getJobId(RESTUtils.extractRepositoryUri(req.getPathInfo()));

            // get the resources....
            GetService service = new GetService(context);

            Job job = service.getJob(jobId);


            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = new Marshaller(stringWriter);
            marshaller.marshal(job);

            String xml = stringWriter.toString();

            RESTUtils.setStatusAndBody(HttpServletResponse.SC_OK, resp, xml);

        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        } catch (MarshalException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        } catch (ValidationException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException
    {
        // Get the uri of the resource
        long jobId = getJobId(RESTUtils.extractRepositoryUri(req.getPathInfo()));

        // get the resources....
        DeleteService service = new DeleteService(context);

        service.deleteJob(jobId);

        Marshaller m = new Marshaller();
        String xml = null; //m.writeResourceDescriptor(job);
        // send the xml...
        RESTUtils.setStatusAndBody(HttpServletResponse.SC_OK, resp, "");

    }

    private long getJobId(String uri) throws ServiceException{
        String jobId;
        if ( uri == null ){
            throw new ServiceException(ServiceException.RESOURCE_BAD_REQUEST, "malformed input parameter");
        }

        else {
            jobId = uri.replace("/", "");
            return Long.parseLong(jobId);
        }
    }
}
