/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

/**
 * Login REST service
 * The dirty job of loggin a user and sending out an error is done by the RESTLoginAuthenticationFilter.
 * This service just return a succesful login message
 * @author gtoffoli
 */
public class LoginService extends AbstractService {

    private final static Log log = LogFactory.getLog(LoginService.class);


    public LoginService(ApplicationContext context)
    {
        super(context);
    }
    
    /**
     * This is a special EMPTY service.
     * Login for services should be based only on HTTP Basic authentication or on a Filter
     * @throws JSException
     */
    public void login() throws ServiceException {
            // Do nothing
    }
}
