/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.UniversalValidationErrorFilter;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;

import java.util.Map;

import com.jaspersoft.jasperserver.remote.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author gtoffoli
 * @version $Id: FolderHandler.java 19933 2010-12-11 15:27:37Z tmatyashovsky $
 */
public class FolderHandler extends AbstractResourceHandler {

    private static final Log log = LogFactory.getLog(FolderHandler.class);

    public Class getResourceType() {
        return Folder.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        descriptor.setWsType(ResourceDescriptor.TYPE_FOLDER);
        descriptor.setHasData(false);
    }

    /*
    @Override
    public ResourceDescriptor update(ResourceDescriptor descriptor, Map options, boolean save) throws ServiceException {

        RepositoryService repository = AbstractService.getContext().getManagementServices().getRepository();


        if (descriptor.getIsNew()) {

            Folder folder = new FolderImpl(); // (Folder) repository.newResource(null, getResourceType());
            folder.setName(descriptor.getName());
            folder.setLabel(descriptor.getLabel());
            folder.setDescription(descriptor.getDescription());
            folder.setParentFolder(descriptor.getParentFolder());
            folder.setVersion(Resource.VERSION_NEW);
            validate(repository, folder); //TODO: failing here with create folder - fix

            repository.saveFolder(null, folder);

            return AbstractService.getContext().getManagementServices().createResourceDescriptor(folder.getURIString());

        } else {

            Folder res = repository.getFolder(null, descriptor.getUriString());

            if (res != null) {
                if (res.getLabel() == null || !res.getLabel().equals(descriptor.getLabel())) {
                    res.setLabel(descriptor.getLabel());
                }

                if (res.getDescription() == null || !res.getDescription().equals(descriptor.getDescription())) {
                    res.setDescription(descriptor.getDescription());
                }

                validate(repository, res);
                repository.saveFolder(null, res);

                return AbstractService.getContext().getManagementServices().createResourceDescriptor(res);
            } else {
                throw new ServiceException(2, AbstractService.getContext().getMessage("webservices.error.folderNotFound"));
            }
        }
    }
*/
    protected void validate(RepositoryService repository, Folder folder) throws ServiceException
    {
            ValidationErrorFilter filter = folder.isNew()? UniversalValidationErrorFilter.getInstance() : null;
            ValidationErrors errors = repository.validateFolder(null, folder, filter);

            if (errors.isError()) {
                throw new ServiceException(ServiceException.FORBIDDEN, errors.toString());
            }

    }


}
