/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */


package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.remote.ReportExporter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;

/**
 *
 * @author gtoffoli
 */
public abstract class AbstractExporter implements ReportExporter {

    JRExporter exporter = null;

    public Map exportReport(JasperPrint jasperPrint, OutputStream output, EngineService engineService, HashMap exportParameters, ExecutionContext executionContext, String reportUnitURI) throws Exception {

        exporter = createExporter();

        // Handle generic parameters....
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
	exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, output);



        // Be sure the page number is correctly set, so PAGE 1 is PAGE 1...
        // JasperReports uses a 0 based page system, while we prefer a 1 based page system
        if (exportParameters.get(Argument.RUN_OUTPUT_PAGE) != null)
        {
            int pageIndex = Integer.parseInt( (String)exportParameters.get(Argument.RUN_OUTPUT_PAGE));
            pageIndex--; // transform a 1 index page to 0 indexed page...
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, pageIndex);
        }


        // Give the opportunity to each exporter to better configure itself...
        configureExporter(exporter, exportParameters);


        exporter.exportReport();
	return exporter.getParameters();
    }

    public abstract JRExporter createExporter() throws Exception;

    public abstract void configureExporter(JRExporter exporter, HashMap exportParameters) throws Exception;

}
