/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author gtoffoli
 */
public class AlignedTableCellRenderer extends DefaultTableCellRenderer {
    
    private int alignment = JLabel.RIGHT;
    static ImageIcon imageIcon;
    static ImageIcon subreportIcon;
    
    /** Creates a new instance of AlignedTableCellRenderer */
    public AlignedTableCellRenderer() {
        this(JLabel.RIGHT);
    }
    
    /** Creates a new instance of AlignedTableCellRenderer */
    public AlignedTableCellRenderer(int alignment) {
        super();
        if (subreportIcon == null) subreportIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/subreport.gif"));
        if (imageIcon == null) imageIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/image.gif"));
        this.alignment = alignment;
    }
    
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                
                if (c instanceof JLabel)
                {
                    ((JLabel)c).setHorizontalAlignment( getAlignment());
                    if (value instanceof ImageElementValidationItem)
                    {
                         ((JLabel)c).setIcon( imageIcon );
                    }
                    else if (value instanceof SubReportElementValidationItem)
                    {
                         ((JLabel)c).setIcon( subreportIcon );
                    }
                }
                
                return c;
    }

    public int getAlignment() {
        return alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }
    
}
