/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: QuartzSchedulerControl.java 20407 2011-04-26 10:23:57Z vsabadosh $
 */
public class QuartzSchedulerControl implements ApplicationContextAware {
	
	private static final Log log = LogFactory.getLog(QuartzSchedulerControl.class);
	
	private Scheduler scheduler;

    private ApplicationContext applicationContext;

	public Scheduler getScheduler() {
		return scheduler;
	}

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
		this.scheduler = scheduler;
	}

	public void start() {
		try {
			//if scheduler is in standby mode and current context in not export-import context then scheduler will started
            //otherwise scheduler will not be started because job during import-export can't be executed.
            if (getScheduler().isInStandbyMode() && !applicationContext.containsBean("importCommandMetadata")) {
				getScheduler().start();
			} else if (!getScheduler().isInStandbyMode()) {
				if (log.isDebugEnabled()) {
					log.debug("Scheduler already running.");
				}
			} else {
                if (log.isDebugEnabled()) {
                    log.debug("Scheduler can't be started in the scope of import-export tool.");
                }
            }
		} catch (SchedulerException e) {
			log.error("Error starting the scheduler", e);
			throw new JSExceptionWrapper(e);
		}
	}
}
