/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: AcegiSecurityContextProvider.java 19922 2010-12-11 14:59:51Z tmatyashovsky $
 */
public class AcegiSecurityContextProvider implements SecurityContextProvider {
	
	private static final Log log = LogFactory.getLog(AcegiSecurityContextProvider.class); 
	
	private UserDetailsService userDetailsService;
	private UserAuthorityService userAuthorityService;

	public UserDetailsService getUserDetailsService() {
		return userDetailsService;
	}

	public void setUserDetailsService(UserDetailsService userDetailsService) {
		this.userDetailsService = userDetailsService;
	}

	public UserAuthorityService getUserAuthorityService() {
		return userAuthorityService;
	}

	public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
		this.userAuthorityService = userAuthorityService;
	}

	public String getContextUsername() {
		Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
		if (authenticationToken == null) {
			return null;
		}
		
		if (authenticationToken.getPrincipal() instanceof UserDetails) {
			UserDetails contextUserDetails = (UserDetails) authenticationToken.getPrincipal();
			return contextUserDetails.getUsername();
		} else if (authenticationToken.getPrincipal() instanceof String) {
			return (String) authenticationToken.getPrincipal();
		} else {
			return null;
		}
	}
	
	public User getContextUser() {
		String username = getContextUsername();
		if (username == null) {
			return null;
		}
		return getUserAuthorityService().getUser(null, username);//TODO context
	}

	public void setAuthenticatedUser(String username) {
		UserDetails userDetails = getUserDetailsService().loadUserByUsername(username);
		String quotedUsername = "\"" + username + "\"";
		if (userDetails == null) {
			throw new JSException("jsexception.user.not.found", new Object[] {quotedUsername});
		}
		
		if (!userDetails.isAccountNonExpired()) {
			throw new JSException("jsexception.user.expired", new Object[] {quotedUsername});
		}
		
		if (!userDetails.isAccountNonLocked()) {
			throw new JSException("jsexception.user.locked", new Object[] {quotedUsername});
		}
		
		if (!userDetails.isCredentialsNonExpired()) {
			throw new JSException("jsexception.user.credentials.are.expired", new Object[] {quotedUsername});
		}
		
		if (!userDetails.isEnabled()) {
			throw new JSException("jsexception.user.disabled", new Object[] {quotedUsername});
		}
		
		if (log.isDebugEnabled()) {
			log.debug("Setting user " + username + " as authenticated");
		}
		
		UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(userDetails, userDetails.getPassword(), userDetails.getAuthorities());
		SecurityContextHolder.getContext().setAuthentication(authenticationToken);
	}

	public void revertAuthenticatedUser() {
		// TODO revert to previous principal
		SecurityContextHolder.getContext().setAuthentication(null);
	}

}
