/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.CppGenerator;
import org.eigenbase.resgen.CppHeaderGenerator;
import org.eigenbase.resgen.FileTask;
import org.eigenbase.resgen.Generator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.ResourceGenTask;
import org.eigenbase.resgen.Util;

class XmlFileTask
extends FileTask {
    final String baseClassName;
    final String cppBaseClassName;

    XmlFileTask(ResourceGenTask.Include include, String string, String string2, String string3, boolean bl, String string4, String string5, boolean bl2) {
        this.include = include;
        this.fileName = string;
        this.outputJava = bl;
        if (string2 == null) {
            string2 = Util.fileNameToClassName(string, ".xml");
        }
        this.className = string2;
        if (string3 == null) {
            string3 = "org.eigenbase.resgen.ShadowResourceBundle";
        }
        this.baseClassName = string3;
        this.outputCpp = bl2;
        if (string4 == null) {
            string4 = Util.fileNameToCppClassName(string, ".xml");
        }
        this.cppClassName = string4;
        if (string5 == null) {
            string5 = "ResourceBundle";
        }
        this.cppBaseClassName = string5;
    }

    void process(ResourceGen resourceGen) throws IOException {
        Object object;
        int n;
        Locale[] localeArray;
        URL uRL = Util.convertPathToURL(this.getFile());
        ResourceDef.ResourceBundle resourceBundle = Util.load(uRL);
        if (resourceBundle.locale == null) {
            throw new BuildException("Resource file " + uRL + " must have locale");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.include.root.locales == null) {
            arrayList.add(resourceBundle.locale);
        } else {
            localeArray = new StringTokenizer(this.include.root.locales, ",");
            while (localeArray.hasMoreTokens()) {
                String string = localeArray.nextToken();
                arrayList.add(string);
            }
        }
        if (!arrayList.contains(resourceBundle.locale)) {
            throw new BuildException("Resource file " + uRL + " has locale '" + resourceBundle.locale + "' which is not in the 'locales' list");
        }
        localeArray = new Locale[arrayList.size()];
        for (n = 0; n < localeArray.length; ++n) {
            object = (String)arrayList.get(n);
            localeArray[n] = Util.parseLocale((String)object);
            if (localeArray[n] != null) continue;
            throw new BuildException("Invalid locale " + (String)object);
        }
        if (this.outputJava) {
            this.generateJava(resourceGen, resourceBundle, null);
        }
        this.generateProperties(resourceGen, resourceBundle, null);
        for (n = 0; n < localeArray.length; ++n) {
            object = localeArray[n];
            if (this.outputJava) {
                this.generateJava(resourceGen, resourceBundle, (Locale)object);
            }
            this.generateProperties(resourceGen, resourceBundle, (Locale)object);
        }
        if (this.outputCpp) {
            this.generateCpp(resourceGen, resourceBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateProperties(ResourceGen resourceGen, ResourceDef.ResourceBundle resourceBundle, Locale locale) {
        FileOutputStream fileOutputStream;
        File file;
        String string = Util.getClassNameSansPackage(this.className, locale) + ".properties";
        File file2 = new File(this.getResourceDirectory(), string);
        File file3 = file = locale == null ? this.getFile() : new File(this.getSrcDirectory(), string);
        if (file2.exists()) {
            if (locale != null && file2.equals(file)) {
                return;
            }
            if (file2.lastModified() >= file.lastModified()) {
                resourceGen.comment(file2 + " is up to date");
                return;
            }
            if (!file2.canWrite()) {
                resourceGen.comment(file2 + " is read-only");
                return;
            }
        }
        resourceGen.comment("Generating " + file2);
        try {
            if (file2.getParentFile() != null) {
                file2.getParentFile().mkdirs();
            }
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("Error while writing " + file2, (Throwable)fileNotFoundException);
        }
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        try {
            if (locale == null) {
                this.generateBaseProperties(resourceBundle, printWriter);
            } else {
                this.generateProperties(printWriter, file2, file, locale);
            }
        }
        finally {
            printWriter.close();
        }
    }

    private void generateBaseProperties(ResourceDef.ResourceBundle resourceBundle, PrintWriter printWriter) {
        String string = this.getClassName(null);
        printWriter.println("# This file contains the resources for");
        printWriter.println("# class '" + string + "'; the base locale is '" + resourceBundle.locale + "'.");
        printWriter.println("# It was generated by " + ResourceGen.class);
        printWriter.println("# from " + this.getFileForComments());
        if (this.include.root.commentStyle != 2) {
            printWriter.println("# on " + new Date().toString() + ".");
        }
        printWriter.println();
        for (int i = 0; i < resourceBundle.resources.length; ++i) {
            ResourceDef.Resource resource = resourceBundle.resources[i];
            String string2 = resource.name;
            if (resource.text == null) {
                throw new BuildException("Resource '" + string2 + "' has no message");
            }
            String string3 = resource.text.cdata;
            if (string3 == null) continue;
            printWriter.println(string2 + "=" + Util.quoteForProperties(string3));
        }
        printWriter.println("# End " + string + ".properties");
    }

    private void generateProperties(PrintWriter printWriter, File file, File file2, Locale locale) {
        if (file2.exists() && file2.canRead() && !file.equals(file2)) {
            try {
                int n;
                FileReader fileReader = new FileReader(file2);
                char[] cArray = new char[1000];
                while ((n = fileReader.read(cArray)) > 0) {
                    printWriter.write(cArray, 0, n);
                }
                return;
            }
            catch (IOException iOException) {
                throw new BuildException("Error while copying from '" + file2 + "'");
            }
        }
        String string = this.getClassName(locale);
        printWriter.println("# This file contains the resources for");
        printWriter.println("# class '" + string + "' and locale '" + locale + "'.");
        printWriter.println("# It was generated by " + ResourceGen.class);
        printWriter.println("# from " + this.getFileForComments());
        if (this.include.root.commentStyle != 2) {
            printWriter.println("# on " + new Date().toString() + ".");
        }
        printWriter.println();
        printWriter.println("# This file is intentionally blank. Add property values");
        printWriter.println("# to this file to override the translations in the base");
        String string2 = Util.getClassNameSansPackage(this.className, locale) + ".properties";
        printWriter.println("# properties file, " + string2);
        printWriter.println();
        printWriter.println("# End " + string + ".properties");
    }

    private String getClassName(Locale locale) {
        String string = this.className;
        if (locale != null) {
            string = string + '_' + locale.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCpp(ResourceGen resourceGen, ResourceDef.ResourceBundle resourceBundle) {
        Object object;
        FileOutputStream fileOutputStream;
        Object object2;
        Object object3;
        String string = resourceBundle.cppExceptionClassName;
        String string2 = resourceBundle.cppExceptionClassLocation;
        if (string != null && string2 == null) {
            throw new BuildException("C++ exception class is defined without a header file location in " + this.getFile());
        }
        for (int i = 0; i < resourceBundle.resources.length; ++i) {
            object3 = resourceBundle.resources[i];
            if (object3.text == null) {
                throw new BuildException("Resource '" + object3.name + "' has no message");
            }
            if (!(object3 instanceof ResourceDef.Exception)) continue;
            object2 = (ResourceDef.Exception)((Object)object3);
            if (object2.cppClassName != null && object2.cppClassLocation == null && string2 == null) {
                throw new BuildException("C++ exception class specified for " + object2.name + " without specifiying a header location in " + this.getFile());
            }
            if (string != null || object2.cppClassName != null) continue;
            throw new BuildException("No exception class specified for " + object2.name + " in " + this.getFile());
        }
        String string3 = this.cppClassName + ".h";
        object3 = this.cppClassName + ".cpp";
        object2 = new File(this.include.root.dest, string3);
        File file = new File(this.include.root.dest, (String)object3);
        boolean bl = true;
        if (!this.checkUpToDate(resourceGen, (File)object2)) {
            bl = false;
        }
        if (!this.checkUpToDate(resourceGen, file)) {
            bl = false;
        }
        if (bl && !this.include.root.force) {
            return;
        }
        resourceGen.comment("Generating " + (Object)object2);
        try {
            this.makeParentDirs((File)object2);
            fileOutputStream = new FileOutputStream((File)object2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("Error while writing " + (Object)object2, (Throwable)fileNotFoundException);
        }
        String string4 = Util.removePackage(this.className);
        String string5 = Util.removePackage(this.cppBaseClassName);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        try {
            object = new CppHeaderGenerator(this.getFile(), (File)object2, string4, string5, string);
            this.configureCommentStyle((Generator)object);
            ((CppHeaderGenerator)object).generateModule(resourceGen, resourceBundle, printWriter);
        }
        finally {
            printWriter.close();
        }
        resourceGen.comment("Generating " + file);
        try {
            this.makeParentDirs(file);
            object = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException("Error while writing " + file, (Throwable)fileNotFoundException);
        }
        printWriter = new PrintWriter((OutputStream)object);
        try {
            CppGenerator cppGenerator = new CppGenerator(this.getFile(), file, string4, string5, string, string3);
            this.configureCommentStyle(cppGenerator);
            cppGenerator.generateModule(resourceGen, resourceBundle, printWriter);
        }
        finally {
            printWriter.close();
        }
    }
}

