/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRDesignGenericElement
extends JRDesignElement
implements JRGenericElement {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_GENERIC_TYPE = "genericType";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP_NAME = "evaluationGroupName";
    public static final String PROPERTY_PARAMETERS = "parameters";
    private JRGenericElementType genericType;
    private List<JRGenericElementParameter> parameters = new ArrayList<JRGenericElementParameter>();
    private EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    private String evaluationGroupName;
    private int PSEUDO_SERIAL_VERSION_UID = 40003;
    private byte evaluationTime;

    public JRDesignGenericElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public JRGenericElementParameter[] getParameters() {
        return this.parameters.toArray(new JRGenericElementParameter[this.parameters.size()]);
    }

    public List<JRGenericElementParameter> getParamtersList() {
        return this.getParametersList();
    }

    public List<JRGenericElementParameter> getParametersList() {
        return this.parameters;
    }

    public void addParameter(JRGenericElementParameter parameter) {
        this.parameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, this.parameters.size() - 1);
    }

    public boolean removeParameter(JRGenericElementParameter parameter) {
        int idx = this.parameters.indexOf(parameter);
        if (idx >= 0) {
            this.parameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, parameter, idx);
            return true;
        }
        return false;
    }

    public JRGenericElementParameter removeParameter(String parameterName) {
        JRGenericElementParameter removed = null;
        ListIterator<JRGenericElementParameter> it = this.parameters.listIterator();
        while (it.hasNext()) {
            JRGenericElementParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            removed = parameter;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, parameter, it.nextIndex());
            break;
        }
        return removed;
    }

    @Override
    public JRGenericElementType getGenericType() {
        return this.genericType;
    }

    public void setGenericType(JRGenericElementType genericType) {
        JRGenericElementType old = this.genericType;
        this.genericType = genericType;
        this.getEventSupport().firePropertyChange(PROPERTY_GENERIC_TYPE, old, this.genericType);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitGenericElement(this);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTimeValue;
        this.evaluationTimeValue = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTimeValue);
    }

    @Override
    public String getEvaluationGroupName() {
        return this.evaluationGroupName;
    }

    public void setEvaluationGroupName(String evaluationGroupName) {
        String old = this.evaluationGroupName;
        this.evaluationGroupName = evaluationGroupName;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP_NAME, old, this.evaluationGroupName);
    }

    @Override
    public Object clone() {
        JRDesignGenericElement clone = (JRDesignGenericElement)super.clone();
        clone.parameters = JRCloneUtils.cloneList(this.parameters);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
        }
    }
}

