/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Aggregator;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapEvaluator;
import mondrian.spi.Dialect;
import org.eigenbase.util.property.IntegerProperty;

public class AggregateFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver resolver = new ReflectiveMultiResolver("Aggregate", "Aggregate(<Set>[, <Numeric Expression>])", "Returns a calculated value using the appropriate aggregate function, based on the context of the query.", new String[]{"fnx", "fnxn"}, AggregateFunDef.class);

    public AggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AggregateCalc(call, listCalc, calc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AggregateCalc
    extends GenericCalc {
        private final ListCalc listCalc;
        private final Calc calc;

        public AggregateCalc(Exp exp, ListCalc listCalc, Calc calc) {
            super(exp, new Calc[]{listCalc, calc});
            this.listCalc = listCalc;
            this.calc = calc;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            List list = AbstractAggregateFunDef.evaluateCurrentList(this.listCalc, evaluator);
            return AggregateCalc.aggregate(this.calc, evaluator, list);
        }

        public static Object aggregate(Calc calc, Evaluator evaluator, List list) {
            Aggregator aggregator = (Aggregator)evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
            if (aggregator == null) {
                throw FunUtil.newEvalException(null, "Could not find an aggregator in the current evaluation context");
            }
            Aggregator rollup = aggregator.getRollup();
            if (rollup == null) {
                throw FunUtil.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
            }
            if (aggregator != RolapAggregator.DistinctCount) {
                return rollup.aggregate(evaluator.push(false), list, calc);
            }
            if (list.size() == 0) {
                return 1.2345E-8;
            }
            List<Member[]> tupleList = list.get(0) instanceof Member ? AggregateCalc.makeTupleList((List<Member>)list) : list;
            tupleList = AggregateCalc.optimizeTupleList(evaluator, tupleList);
            Evaluator evaluator2 = evaluator.pushAggregation(tupleList);
            evaluator2.setNonEmpty(false);
            return evaluator2.evaluateCurrent();
        }

        public static List<Member[]> optimizeTupleList(Evaluator evaluator, List<Member[]> tupleList) {
            RolapEvaluator rolapEvaluator = null;
            if (evaluator instanceof RolapEvaluator) {
                rolapEvaluator = (RolapEvaluator)evaluator;
            }
            if (rolapEvaluator == null || !rolapEvaluator.getDialect().supportsUnlimitedValueList()) {
                if (rolapEvaluator == null || rolapEvaluator.getDialect().getDatabaseProduct() == Dialect.DatabaseProduct.ACCESS) {
                    // empty if block
                }
                tupleList = AggregateCalc.optimizeChildren(tupleList, evaluator.getSchemaReader(), evaluator.getMeasureCube());
                AggregateCalc.checkIfAggregationSizeIsTooLarge(tupleList);
            }
            return tupleList;
        }

        public static List<Member[]> removeOverlappingTupleEntries(List<Member[]> list) {
            ArrayList<Member[]> trimmedList = new ArrayList<Member[]>();
            for (Member[] tuple1 : list) {
                if (trimmedList.isEmpty()) {
                    trimmedList.add(tuple1);
                    continue;
                }
                boolean ignore = false;
                Iterator iterator = trimmedList.iterator();
                while (iterator.hasNext()) {
                    Member[] tuple2 = (Member[])iterator.next();
                    if (AggregateCalc.isSuperSet(tuple1, tuple2)) {
                        iterator.remove();
                        continue;
                    }
                    if (!AggregateCalc.isSuperSet(tuple2, tuple1) && !AggregateCalc.isEqual(tuple1, tuple2)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                trimmedList.add(tuple1);
            }
            return trimmedList;
        }

        public static boolean isSuperSet(Member[] tuple1, Member[] tuple2) {
            int parentLevelCount = 0;
            for (int i = 0; i < tuple1.length; ++i) {
                Member member2 = tuple2[i];
                Member member1 = tuple1[i];
                if (!member2.isChildOrEqualTo(member1)) {
                    return false;
                }
                if (member1.getLevel().getDepth() >= member2.getLevel().getDepth()) continue;
                ++parentLevelCount;
            }
            return parentLevelCount > 0;
        }

        public static List<Member[]> makeTupleList(List<Member> list) {
            ArrayList<Member[]> tupleList = new ArrayList<Member[]>(list.size());
            for (Member member : list) {
                tupleList.add(new Member[]{member});
            }
            return tupleList;
        }

        private static void checkIfAggregationSizeIsTooLarge(List list) {
            IntegerProperty property = MondrianProperties.instance().MaxConstraints;
            int maxConstraints = property.get();
            if (list.size() > maxConstraints) {
                throw FunUtil.newEvalException(null, "Aggregation is not supported over a list with more than " + maxConstraints + " predicates" + " (see property " + property.getPath() + ")");
            }
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            if (hierarchy.getDimension().isMeasures()) {
                return true;
            }
            return AggregateCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }

        public static List<Member[]> optimizeChildren(List<Member[]> tuples, SchemaReader reader, Cube baseCubeForMeasure) {
            Map<Member, Integer>[] membersOccurencesInTuple = AggregateCalc.membersVersusOccurencesInTuple(tuples);
            int tupleLength = tuples.get(0).length;
            Set[] sets = new Set[tupleLength];
            boolean optimized = false;
            for (int i = 0; i < tupleLength; ++i) {
                if (!Util.areOccurencesEqual(membersOccurencesInTuple[i].values())) continue;
                Set<Member> members = membersOccurencesInTuple[i].keySet();
                int originalSize = members.size();
                sets[i] = AggregateCalc.optimizeMemberSet(new LinkedHashSet<Member>(members), reader, baseCubeForMeasure);
                if (sets[i].size() == originalSize) continue;
                optimized = true;
            }
            if (optimized) {
                if (sets.length == 1) {
                    Set set = sets[0];
                    ArrayList<Member[]> tupleList = new ArrayList<Member[]>(set.size());
                    for (Member member : set) {
                        tupleList.add(new Member[]{member});
                    }
                    return tupleList;
                }
                return AggregateCalc.crossProd(sets);
            }
            return tuples;
        }

        public static Map<Member, Integer>[] membersVersusOccurencesInTuple(List<Member[]> tuples) {
            int tupleLength = tuples.get(0).length;
            Map[] counters = new Map[tupleLength];
            for (int i = 0; i < counters.length; ++i) {
                counters[i] = new LinkedHashMap();
            }
            for (Member[] tuple : tuples) {
                for (int i = 0; i < tuple.length; ++i) {
                    Map map = counters[i];
                    Member member = tuple[i];
                    if (map.containsKey(member)) {
                        Integer count = (Integer)map.get(member);
                        count = count + 1;
                        map.put(member, count);
                        continue;
                    }
                    map.put(member, 1);
                }
            }
            return counters;
        }

        private static Set<Member> optimizeMemberSet(Set<Member> members, SchemaReader reader, Cube baseCubeForMeasure) {
            LinkedHashSet<Member> membersToBeOptimized = new LinkedHashSet<Member>();
            Set<Member> optimizedMembers = new LinkedHashSet<Member>();
            while (members.size() > 0) {
                boolean didOptimize;
                Iterator<Member> iterator = members.iterator();
                Member first = iterator.next();
                if (first.isAll()) {
                    optimizedMembers.clear();
                    optimizedMembers.add(first);
                    return optimizedMembers;
                }
                membersToBeOptimized.add(first);
                iterator.remove();
                Member firstParentMember = first.getParentMember();
                while (iterator.hasNext()) {
                    Member current = iterator.next();
                    if (current.isAll()) {
                        optimizedMembers.clear();
                        optimizedMembers.add(current);
                        return optimizedMembers;
                    }
                    Member currentParentMember = current.getParentMember();
                    if ((firstParentMember != null || currentParentMember != null) && (firstParentMember == null || !firstParentMember.equals(currentParentMember))) continue;
                    membersToBeOptimized.add(current);
                    iterator.remove();
                }
                int childCountOfParent = -1;
                if (firstParentMember != null) {
                    childCountOfParent = AggregateCalc.getChildCount(firstParentMember, reader);
                }
                if (childCountOfParent != -1 && membersToBeOptimized.size() == childCountOfParent && AggregateCalc.canOptimize(firstParentMember, baseCubeForMeasure)) {
                    optimizedMembers.add(firstParentMember);
                    didOptimize = true;
                } else {
                    optimizedMembers.addAll(membersToBeOptimized);
                    didOptimize = false;
                }
                membersToBeOptimized.clear();
                if (members.size() != 0 || !didOptimize) continue;
                Set<Member> temp = members;
                members = optimizedMembers;
                optimizedMembers = temp;
            }
            return optimizedMembers;
        }

        private static boolean isEqual(Member[] tuple1, Member[] tuple2) {
            for (int i = 0; i < tuple1.length; ++i) {
                if (tuple1[i].getUniqueName().equals(tuple2[i].getUniqueName())) continue;
                return false;
            }
            return true;
        }

        private static boolean canOptimize(Member parentMember, Cube baseCube) {
            return AggregateCalc.dimensionJoinsToBaseCube(parentMember.getDimension(), baseCube) || !parentMember.isAll();
        }

        private static List<Member[]> crossProd(Set<Member>[] sets) {
            ArrayList<Member> firstList = new ArrayList<Member>(sets[0]);
            ArrayList<Member> secondList = new ArrayList<Member>(sets[1]);
            List<Member[]> tupleList = CrossJoinFunDef.crossJoin(firstList, secondList);
            for (int i = 2; i < sets.length; ++i) {
                Set<Member> set = sets[i];
                tupleList = CrossJoinFunDef.crossJoin(tupleList, new ArrayList<Member>(set));
            }
            return tupleList;
        }

        private static boolean dimensionJoinsToBaseCube(Dimension dimension, Cube baseCube) {
            HashSet<Dimension> dimensions = new HashSet<Dimension>();
            dimensions.add(dimension);
            return baseCube.nonJoiningDimensions(dimensions).size() == 0;
        }

        private static int getChildCount(Member parentMember, SchemaReader reader) {
            int childrenCountFromCache = reader.getChildrenCountFromCache(parentMember);
            if (childrenCountFromCache != -1) {
                return childrenCountFromCache;
            }
            return reader.getMemberChildren(parentMember).size();
        }
    }
}

