/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.Collections;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.springframework.binding.expression.EvaluationAttempt;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.expression.SetPropertyAttempt;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

class OgnlExpression
implements PropertyExpression {
    private Object expression;

    public OgnlExpression(Object expression) {
        this.expression = expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OgnlExpression)) {
            return false;
        }
        OgnlExpression other = (OgnlExpression)o;
        return this.expression.equals(other.expression);
    }

    public Object evaluateAgainst(Object target, Map evaluationContext) throws EvaluationException {
        try {
            Assert.notNull((Object)target, (String)"The target object to evaluate is required");
            if (evaluationContext == null) {
                evaluationContext = Collections.EMPTY_MAP;
            }
            return Ognl.getValue((Object)this.expression, (Map)evaluationContext, (Object)target);
        }
        catch (OgnlException e) {
            throw new EvaluationException(new EvaluationAttempt(this, target, evaluationContext), e);
        }
    }

    public void setValue(Object target, Object value, Map setContext) {
        try {
            Assert.notNull((Object)target, (String)"The target object is required");
            if (setContext == null) {
                setContext = Collections.EMPTY_MAP;
            }
            Ognl.setValue((Object)this.expression, (Map)setContext, (Object)target, (Object)value);
        }
        catch (OgnlException e) {
            throw new EvaluationException(new SetPropertyAttempt(this, target, value, setContext), e);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("expression", this.expression).toString();
    }
}

