/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.cobertura.tasks.ReportTask;

public class CoberturaReportMojo
extends AbstractMavenReport {
    private static String COBERTURA_CONSOLIDATED_FILENAME = "target/cobertura/consolidate-cobertura.ser";
    private String format;
    private String[] formats = new String[]{"html"};
    private String encoding;
    private String maxmem = "64m";
    protected List<MavenProject> reactorProjects;
    protected File dataFile;
    protected List pluginClasspathList;
    private String outputDirectory;
    private boolean quiet;
    private MavenProject project;
    private boolean useConsolidated;
    private String dataFileName;

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.cobertura.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.cobertura.description");
    }

    protected String getOutputDirectory() {
        return new File(this.outputDirectory).getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return new DefaultSiteRenderer();
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.executeReport(locale);
    }

    private void executeReportTask(ReportTask task, String format) throws MavenReportException {
        task.setOutputFormat(format);
        try {
            task.execute();
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error in Cobertura Report generation: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.project.equals((Object)this.reactorProjects.get(this.reactorProjects.size() - 1))) {
            return;
        }
        for (MavenProject reactorProject : this.reactorProjects) {
            if (this.useConsolidated) {
                this.dataFileName = COBERTURA_CONSOLIDATED_FILENAME;
            }
            this.dataFile = new File(reactorProject.getBasedir(), this.dataFileName);
            this.getLog().info((CharSequence)("Using coverage data of file " + this.dataFile.getAbsolutePath()));
            if (!this.canGenerateReport()) continue;
            ReportTask task = new ReportTask();
            task.setLog(this.getLog());
            task.setPluginClasspathList(this.pluginClasspathList);
            task.setQuiet(this.quiet);
            task.setMaxmem(this.maxmem);
            task.setDataFile(this.dataFile);
            File moduleReportOutputDirectory = new File(reactorProject.getReporting().getOutputDirectory(), "cobertura");
            task.setOutputDirectory(moduleReportOutputDirectory);
            List sourceRoots = new ArrayList();
            if ("pom".equals(reactorProject.getPackaging())) {
                for (MavenProject module : this.reactorProjects) {
                    sourceRoots.addAll(module.getCompileSourceRoots());
                }
            } else {
                sourceRoots = reactorProject.getCompileSourceRoots();
            }
            task.setCompileSourceRoots(sourceRoots);
            task.setSourceEncoding(this.encoding);
            if (this.format != null) {
                this.formats = new String[]{this.format};
            }
            this.getLog().info((CharSequence)("Generating report in " + moduleReportOutputDirectory.getAbsolutePath()));
            for (String format1 : this.formats) {
                this.executeReportTask(task, format1);
            }
        }
    }

    public String getOutputName() {
        return "index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        if (this.dataFile == null || !this.dataFile.exists()) {
            this.getLog().info((CharSequence)("Not executing cobertura:report as the cobertura data file (" + this.dataFile + ") could not be found"));
            return false;
        }
        return true;
    }

    private List getCompileSourceRoots() {
        MavenProject executionProject = this.project.getExecutionProject();
        if (executionProject == null) {
            return Collections.emptyList();
        }
        return executionProject.getCompileSourceRoots();
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cobertura-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

