/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;

final class JRDoubleSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRDoubleSumIncrementer mainInstance = new JRDoubleSumIncrementer();

    private JRDoubleSumIncrementer() {
    }

    public static JRDoubleSumIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRDoubleIncrementerFactory.ZERO;
        }
        return new Double(value.doubleValue() + newValue.doubleValue());
    }

    public Object initialValue() {
        return JRDoubleIncrementerFactory.ZERO;
    }
}

