/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.oasis.GenericElementOdsHandler;
import net.sf.jasperreports.engine.export.oasis.JROdsExporterContext;
import net.sf.jasperreports.engine.export.oasis.JROdsExporterNature;
import net.sf.jasperreports.engine.export.oasis.JROpenDocumentExporter;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROdsExporter
extends JROpenDocumentExporter {
    private static final Log log = LogFactory.getLog(JROdsExporter.class);
    protected static final String ODS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.ods.";
    public static final String ODS_EXPORTER_KEY = "net.sf.jasperreports.ods";

    protected ExporterNature getExporterNature(ExporterFilter filter) {
        return new JROdsExporterNature(filter);
    }

    protected String getExporterPropertiesPrefix() {
        return ODS_EXPORTER_PROPERTIES_PREFIX;
    }

    protected void exportLine(TableBuilder tableBuilder, JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        float ratio = line.getWidth() / line.getHeight();
        pen = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen()) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen());
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        this.tempBodyWriter.write("<text:p>");
        this.insertPageAnchor();
        this.tempBodyWriter.write("</text:p>");
        tableBuilder.buildCellFooter();
    }

    protected void exportEllipse(TableBuilder tableBuilder, JRPrintEllipse ellipse, JRExporterGridCell gridCell) throws IOException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(ellipse.getLinePen().getLineColor());
        pen.setLineStyle(ellipse.getLinePen().getLineStyleValue());
        pen.setLineWidth(ellipse.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        this.tempBodyWriter.write("<text:p>");
        this.insertPageAnchor();
        this.tempBodyWriter.write("</text:p>");
        tableBuilder.buildCellFooter();
    }

    public void exportImage(TableBuilder tableBuilder, JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), Math.round(image.getLineBox().getTopPen().getLineWidth().floatValue()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), Math.round(image.getLineBox().getLeftPen().getLineWidth().floatValue()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), Math.round(image.getLineBox().getBottomPen().getLineWidth().floatValue()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), Math.round(image.getLineBox().getRightPen().getLineWidth().floatValue()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        int width = availableImageWidth;
        int height = availableImageHeight;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        JRRenderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0 && !image.isLazy()) {
                renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, image.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            boolean startedHyperlink;
            switch (image.getScaleImageValue()) {
                case FILL_FRAME: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    break;
                }
                default: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        JRRenderable tmpRenderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension();
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (availableImageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        width = availableImageWidth;
                        height = (int)((double)width / ratio);
                        break;
                    }
                    height = availableImageHeight;
                    width = (int)(ratio * (double)height);
                }
            }
            this.tempBodyWriter.write("<text:p>");
            this.insertPageAnchor();
            if (image.getAnchorName() != null) {
                this.exportAnchor(JRStringUtil.xmlEncode(image.getAnchorName()));
            }
            if (startedHyperlink = this.startHyperlink(image, false)) {
                this.endHyperlink(false);
            }
            this.tempBodyWriter.write("</text:p>");
        }
        tableBuilder.buildCellFooter();
    }

    protected void exportAnchor(String anchorName) throws IOException {
    }

    protected void exportGenericElement(TableBuilder tableBuilder, JRGenericPrintElement element, JRExporterGridCell gridCell) throws IOException, JRException {
        GenericElementOdsHandler handler = (GenericElementOdsHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), ODS_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(tableBuilder);
            handler.exportElement(exporterContext, element, gridCell);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No ODS generic element handler for " + element.getGenericType()));
        }
    }

    protected String getExporterKey() {
        return ODS_EXPORTER_KEY;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JROdsExporterContext {
        TableBuilder tableBuilder;

        public ExporterContext(TableBuilder tableBuidler) {
            super(JROdsExporter.this);
            this.tableBuilder = null;
            this.tableBuilder = tableBuidler;
        }

        public TableBuilder getTableBuilder() {
            return this.tableBuilder;
        }

        public String getExportPropertiesPrefix() {
            return JROdsExporter.ODS_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

