/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.base.JRBaseMultiAxisPlot;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.design.JRDesignChart;

public class JRDesignMultiAxisPlot
extends JRBaseMultiAxisPlot {
    public static final String PROPERTY_CHART = "chart";
    public static final String PROPERTY_AXES = "axes";
    private JRDesignChart chart;
    private static final long serialVersionUID = 10200L;

    public JRDesignMultiAxisPlot(JRChartPlot multiAxisPlot, JRChart chart) {
        super(multiAxisPlot, chart);
    }

    public void addAxis(JRChartAxis axis) {
        this.axes.add(axis);
        if (this.axes.size() == 1) {
            this.chart.setDataset(axis.getChart().getDataset());
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_AXES, axis, this.axes.size() - 1);
    }

    public void addAxis(int index, JRChartAxis axis) {
        this.axes.add(index, axis);
        if (this.axes.size() == 1) {
            this.chart.setDataset(axis.getChart().getDataset());
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_AXES, axis, index);
    }

    public JRChartAxis removeAxis(JRChartAxis axis) {
        int idx;
        if (axis != null && (idx = this.axes.indexOf(axis)) >= 0) {
            this.axes.remove(idx);
            this.chart.setDataset(axis.getChart().getDataset());
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_AXES, axis, idx);
        }
        return axis;
    }

    public void clearAxes() {
        ArrayList tmpList = new ArrayList(this.axes);
        Iterator it = tmpList.iterator();
        while (it.hasNext()) {
            this.removeAxis((JRChartAxis)it.next());
        }
        this.chart.setDataset(null);
    }

    public JRChart getChart() {
        return this.chart;
    }

    public void setChart(JRDesignChart chart) {
        JRDesignChart old = this.chart;
        this.chart = chart;
        this.getEventSupport().firePropertyChange(PROPERTY_CHART, old, this.chart);
    }
}

