/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.TreeModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NodeSorter {
    TreeModel model;
    Set expanded = new HashSet();

    private NodeSorter(TreeModel model) {
        this.model = model;
    }

    public static List preOrder(Set nodes, TreeModel model) {
        NodeSorter ns = new NodeSorter(model);
        return ns.order(nodes, true);
    }

    public static List postOrder(Set nodes, TreeModel model) {
        NodeSorter ns = new NodeSorter(model);
        return ns.order(nodes, false);
    }

    List order(Set nodes, boolean preOrder) {
        this.expandParents(nodes);
        ArrayList list = new ArrayList();
        Object[] roots = this.model.getRoots();
        if (roots != null) {
            for (int i = 0; i < roots.length; ++i) {
                this.order(roots[i], list, nodes, preOrder);
            }
        }
        return list;
    }

    void order(Object node, List list, Set nodes, boolean preOrder) {
        if (preOrder && nodes.contains(node)) {
            list.add(node);
        }
        if (this.expanded.contains(node)) {
            Object[] children = this.model.getChildren(node);
            for (int i = 0; i < children.length; ++i) {
                this.order(children[i], list, nodes, preOrder);
            }
        }
        if (!preOrder && nodes.contains(node)) {
            list.add(node);
        }
    }

    void expandParents(Set nodes) {
        this.expanded.clear();
        for (Object node : nodes) {
            node = this.model.getParent(node);
            while (node != null) {
                this.expanded.add(node);
                node = this.model.getParent(node);
            }
        }
    }
}

