/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentTag;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormDocument;
import com.tonbeller.wcf.selection.DefaultSelectionModel;
import com.tonbeller.wcf.table.EditableTableComponent;
import com.tonbeller.wcf.table.EmptyTableModel;
import com.tonbeller.wcf.table.TableComponent;
import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.table.TablePropertiesFormComponent;
import com.tonbeller.wcf.utils.I18nReplacer;
import com.tonbeller.wcf.utils.ResourceLocator;
import com.tonbeller.wcf.utils.XmlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class TableComponentTag
extends ComponentTag {
    private static Logger logger = Logger.getLogger(TableComponentTag.class);
    String model = null;
    String selmode = "multi";
    boolean closable = true;
    boolean pagable = true;
    boolean sortable = true;
    int pagesize = this.getDefaultPageSize(10);
    String editForm = null;
    boolean editable = false;
    boolean colHeaders = true;

    public Component createComponent(RequestContext context) throws JspException {
        try {
            TableModel tm = EmptyTableModel.instance();
            if (this.model != null && (tm = (TableModel)context.getModelReference(this.model)) == null) {
                throw new JspException("table " + this.model + " not found");
            }
            String tableId = this.editForm == null ? this.id : this.id + ".table";
            TableComponent tableComp = this.createTable(tableId, tm);
            tableComp.setPageable(this.pagable);
            tableComp.setSortable(this.sortable);
            tableComp.setClosable(this.closable);
            tableComp.setColHeaders(this.colHeaders);
            DefaultSelectionModel dsm = new DefaultSelectionModel();
            if ("href".equals(this.selmode)) {
                dsm.setMode(3);
            } else if ("single".equals(this.selmode)) {
                dsm.setMode(1);
            } else if ("multi".equals(this.selmode)) {
                dsm.setMode(2);
            } else {
                dsm.setMode(0);
            }
            tableComp.setSelectionModel(dsm);
            tableComp.setPageSize(this.pagesize);
            if (this.editForm != null) {
                Locale locale = Resources.instance().getLocaleContextHolderLocale();
                if (locale == null) {
                    locale = context.getLocale();
                }
                URL url = ResourceLocator.getResource(context.getServletContext(), locale, this.editForm);
                Document doc = XmlUtils.parse(url);
                I18nReplacer replacer = I18nReplacer.instance(Resources.instance(((Object)((Object)this)).getClass()));
                if (replacer != null) {
                    replacer.replaceAll(doc);
                } else {
                    FormDocument.replaceI18n(context, doc, null);
                }
                TablePropertiesFormComponent formComp = new TablePropertiesFormComponent(this.id + ".form", null, doc, tableComp);
                formComp.setVisible(false);
                formComp.setCloseable(true);
                return new EditableTableComponent(this.id, null, tableComp, formComp);
            }
            if (this.editable) {
                return EditableTableComponent.instance(context, this.id, tableComp);
            }
            return tableComp;
        }
        catch (MalformedURLException e) {
            logger.error((Object)this.id, (Throwable)e);
            throw new JspException((Throwable)e);
        }
        catch (MissingResourceException e) {
            logger.error((Object)this.id, (Throwable)e);
            throw new JspException((Throwable)e);
        }
    }

    protected TableComponent createTable(String tableId, TableModel tm) {
        return new TableComponent(tableId, null, tm);
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setSelmode(String string) {
        this.selmode = string;
    }

    public void setClosable(boolean b) {
        this.closable = b;
    }

    public void setPagable(boolean b) {
        this.pagable = b;
    }

    public void setSortable(boolean b) {
        this.sortable = b;
    }

    public void setPagesize(int i) {
        this.pagesize = i;
    }

    public String getModel() {
        return this.model;
    }

    public void setEditForm(String string) {
        this.editForm = string;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isColHeaders() {
        return this.colHeaders;
    }

    public void setColHeaders(boolean colHeaders) {
        this.colHeaders = colHeaders;
    }

    private int getDefaultPageSize(int inPageSize) {
        int result = Math.max(inPageSize, 1);
        Resources resources = Resources.instance();
        if (resources != null) {
            result = Math.min(Integer.parseInt(resources.getString("JAJ_000_wcf.PagedTableModel.MaxPageSize")), result);
        }
        return result;
    }
}

