/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.servlet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.util.Streams;
import org.owasp.csrfguard.util.Writers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaScriptServlet
extends HttpServlet {
    private static final long serialVersionUID = -1459584282530150483L;
    private static final String TOKEN_NAME_IDENTIFIER = "%TOKEN_NAME%";
    private static final String TOKEN_VALUE_IDENTIFIER = "%TOKEN_VALUE%";
    private static final String DOMAIN_ORIGIN_IDENTIFIER = "%DOMAIN_ORIGIN%";
    private static final String DOMAIN_STRICT_IDENTIFIER = "%DOMAIN_STRICT%";
    private static final String INJECT_INTO_XHR_IDENTIFIER = "%INJECT_XHR%";
    private static final String INJECT_INTO_FORMS_IDENTIFIER = "%INJECT_FORMS%";
    private static final String INJECT_INTO_ATTRIBUTES_IDENTIFIER = "%INJECT_ATTRIBUTES%";
    private static final String CONTEXT_PATH_IDENTIFIER = "%CONTEXT_PATH%";
    private static final String SERVLET_PATH_IDENTIFIER = "%SERVLET_PATH%";
    private static final String X_REQUESTED_WITH_IDENTIFIER = "%X_REQUESTED_WITH%";
    private String templateCode = null;
    private String sourceFile = null;
    private String injectIntoForms = null;
    private String injectIntoAttributes = null;
    private String domainStrict = null;
    private String cacheControl = null;
    private Pattern refererPattern = null;
    private String xRequestedWith = null;

    public void init(ServletConfig servletConfig) {
        this.sourceFile = this.getInitParameter(servletConfig, "source-file", "WEB-INF/Owasp.CsrfGuard.js");
        this.domainStrict = this.getInitParameter(servletConfig, "domain-strict", "true");
        this.cacheControl = this.getInitParameter(servletConfig, "cache-control", "private, maxage=28800");
        this.refererPattern = Pattern.compile(this.getRequiredInitParameter(servletConfig, "referer-pattern"));
        this.injectIntoForms = this.getInitParameter(servletConfig, "inject-into-forms", "true");
        this.injectIntoAttributes = this.getInitParameter(servletConfig, "inject-into-attributes", "true");
        this.xRequestedWith = this.getInitParameter(servletConfig, "x-requested-with", "OWASP CSRFGuard Project");
        this.templateCode = this.readFileContent(servletConfig.getServletContext().getRealPath(this.sourceFile));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String refererHeader = request.getHeader("referer");
        if (this.refererPattern == null || refererHeader != null && this.refererPattern.matcher(refererHeader).matches()) {
            this.writeJavaScript(request, response);
        } else {
            response.sendError(404);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        CsrfGuard csrfGuard = (CsrfGuard)session.getAttribute("Owasp_CsrfGuard_Session_Key");
        if (csrfGuard != null && csrfGuard.isTokenPerPageEnabled()) {
            this.writePageTokens(request, response);
        } else {
            response.sendError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePageTokens(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        Map pageTokens = (Map)session.getAttribute("Owasp_CsrfGuard_Pages_Tokens_Key");
        String pageTokensString = pageTokens != null ? this.parsePageTokens(pageTokens) : "";
        response.setContentType("text/plain");
        response.setContentLength(pageTokensString.length());
        ServletOutputStream output = null;
        PrintWriter writer = null;
        try {
            output = response.getOutputStream();
            writer = new PrintWriter((OutputStream)output);
            writer.write(pageTokensString);
            writer.flush();
        }
        catch (Throwable throwable) {
            Writers.close(writer);
            Streams.close((OutputStream)output);
            throw throwable;
        }
        Writers.close(writer);
        Streams.close((OutputStream)output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavaScript(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        CsrfGuard csrfGuard = (CsrfGuard)session.getAttribute("Owasp_CsrfGuard_Session_Key");
        if (csrfGuard.isRotateEnabled() || csrfGuard.isTokenPerPageEnabled()) {
            response.setHeader("Cache-Control", "no-store");
        } else {
            response.setHeader("Cache-Control", this.cacheControl);
        }
        String code = this.templateCode;
        code = code.replaceAll(TOKEN_NAME_IDENTIFIER, csrfGuard.getTokenName());
        code = code.replaceAll(TOKEN_VALUE_IDENTIFIER, (String)session.getAttribute(csrfGuard.getSessionKey()));
        code = code.replaceAll(INJECT_INTO_FORMS_IDENTIFIER, this.injectIntoForms);
        code = code.replaceAll(INJECT_INTO_ATTRIBUTES_IDENTIFIER, this.injectIntoAttributes);
        code = code.replaceAll(INJECT_INTO_XHR_IDENTIFIER, String.valueOf(csrfGuard.isAjaxEnabled()));
        code = code.replaceAll(DOMAIN_ORIGIN_IDENTIFIER, this.parseDomain(request.getRequestURL()));
        code = code.replaceAll(DOMAIN_STRICT_IDENTIFIER, this.domainStrict);
        code = code.replaceAll(CONTEXT_PATH_IDENTIFIER, request.getContextPath());
        code = code.replaceAll(SERVLET_PATH_IDENTIFIER, request.getContextPath() + request.getServletPath());
        code = code.replaceAll(X_REQUESTED_WITH_IDENTIFIER, this.xRequestedWith);
        ServletOutputStream output = null;
        PrintWriter writer = null;
        try {
            output = response.getOutputStream();
            writer = new PrintWriter((OutputStream)output);
            writer.write(code);
            writer.flush();
        }
        catch (Throwable throwable) {
            Writers.close(writer);
            Streams.close((OutputStream)output);
            throw throwable;
        }
        Writers.close(writer);
        Streams.close((OutputStream)output);
    }

    private String parsePageTokens(Map<String, String> pageTokens) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = pageTokens.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = pageTokens.get(key);
            sb.append(key);
            sb.append(':');
            sb.append(value);
            if (!keys.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private String getRequiredInitParameter(ServletConfig servletConfig, String name) {
        String value = servletConfig.getInitParameter(name);
        if (value == null) {
            throw new RuntimeException(String.format("missing required parameter %s", name));
        }
        return value;
    }

    private String getInitParameter(ServletConfig servletConfig, String name, String defaultValue) {
        String value = servletConfig.getInitParameter(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private String readFileContent(String fileName) {
        StringBuilder sb = new StringBuilder();
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            int i = 0;
            while ((i = ((InputStream)is).read()) > 0) {
                sb.append((char)i);
            }
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                Streams.close(is);
                throw throwable;
            }
        }
        Streams.close(is);
        return sb.toString();
    }

    private String parseDomain(StringBuffer url) {
        char character;
        String token = "://";
        int index = url.indexOf(token);
        String part = url.substring(index + token.length());
        StringBuilder domain = new StringBuilder();
        for (int i = 0; i < part.length() && (character = part.charAt(i)) != '/' && character != ':'; ++i) {
            domain.append(character);
        }
        return domain.toString();
    }
}

