/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.action;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.action.AbstractAction;
import org.owasp.csrfguard.util.RandomGenerator;

public class Rotate
extends AbstractAction {
    public void execute(HttpServletRequest request, HttpServletResponse response, CsrfGuardException csrfe, CsrfGuard csrfGuard) throws CsrfGuardException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.updateSessionToken(session, csrfGuard);
            if (csrfGuard.isTokenPerPageEnabled()) {
                this.updatePageTokens(session, csrfGuard);
            }
        }
    }

    private void updateSessionToken(HttpSession session, CsrfGuard csrfGuard) throws CsrfGuardException {
        String token = null;
        try {
            token = RandomGenerator.generateRandomId(csrfGuard.getPrng(), csrfGuard.getTokenLength());
        }
        catch (Exception e) {
            throw new CsrfGuardException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
        }
        session.setAttribute(csrfGuard.getSessionKey(), (Object)token);
    }

    private void updatePageTokens(HttpSession session, CsrfGuard csrfGuard) throws CsrfGuardException {
        Map pageTokens = (Map)session.getAttribute("Owasp_CsrfGuard_Pages_Tokens_Key");
        ArrayList pages = new ArrayList();
        if (pageTokens != null) {
            pages.addAll(pageTokens.keySet());
        }
        for (String page : pages) {
            String token = null;
            try {
                token = RandomGenerator.generateRandomId(csrfGuard.getPrng(), csrfGuard.getTokenLength());
            }
            catch (Exception e) {
                throw new CsrfGuardException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
            }
            pageTokens.put(page, token);
        }
    }
}

