/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.util.Streams;

public class CsrfGuardListener
implements HttpSessionListener {
    private static final String CONFIG_PARAM = "Owasp.CsrfGuard.Config";
    private static final String CONFIG_PRINT_PARAM = "Owasp.CsrfGuard.Config.Print";

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        CsrfGuard csrfGuard = this.newInstance(session.getServletContext());
        session.setAttribute("Owasp_CsrfGuard_Session_Key", (Object)csrfGuard);
        csrfGuard.updateToken(session);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    private CsrfGuard newInstance(ServletContext context) {
        CsrfGuard csrfGuard = null;
        String config = context.getInitParameter(CONFIG_PARAM);
        if (config == null) {
            throw new RuntimeException(String.format("failure to specify context init-param - %s", CONFIG_PARAM));
        }
        InputStream is = null;
        try {
            is = this.getResourceStream(config, context);
            csrfGuard = CsrfGuard.newInstance(is);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Streams.close(is);
                throw throwable;
            }
        }
        Streams.close(is);
        String printConfig = context.getInitParameter(CONFIG_PRINT_PARAM);
        if (printConfig != null && Boolean.parseBoolean(printConfig)) {
            context.log(String.valueOf(csrfGuard));
        }
        return csrfGuard;
    }

    private InputStream getResourceStream(String resourceName, ServletContext context) throws IOException {
        File file;
        String fileName;
        File file2;
        InputStream is = null;
        is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (is == null && (file2 = new File(fileName = context.getRealPath(resourceName))).exists()) {
            is = new FileInputStream(fileName);
        }
        if (is == null && (file = new File(resourceName)).exists()) {
            is = new FileInputStream(resourceName);
        }
        if (is == null) {
            throw new IOException(String.format("unable to locate resource - %s", resourceName));
        }
        return is;
    }
}

