/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.jdbc.JdbcDS;
import com.ingres.gcf.jdbc.JdbcXAConn;
import com.ingres.gcf.jdbc.XARsrcMgr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.XaEx;
import com.ingres.gcf.util.XaXid;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class JdbcXADS
extends JdbcDS
implements XADataSource,
XARsrcMgr,
Serializable {
    private static final String MASTER_DB = "iidbdb";
    private transient Hashtable regXID = null;

    protected JdbcXADS() {
        this.initialize();
    }

    private void initialize() {
        this.title = this.trace.getTraceName() + "-XADataSource[" + this.inst_id + "]";
        this.tr_id = "XADSrc[" + this.inst_id + "]";
        this.regXID = new Hashtable();
    }

    public XAConnection getXAConnection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getXAConnection()");
        }
        JdbcXAConn jdbcXAConn = new JdbcXAConn(this.connect(null, null), this, null, null, this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getXAConnection(): " + jdbcXAConn);
        }
        return jdbcXAConn;
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getXAConnection('" + string + "')");
        }
        JdbcXAConn jdbcXAConn = new JdbcXAConn(this.connect(string, string2), this, string, string2, this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getXAConnection(): " + jdbcXAConn);
        }
        return jdbcXAConn;
    }

    public JdbcConn getRMConnection(String string, String string2) throws SQLException {
        return this.connect(string, string2);
    }

    public void registerXID(XAResource xAResource, XaXid xaXid) throws XAException {
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".registerXID( " + xAResource + ", '" + xaXid + "' )");
        }
        if (this.regXID.get(xaXid) != null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".registerXID(): duplicate XID");
            }
            throw new XAException(-8);
        }
        this.regXID.put(xaXid, xAResource);
    }

    public void deregisterXID(XAResource xAResource, XaXid xaXid) {
        XAResource xAResource2;
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".deregisterXID( '" + xaXid + "' )");
        }
        if ((xAResource2 = (XAResource)this.regXID.get(xaXid)) == null) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".deregisterXID(): XID not registered");
            }
        } else if (xAResource != xAResource2) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".deregisterXID(): Mis-matched XAResource");
            }
        } else {
            this.regXID.remove(xaXid);
        }
    }

    public void startXID(XaXid xaXid, int n) throws XAException {
        XAResource xAResource = (XAResource)this.regXID.get(xaXid);
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".startXID('" + xaXid + "')");
        }
        if (xAResource == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startXID: XID '" + xaXid + "' not registered");
            }
            throw new XAException(-4);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".startXID: passing request to " + xAResource);
        }
        xAResource.start(xaXid, n);
    }

    public void endXID(XaXid xaXid, int n) throws XAException {
        XAResource xAResource = (XAResource)this.regXID.get(xaXid);
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".endXID('" + xaXid + "')");
        }
        if (xAResource == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endXID: XID '" + xaXid + "' not registered");
            }
            throw new XAException(-4);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".endXID: passing request to " + xAResource);
        }
        xAResource.end(xaXid, n);
    }

    public int prepareXID(XaXid xaXid) throws XAException {
        JdbcConn jdbcConn;
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".prepareXID( '" + xaXid + "' ) ");
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".prepareXID: establishing DTM connection");
        }
        try {
            jdbcConn = this.connect(this.getHost(), this.getDatabaseName(), null);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareXID: Connection error");
                sqlEx.trace(this.trace);
            }
            throw new XAException(-7);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".prepareXID: prepare transaction on " + jdbcConn);
        }
        try {
            jdbcConn.prepareTransaction(xaXid);
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareXID: XA error preparing transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareXID: error preparing transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw new XAException(-3);
        }
        finally {
            try {
                jdbcConn.close();
            }
            catch (SQLException sQLException) {}
        }
        return 0;
    }

    public void commitXID(XaXid xaXid, boolean bl) throws XAException {
        JdbcConn jdbcConn;
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".commitXID( '" + xaXid + "', " + bl + " ) ");
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".commitXID: establishing DTM connection");
        }
        try {
            jdbcConn = this.connect(this.getHost(), this.getDatabaseName(), null);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commitXID: Connection error");
                sqlEx.trace(this.trace);
            }
            throw new XAException(-7);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".commitXID: commit transaction on " + jdbcConn);
        }
        try {
            if (bl) {
                jdbcConn.commit(xaXid, 0x40000000);
            } else {
                jdbcConn.commit(xaXid);
            }
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commitXID: XA error committing transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commitXID: error committing transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw new XAException(-3);
        }
        finally {
            try {
                jdbcConn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void rollbackXID(XaXid xaXid) throws XAException {
        JdbcConn jdbcConn;
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".rollbackXID( '" + xaXid + "' ) ");
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".rollbackXID: establishing DTM connection");
        }
        try {
            jdbcConn = this.connect(this.getHost(), this.getDatabaseName(), null);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollbackXID: Connection error");
                sqlEx.trace(this.trace);
            }
            throw new XAException(-7);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".rollbackXID: rollback transaction on " + jdbcConn);
        }
        try {
            jdbcConn.rollback(xaXid);
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollbackXID: XA error rolling back transaction - " + xaEx.getErrorCode());
            }
            throw new XAException(xaEx.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollbackXID: error rolling back transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw new XAException(-3);
        }
        finally {
            try {
                jdbcConn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void abortXID(XaXid xaXid, String string) throws XAException {
        JdbcConn jdbcConn;
        StringBuffer stringBuffer;
        int n;
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".abortXID( '" + xaXid + "', '" + string + "' )");
        }
        if ((n = stringBuffer.indexOf("/", (n = (stringBuffer = new StringBuffer(this.getDatabaseName())).indexOf("::")) < 0 ? 0 : n + 2)) >= 0) {
            stringBuffer.setLength(n);
        }
        stringBuffer.append("/@").append(string);
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".abortXID: establishing DTM connection");
        }
        try {
            jdbcConn = this.connect(this.getHost(), stringBuffer.toString(), null);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".abortXID: Connection error");
                sqlEx.trace(this.trace);
            }
            throw new XAException(-7);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".abortXID: aborting transaction on " + jdbcConn);
        }
        try {
            jdbcConn.abortTransaction(xaXid);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".abortXID: error aborting transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw new XAException(-3);
        }
        finally {
            try {
                jdbcConn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public Xid[] recoverXID() throws XAException {
        Xid[] xidArray;
        JdbcConn jdbcConn;
        int n;
        String string = this.getDatabaseName();
        String string2 = MASTER_DB;
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".recoverXID()");
        }
        if ((n = string.indexOf("::")) >= 0) {
            string2 = string.substring(0, n += 2) + string2;
            string = string.substring(n);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".recoverXID: establishing DTM connection");
        }
        try {
            jdbcConn = this.connect(this.getHost(), string2, null);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".recoverXID: connection failed!");
                sqlEx.trace(this.trace);
            }
            throw new XAException(-7);
        }
        try {
            xidArray = jdbcConn.getPreparedTransactionIDs(string);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".recoverXID: error in XID query");
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw new XAException(-3);
        }
        finally {
            try {
                jdbcConn.close();
            }
            catch (SQLException sQLException) {}
        }
        return xidArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }
}

