/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import java.sql.SQLException;
import java.sql.Savepoint;

public abstract class JdbcSP
implements Savepoint,
GcfErr {
    private JdbcSP next = null;

    abstract String getName();

    static JdbcSP getNamedSP(String string) throws SqlEx {
        return new SpName(string);
    }

    static JdbcSP getUnnamedSP() {
        return new SpId();
    }

    private JdbcSP() {
    }

    public String toString() {
        return "JdbcSP." + this.getName();
    }

    public int getSavepointId() throws SQLException {
        throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
    }

    public String getSavepointName() throws SQLException {
        throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
    }

    JdbcSP getNext() {
        return this.next;
    }

    JdbcSP setNext(JdbcSP jdbcSP) {
        JdbcSP jdbcSP2 = this.next;
        this.next = jdbcSP;
        return jdbcSP2;
    }

    private static class SpId
    extends JdbcSP {
        private static int count = 0;
        private int id = ++count;

        SpId() {
        }

        public int getSavepointId() throws SQLException {
            return this.id;
        }

        String getName() {
            return Integer.toString(this.id);
        }
    }

    private static class SpName
    extends JdbcSP {
        private String name = null;

        SpName(String string) throws SqlEx {
            if (string == null || string.length() == 0 || Character.isDigit(string.charAt(0))) {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
            this.name = string;
        }

        public String getSavepointName() throws SQLException {
            return this.name;
        }

        String getName() {
            return this.name;
        }
    }
}

