/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.util.SqlEx;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class JdbcQPMD
extends DrvObj
implements ParameterMetaData,
MsgConst {
    private JdbcRSMD rsmd = null;
    private int defaultMode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdbcQPMD(DrvConn drvConn, String string) throws SqlEx {
        this(drvConn);
        this.defaultMode = 1;
        if (drvConn.msg_protocol_level < 5) {
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": describing statement '" + string + "'");
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)4);
            this.msg.write((short)9);
            this.msg.write((short)3);
            this.msg.write(string);
            this.msg.done(true);
            this.rsmd = this.readResults();
        }
        finally {
            this.msg.unlock();
        }
        if (this.rsmd == null) {
            this.rsmd = new JdbcRSMD(0, this.trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdbcQPMD(DrvConn drvConn, String string, String string2) throws SqlEx {
        this(drvConn);
        if (drvConn.msg_protocol_level < 5) {
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.trace.enabled(2)) {
            if (string != null) {
                this.trace.write(this.tr_id + ": describing procedure '" + string + "." + string2 + "'");
            } else {
                this.trace.write(this.tr_id + ": describing procedure '" + string2 + "'");
            }
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)10);
            this.msg.write((short)5);
            if (string != null) {
                this.msg.write((short)1);
                this.msg.write(string);
            }
            this.msg.write((short)2);
            this.msg.write(string2);
            this.msg.done(true);
            this.rsmd = this.readResults();
        }
        finally {
            this.msg.unlock();
        }
        if (this.rsmd == null) {
            this.rsmd = new JdbcRSMD(0, this.trace);
        }
    }

    private JdbcQPMD(DrvConn drvConn) {
        super(drvConn);
        this.title = this.trace.getTraceName() + "-JdbcQPMD[" + this.inst_id + "]";
        this.tr_id = "QPMD[" + this.inst_id + "]";
    }

    public int getParameterCount() throws SQLException {
        int n = this.rsmd.getColumnCount();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterCount(): " + n);
        }
        return n;
    }

    public int getParameterMode(int n) throws SQLException {
        int n2;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMode( " + n + " )");
        }
        if ((n2 = this.rsmd.getParameterMode(n)) == 0) {
            n2 = this.defaultMode;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMode: " + n2);
        }
        return n2;
    }

    public int getParameterType(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterType( " + n + " )");
        }
        int n2 = this.rsmd.getColumnType(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterType: " + n2);
        }
        return n2;
    }

    public String getParameterTypeName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterTypeName( " + n + " )");
        }
        String string = this.rsmd.getColumnTypeName(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterTypeName: " + string);
        }
        return string;
    }

    public String getParameterClassName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterClassName( " + n + " )");
        }
        String string = this.rsmd.getColumnClassName(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterClassName: " + string);
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPrecision( " + n + " )");
        }
        int n2 = this.rsmd.getPrecision(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPrecision: " + n2);
        }
        return n2;
    }

    public int getScale(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getScale( " + n + " )");
        }
        int n2 = this.rsmd.getScale(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getScale: " + n2);
        }
        return n2;
    }

    public int isNullable(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isNullable( " + n + " )");
        }
        int n2 = 2;
        switch (this.rsmd.isNullable(n)) {
            case 1: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isNullable: " + n2);
        }
        return n2;
    }

    public boolean isSigned(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSigned( " + n + " )");
        }
        boolean bl = this.rsmd.isSigned(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSigned: " + bl);
        }
        return bl;
    }

    protected JdbcRSMD readDesc() throws SqlEx {
        return JdbcRSMD.load(this.conn);
    }
}

