/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvBlob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.util.BufferedBlob;
import com.ingres.gcf.util.SqlEx;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class JdbcBlob
implements Blob,
DrvConst {
    private Blob blob = null;
    private int segSize = 8192;
    private DrvTrace trace = null;
    private String title = null;

    JdbcBlob(DrvBlob drvBlob, DrvTrace drvTrace) {
        this.blob = drvBlob;
        this.trace = drvTrace;
        this.title = drvTrace.getTraceName() + "-Blob[LOC:" + drvBlob.toString() + "]";
    }

    JdbcBlob(DrvBlob drvBlob, int n, DrvTrace drvTrace) {
        this(drvBlob, drvTrace);
        this.segSize = n;
    }

    public String toString() {
        return this.title;
    }

    boolean isValidLocator(DrvConn drvConn) {
        return this.blob instanceof DrvLOB ? ((DrvLOB)((Object)this.blob)).hasSameDomain(drvConn) : false;
    }

    DrvLOB getLOB() {
        return this.blob instanceof DrvLOB ? (DrvLOB)((Object)this.blob) : null;
    }

    public long length() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".length()");
        }
        long l = this.blob.length();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".length: " + l);
        }
        return l;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBinaryStream()");
        }
        return this.blob.getBinaryStream();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes(" + l + "," + n + ")");
        }
        byte[] byArray = this.blob.getBytes(l, n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes: " + byArray.length + " bytes");
        }
        return byArray;
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position(" + l + ")");
        }
        long l2 = this.blob.position(byArray, l);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position: " + l2);
        }
        return l2;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position(" + blob + "," + l + ")");
        }
        if (blob == null) {
            throw new NullPointerException();
        }
        if (blob instanceof JdbcBlob) {
            blob = ((JdbcBlob)blob).blob;
        }
        long l2 = this.blob.position(blob, l);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".position: " + l2);
        }
        return l2;
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBytes(" + l + "," + n2 + ")");
        }
        this.prepareToUpdate();
        int n3 = this.blob.setBytes(l, byArray, n, n2);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBytes: " + n3);
        }
        return n3;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBinaryStream(" + l + ")");
        }
        this.prepareToUpdate();
        return this.blob.setBinaryStream(l);
    }

    public void truncate(long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".truncate(" + l + ")");
        }
        this.prepareToUpdate();
        this.blob.truncate(l);
    }

    private void prepareToUpdate() throws SqlEx {
        if (this.blob instanceof DrvBlob) {
            this.blob = new BufferedBlob(this.segSize, ((DrvBlob)this.blob).get());
            this.title = this.trace.getTraceName() + "-Blob[cache]";
        }
    }
}

