/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import net.sf.jasperreports.charts.base.JRBaseChartAxis;
import net.sf.jasperreports.charts.type.AxisPositionEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRDesignChartAxis
extends JRBaseChartAxis
implements JRChangeEventsSupport {
    public static final String PROPERTY_CHART = "chart";
    public static final String PROPERTY_POSITION = "position";
    protected JRDesignChart parentChart;
    private static final long serialVersionUID = 10200L;
    private transient JRPropertyChangeSupport eventSupport;

    public JRDesignChartAxis(JRDesignChart parentChart) {
        this.parentChart = parentChart;
    }

    public void setPosition(AxisPositionEnum positionValue) {
        AxisPositionEnum old = this.positionValue;
        this.positionValue = positionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_POSITION, old, this.positionValue);
    }

    public void setChart(JRDesignChart chart) {
        chart.setBackcolor(this.parentChart.getBackcolor());
        chart.setShowLegend(this.parentChart.getShowLegend());
        chart.setTitleExpression(this.parentChart.getTitleExpression());
        chart.setTitleFont(this.parentChart.getTitleFont());
        chart.setTitlePosition(this.parentChart.getTitlePositionValue());
        chart.setTitleColor(this.parentChart.getTitleColor());
        chart.setSubtitleExpression(this.parentChart.getSubtitleExpression());
        chart.setSubtitleFont(this.parentChart.getSubtitleFont());
        chart.setSubtitleColor(this.parentChart.getSubtitleColor());
        chart.setLegendColor(this.parentChart.getLegendColor());
        chart.setLegendBackgroundColor(this.parentChart.getLegendBackgroundColor());
        chart.setLegendFont(this.parentChart.getLegendFont());
        chart.setLegendPosition(this.parentChart.getLegendPositionValue());
        chart.setRenderType(this.parentChart.getRenderType());
        chart.setTheme(this.parentChart.getTheme());
        JRChart old = this.chart;
        this.chart = chart;
        this.getEventSupport().firePropertyChange(PROPERTY_CHART, old, this.chart);
    }

    public void addElement(JRElement element) {
        this.setChart((JRDesignChart)element);
    }

    public Object clone() {
        JRDesignChartAxis clone = (JRDesignChartAxis)super.clone();
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignChartAxis jRDesignChartAxis = this;
        synchronized (jRDesignChartAxis) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

