/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.ParseRegion;

public class IdentifierParser
extends org.olap4j.impl.IdentifierParser {

    public static class MemberListBuilder
    extends BuilderImpl {
        public final List<Member> memberList = new ArrayList<Member>();

        public MemberListBuilder(SchemaReader schemaReader, Cube cube, Hierarchy hierarchy) {
            super(schemaReader, cube, Collections.singletonList(hierarchy));
        }

        public void memberComplete() {
            Member member = this.resolveMember((Hierarchy)this.hierarchyList.get(0));
            if (!member.isNull()) {
                this.memberList.add(member);
            }
            this.segmentList.clear();
        }

        public void tupleComplete() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleListBuilder
    extends TupleBuilder {
        public final List<Member[]> tupleList = new ArrayList<Member[]>();

        public TupleListBuilder(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            super(schemaReader, cube, hierarchyList);
        }

        @Override
        public void tupleComplete() {
            super.tupleComplete();
            Member[] members = this.memberList.toArray(new Member[this.memberList.size()]);
            if (!FunUtil.tupleContainsNullMember(members)) {
                this.tupleList.add(members);
            }
            this.memberList.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleBuilder
    extends BuilderImpl {
        protected final List<Member> memberList = new ArrayList<Member>();

        public TupleBuilder(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            super(schemaReader, cube, hierarchyList);
        }

        @Override
        public void memberComplete() {
            super.memberComplete();
            if (this.memberList.size() >= this.hierarchyList.size()) {
                throw Util.newInternal("expected ')");
            }
            Hierarchy hierarchy = (Hierarchy)this.hierarchyList.get(this.memberList.size());
            Member member = this.resolveMember(hierarchy);
            this.memberList.add(member);
            this.segmentList.clear();
        }

        @Override
        public void tupleComplete() {
            if (this.memberList.size() < this.hierarchyList.size()) {
                throw Util.newInternal("too few members");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuilderImpl
    extends MemberBuilder {
        private final SchemaReader schemaReader;
        private final Cube cube;
        protected final List<Hierarchy> hierarchyList;
        private final boolean ignoreInvalid;

        BuilderImpl(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            this.schemaReader = schemaReader;
            this.cube = cube;
            this.hierarchyList = hierarchyList;
            MondrianProperties props = MondrianProperties.instance();
            boolean load = ((RolapCube)cube).isLoadInProgress();
            this.ignoreInvalid = load ? props.IgnoreInvalidMembers.get() : props.IgnoreInvalidMembersDuringQuery.get();
        }

        protected Member resolveMember(Hierarchy expectedHierarchy) {
            List<Id.Segment> mondrianSegmentList = Util.convert(this.segmentList);
            Member member = (Member)Util.lookupCompound(this.schemaReader, this.cube, mondrianSegmentList, !this.ignoreInvalid, 6);
            if (member == null) {
                assert (this.ignoreInvalid);
                if (expectedHierarchy != null) {
                    return expectedHierarchy.getNullMember();
                }
                for (int i = mondrianSegmentList.size() - 1; i > 0; --i) {
                    List<Id.Segment> partialName = mondrianSegmentList.subList(0, i);
                    OlapElement olapElement = this.schemaReader.lookupCompound(this.cube, partialName, false, 0);
                    if (olapElement == null) continue;
                    return olapElement.getHierarchy().getNullMember();
                }
                throw MondrianResource.instance().MdxChildObjectNotFound.ex(Util.implode(mondrianSegmentList), this.cube.getQualifiedName());
            }
            if (expectedHierarchy != null && member.getHierarchy() != expectedHierarchy) {
                throw Util.newInternal("member is of wrong hierarchy");
            }
            return member;
        }
    }

    private static class _MemberListBuilder
    extends MemberBuilder {
        final List<List<IdentifierNode.Segment>> list = new ArrayList<List<IdentifierNode.Segment>>();

        private _MemberListBuilder() {
        }

        public void memberComplete() {
            super.memberComplete();
            this.list.add(new ArrayList(this.segmentList));
            this.segmentList.clear();
        }
    }

    private static class MemberBuilder
    implements IdentifierParser.Builder {
        final List<IdentifierNode.NameSegment> subSegments = new ArrayList<IdentifierNode.NameSegment>();
        protected final List<IdentifierNode.Segment> segmentList = new ArrayList<IdentifierNode.Segment>();

        public void tupleComplete() {
            throw new UnsupportedOperationException();
        }

        public void memberComplete() {
            this.flushSubSegments();
        }

        private void flushSubSegments() {
            if (!this.subSegments.isEmpty()) {
                this.segmentList.add((IdentifierNode.Segment)new IdentifierNode.KeySegment(this.subSegments));
                this.subSegments.clear();
            }
        }

        public void segmentComplete(ParseRegion region, String name, IdentifierNode.Quoting quoting, IdentifierParser.Builder.Syntax syntax) {
            IdentifierNode.NameSegment segment = new IdentifierNode.NameSegment(region, name, quoting);
            if (syntax != IdentifierParser.Builder.Syntax.NEXT_KEY) {
                this.flushSubSegments();
            }
            if (syntax == IdentifierParser.Builder.Syntax.NAME) {
                this.segmentList.add((IdentifierNode.Segment)segment);
            } else {
                this.subSegments.add(segment);
            }
        }
    }
}

