/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class LucidDbDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(LucidDbDialect.class, Dialect.DatabaseProduct.LUCIDDB);

    public LucidDbDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public boolean allowsMultipleDistinctSqlMeasures() {
        return false;
    }

    public boolean needsExponent(Object value, String valueString) {
        return value instanceof Double && !valueString.contains("E");
    }

    public boolean supportsUnlimitedValueList() {
        return true;
    }

    public boolean supportsMultiValueInExpr() {
        return true;
    }

    public Dialect.NullCollation getNullCollation() {
        return Dialect.NullCollation.NEGINF;
    }

    public String generateOrderItem(String expr, boolean nullable, boolean ascending) {
        if (nullable && ascending) {
            return "CASE WHEN " + expr + " IS NULL THEN 1 ELSE 0 END, " + expr + " ASC";
        }
        return super.generateOrderItem(expr, nullable, ascending);
    }
}

