/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.QueryAxis;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.DescendantsCrossJoinArg;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossJoinArgFactory {
    protected static final Logger LOGGER = Logger.getLogger(CrossJoinArgFactory.class);
    private boolean restrictMemberTypes;
    private static final List<String> cheapFuns = Arrays.asList("LastChild", "FirstChild", "Lag");

    public CrossJoinArgFactory(boolean restrictMemberTypes) {
        this.restrictMemberTypes = restrictMemberTypes;
    }

    public Set<CrossJoinArg> buildConstraintFromAllAxes(RolapEvaluator evaluator) {
        LinkedHashSet<CrossJoinArg> joinArgs = new LinkedHashSet<CrossJoinArg>();
        for (QueryAxis ax : evaluator.getQuery().getAxes()) {
            List<CrossJoinArg[]> axesArgs = this.checkCrossJoinArg(evaluator, ax.getSet(), true);
            if (axesArgs == null) continue;
            for (CrossJoinArg[] axesArg : axesArgs) {
                joinArgs.addAll(Arrays.asList(axesArg));
            }
        }
        return joinArgs;
    }

    public List<CrossJoinArg[]> checkCrossJoinArg(RolapEvaluator evaluator, Exp exp) {
        return this.checkCrossJoinArg(evaluator, exp, false);
    }

    List<CrossJoinArg[]> checkCrossJoinArg(RolapEvaluator evaluator, Exp exp, boolean returnAny) {
        if (exp instanceof NamedSetExpr) {
            NamedSet namedSet = ((NamedSetExpr)exp).getNamedSet();
            exp = namedSet.getExp();
        }
        if (!(exp instanceof ResolvedFunCall)) {
            return null;
        }
        ResolvedFunCall funCall = (ResolvedFunCall)exp;
        FunDef fun = funCall.getFunDef();
        Exp[] args = funCall.getArgs();
        Role role = evaluator.getSchemaReader().getRole();
        CrossJoinArg[] cjArgs = this.checkMemberChildren(role, fun, args);
        if (cjArgs != null) {
            return Collections.singletonList(cjArgs);
        }
        cjArgs = this.checkLevelMembers(role, fun, args);
        if (cjArgs != null) {
            return Collections.singletonList(cjArgs);
        }
        cjArgs = this.checkDescendants(role, fun, args);
        if (cjArgs != null) {
            return Collections.singletonList(cjArgs);
        }
        boolean exclude = false;
        cjArgs = this.checkEnumeration(evaluator, fun, args, false);
        if (cjArgs != null) {
            return Collections.singletonList(cjArgs);
        }
        if (returnAny && (cjArgs = this.checkConstrainedMeasures(evaluator, fun, args)) != null) {
            return Collections.singletonList(cjArgs);
        }
        List<CrossJoinArg[]> allArgs = this.checkDimensionFilter(evaluator, fun, args);
        if (allArgs != null) {
            return allArgs;
        }
        if ("{}".equalsIgnoreCase(fun.getName()) && args.length == 1) {
            return this.checkCrossJoinArg(evaluator, args[0], returnAny);
        }
        if ("NativizeSet".equalsIgnoreCase(fun.getName()) && args.length == 1) {
            return this.checkCrossJoinArg(evaluator, args[0], returnAny);
        }
        return this.checkCrossJoin(evaluator, fun, args, returnAny);
    }

    private CrossJoinArg[] checkConstrainedMeasures(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (this.isSetOfConstrainedMeasures(fun, args)) {
            LinkedHashMap<Dimension, List<RolapMember>> memberLists = new LinkedHashMap<Dimension, List<RolapMember>>();
            for (Exp arg : args) {
                this.addConstrainingMembersToMap(arg, memberLists);
            }
            return this.memberListCrossJoinArgArray(memberLists, args, evaluator);
        }
        return null;
    }

    private boolean isSetOfConstrainedMeasures(FunDef fun, Exp[] args) {
        return fun.getName().equals("{}") && this.allArgsConstrainedMeasure(args);
    }

    private boolean allArgsConstrainedMeasure(Exp[] args) {
        for (Exp arg : args) {
            if (this.isConstrainedMeasure(arg)) continue;
            return false;
        }
        return true;
    }

    private boolean isConstrainedMeasure(Exp arg) {
        if (!(arg instanceof MemberExpr) || !((MemberExpr)arg).getMember().isMeasure()) {
            ResolvedFunCall call;
            if (arg instanceof ResolvedFunCall && ((call = (ResolvedFunCall)arg).getFunDef() instanceof SetFunDef || call.getFunDef() instanceof ParenthesesFunDef)) {
                return this.allArgsConstrainedMeasure(call.getArgs());
            }
            return false;
        }
        Member member = ((MemberExpr)arg).getMember();
        if (member instanceof RolapCalculatedMember) {
            Exp calcExp = ((RolapCalculatedMember)member).getFormula().getExpression();
            return calcExp instanceof ResolvedFunCall && ((ResolvedFunCall)calcExp).getFunDef() instanceof TupleFunDef || calcExp instanceof Literal;
        }
        return false;
    }

    private void addConstrainingMembersToMap(Exp arg, Map<Dimension, List<RolapMember>> memberLists) {
        if (arg instanceof ResolvedFunCall) {
            ResolvedFunCall call = (ResolvedFunCall)arg;
            for (Exp callArg : call.getArgs()) {
                this.addConstrainingMembersToMap(callArg, memberLists);
            }
        }
        Exp[] tupleArgs = this.getCalculatedTupleArgs(arg);
        for (Exp tupleArg : tupleArgs) {
            Dimension dimension = tupleArg.getType().getDimension();
            if (!dimension.isMeasures()) {
                List<Object> members = memberLists.containsKey(dimension) ? memberLists.get(dimension) : new ArrayList();
                members.add((RolapMember)((MemberExpr)tupleArg).getMember());
                memberLists.put(dimension, members);
                continue;
            }
            if (!this.isConstrainedMeasure(tupleArg)) continue;
            this.addConstrainingMembersToMap(tupleArg, memberLists);
        }
    }

    private Exp[] getCalculatedTupleArgs(Exp arg) {
        Exp formulaExp;
        Member member;
        if (arg instanceof MemberExpr && (member = ((MemberExpr)arg).getMember()) instanceof RolapCalculatedMember && (formulaExp = ((RolapCalculatedMember)member).getFormula().getExpression()) instanceof ResolvedFunCall) {
            return ((ResolvedFunCall)formulaExp).getArgs();
        }
        return new Exp[0];
    }

    private CrossJoinArg[] memberListCrossJoinArgArray(Map<Dimension, List<RolapMember>> memberLists, Exp[] args, RolapEvaluator evaluator) {
        ArrayList<CrossJoinArg> argList = new ArrayList<CrossJoinArg>();
        for (List<RolapMember> memberList : memberLists.values()) {
            CrossJoinArg cjArg;
            if (memberList.size() != this.countNonLiteralMeasures(args) || (cjArg = MemberListCrossJoinArg.create(evaluator, this.removeDuplicates(memberList), this.restrictMemberTypes(), false)) == null) continue;
            argList.add(cjArg);
        }
        if (argList.size() > 0) {
            return argList.toArray(new CrossJoinArg[argList.size()]);
        }
        return null;
    }

    private List<RolapMember> removeDuplicates(List<RolapMember> list) {
        HashSet<RolapMember> set = new HashSet<RolapMember>();
        ArrayList<RolapMember> uniqueList = new ArrayList<RolapMember>();
        for (RolapMember element : list) {
            if (!set.add(element)) continue;
            uniqueList.add(element);
        }
        return uniqueList;
    }

    private int countNonLiteralMeasures(Exp[] length) {
        int count = 0;
        for (Exp exp : length) {
            if (exp instanceof MemberExpr) {
                Exp calcExp = ((MemberExpr)exp).getMember().getExpression();
                if (calcExp instanceof Literal) continue;
                ++count;
                continue;
            }
            if (!(exp instanceof ResolvedFunCall)) continue;
            count += this.countNonLiteralMeasures(((ResolvedFunCall)exp).getArgs());
        }
        return count;
    }

    public List<CrossJoinArg[]> checkCrossJoin(RolapEvaluator evaluator, FunDef fun, Exp[] args, boolean returnAny) {
        if (!"Crossjoin".equalsIgnoreCase(fun.getName()) && !"NonEmptyCrossJoin".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        CrossJoinArg[][] cjArgsBothInputs = new CrossJoinArg[2][];
        CrossJoinArg[][] predicateArgsBothInputs = new CrossJoinArg[2][];
        for (int i = 0; i < 2; ++i) {
            List<CrossJoinArg[]> allArgsOneInput = this.checkCrossJoinArg(evaluator, args[i], returnAny);
            cjArgsBothInputs[i] = allArgsOneInput == null || allArgsOneInput.isEmpty() || allArgsOneInput.get(0) == null ? this.expandNonNative(evaluator, args[i]) : allArgsOneInput.get(0);
            if (returnAny) continue;
            if (cjArgsBothInputs[i] == null) {
                return null;
            }
            predicateArgsBothInputs[i] = null;
            if (allArgsOneInput == null || allArgsOneInput.size() != 2) continue;
            predicateArgsBothInputs[i] = allArgsOneInput.get(1);
        }
        ArrayList<CrossJoinArg[]> allArgsBothInputs = new ArrayList<CrossJoinArg[]>();
        CrossJoinArg[] combinedCJArgs = Util.appendArrays(cjArgsBothInputs[0] == null ? CrossJoinArg.EMPTY_ARRAY : cjArgsBothInputs[0], new CrossJoinArg[][]{cjArgsBothInputs[1] == null ? CrossJoinArg.EMPTY_ARRAY : cjArgsBothInputs[1]});
        allArgsBothInputs.add(combinedCJArgs);
        CrossJoinArg[] combinedPredicateArgs = Util.appendArrays(predicateArgsBothInputs[0] == null ? CrossJoinArg.EMPTY_ARRAY : predicateArgsBothInputs[0], new CrossJoinArg[][]{predicateArgsBothInputs[1] == null ? CrossJoinArg.EMPTY_ARRAY : predicateArgsBothInputs[1]});
        if (combinedPredicateArgs.length > 0) {
            allArgsBothInputs.add(combinedPredicateArgs);
        }
        return allArgsBothInputs;
    }

    private CrossJoinArg[] checkEnumeration(RolapEvaluator evaluator, FunDef fun, Exp[] args, boolean exclude) {
        if (fun == null ? args.length != 1 : !"{}".equalsIgnoreCase(fun.getName()) || !CrossJoinArgFactory.isArgSizeSupported(evaluator, args.length)) {
            return null;
        }
        ArrayList<RolapMember> memberList = new ArrayList<RolapMember>();
        for (Exp arg : args) {
            if (!(arg instanceof MemberExpr)) {
                return null;
            }
            Member member = ((MemberExpr)arg).getMember();
            if (member.isCalculated() && !member.isParentChildLeaf()) {
                return null;
            }
            memberList.add((RolapMember)member);
        }
        CrossJoinArg cjArg = MemberListCrossJoinArg.create(evaluator, memberList, this.restrictMemberTypes(), exclude);
        if (cjArg == null) {
            return null;
        }
        return new CrossJoinArg[]{cjArg};
    }

    private boolean restrictMemberTypes() {
        return this.restrictMemberTypes;
    }

    private CrossJoinArg[] checkMemberChildren(Role role, FunDef fun, Exp[] args) {
        if (!"Children".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof MemberExpr)) {
            return null;
        }
        RolapMember member = (RolapMember)((MemberExpr)args[0]).getMember();
        if (member.isCalculated()) {
            return null;
        }
        RolapLevel level = member.getLevel();
        if ((level = (RolapLevel)level.getChildLevel()) == null || !level.isSimple()) {
            return null;
        }
        Access access = role.getAccess(level.getHierarchy());
        switch (access) {
            case ALL: {
                break;
            }
            default: {
                return null;
            }
        }
        return new CrossJoinArg[]{new DescendantsCrossJoinArg(level, member)};
    }

    private CrossJoinArg[] checkLevelMembers(Role role, FunDef fun, Exp[] args) {
        if (!"Members".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof LevelExpr)) {
            return null;
        }
        RolapLevel level = (RolapLevel)((LevelExpr)args[0]).getLevel();
        if (!level.isSimple()) {
            return null;
        }
        Access access = role.getAccess(level.getHierarchy());
        switch (access) {
            case ALL: {
                break;
            }
            default: {
                return null;
            }
        }
        return new CrossJoinArg[]{new DescendantsCrossJoinArg(level, null)};
    }

    private static boolean isArgSizeSupported(RolapEvaluator evaluator, int argSize) {
        boolean argSizeNotSupported = false;
        if (argSize > MondrianProperties.instance().MaxConstraints.get()) {
            argSizeNotSupported = true;
        }
        return !argSizeNotSupported;
    }

    private CrossJoinArg[] checkDescendants(Role role, FunDef fun, Exp[] args) {
        if (!"Descendants".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        if (!(args[0] instanceof MemberExpr)) {
            return null;
        }
        RolapMember member = (RolapMember)((MemberExpr)args[0]).getMember();
        if (member.isCalculated()) {
            return null;
        }
        RolapLevel level = null;
        if (args[1] instanceof LevelExpr) {
            level = (RolapLevel)((LevelExpr)args[1]).getLevel();
        } else if (args[1] instanceof Literal) {
            Literal descendantsDepth;
            RolapLevel[] levels = (RolapLevel[])member.getHierarchy().getLevels();
            int currentDepth = member.getDepth();
            int newDepth = currentDepth + (descendantsDepth = (Literal)args[1]).getIntValue();
            if (newDepth < levels.length) {
                level = levels[newDepth];
            }
        } else {
            return null;
        }
        if (!level.isSimple()) {
            return null;
        }
        Access access = role.getAccess(level.getHierarchy());
        switch (access) {
            case ALL: {
                break;
            }
            default: {
                return null;
            }
        }
        return new CrossJoinArg[]{new DescendantsCrossJoinArg(level, member)};
    }

    private List<CrossJoinArg[]> checkDimensionFilter(RolapEvaluator evaluator, FunDef fun, Exp[] filterArgs) {
        CrossJoinArg[] currentPredicateArgs;
        if (!MondrianProperties.instance().EnableNativeFilter.get()) {
            return null;
        }
        if (!"Filter".equalsIgnoreCase(fun.getName()) || filterArgs.length != 2) {
            return null;
        }
        List<CrossJoinArg[]> allArgs = this.checkCrossJoinArg(evaluator, filterArgs[0]);
        if (allArgs == null || allArgs.isEmpty() || allArgs.get(0) == null) {
            return null;
        }
        CrossJoinArg[] cjArgs = allArgs.get(0);
        if (cjArgs == null) {
            return null;
        }
        CrossJoinArg[] previousPredicateArgs = allArgs.size() == 2 ? allArgs.get(1) : null;
        boolean exclude = false;
        if (filterArgs[1] instanceof ResolvedFunCall) {
            ResolvedFunCall predicateCall = (ResolvedFunCall)filterArgs[1];
            currentPredicateArgs = this.checkFilterPredicate(evaluator, predicateCall, false);
        } else {
            currentPredicateArgs = null;
        }
        if (currentPredicateArgs == null) {
            return null;
        }
        LOGGER.debug((Object)"using native dimension filter");
        CrossJoinArg[] combinedPredicateArgs = currentPredicateArgs;
        if (previousPredicateArgs != null) {
            combinedPredicateArgs = Util.appendArrays(previousPredicateArgs, new CrossJoinArg[][]{currentPredicateArgs});
        }
        return Arrays.asList(cjArgs, combinedPredicateArgs);
    }

    private CrossJoinArg[] checkFilterPredicate(RolapEvaluator evaluator, ResolvedFunCall predicateCall, boolean exclude) {
        CrossJoinArg[] predicateCJArgs = null;
        if (predicateCall.getFunName().equals("()")) {
            Exp actualPredicateCall = predicateCall.getArg(0);
            if (actualPredicateCall instanceof ResolvedFunCall) {
                return this.checkFilterPredicate(evaluator, (ResolvedFunCall)actualPredicateCall, exclude);
            }
            return null;
        }
        if (predicateCall.getFunName().equals("NOT") && predicateCall.getArg(0) instanceof ResolvedFunCall) {
            predicateCall = (ResolvedFunCall)predicateCall.getArg(0);
            exclude = !exclude;
            return this.checkFilterPredicate(evaluator, predicateCall, exclude);
        }
        if (predicateCall.getFunName().equals("AND")) {
            CrossJoinArg[] andCJArgs1;
            CrossJoinArg[] andCJArgs0;
            Exp andArg0 = predicateCall.getArg(0);
            Exp andArg1 = predicateCall.getArg(1);
            if (andArg0 instanceof ResolvedFunCall && andArg1 instanceof ResolvedFunCall && (andCJArgs0 = this.checkFilterPredicate(evaluator, (ResolvedFunCall)andArg0, exclude)) != null && (andCJArgs1 = this.checkFilterPredicate(evaluator, (ResolvedFunCall)andArg1, exclude)) != null) {
                predicateCJArgs = Util.appendArrays(andCJArgs0, new CrossJoinArg[][]{andCJArgs1});
            }
            return predicateCJArgs;
        }
        predicateCJArgs = this.checkFilterPredicateInIs(evaluator, predicateCall, exclude);
        return predicateCJArgs;
    }

    private CrossJoinArg[] checkFilterPredicateInIs(RolapEvaluator evaluator, ResolvedFunCall predicateCall, boolean exclude) {
        Exp[] predSecondArgList;
        FunDef predSecondArgFun;
        FunDef predFirstArgFun;
        boolean useIs;
        if (predicateCall.getFunName().equals("IS")) {
            useIs = true;
        } else if (predicateCall.getFunName().equals("IN")) {
            useIs = false;
        } else {
            return null;
        }
        Exp[] predArgs = predicateCall.getArgs();
        if (predArgs.length != 2) {
            return null;
        }
        if (!(predArgs[0] instanceof ResolvedFunCall)) {
            return null;
        }
        ResolvedFunCall predFirstArgCall = (ResolvedFunCall)predArgs[0];
        if (predFirstArgCall.getFunDef().getName().equals("Ancestor")) {
            Exp[] ancestorArgs = predFirstArgCall.getArgs();
            if (!(ancestorArgs[0] instanceof ResolvedFunCall)) {
                return null;
            }
            predFirstArgCall = (ResolvedFunCall)ancestorArgs[0];
        }
        if (!(predFirstArgFun = predFirstArgCall.getFunDef()).getName().equals("CurrentMember")) {
            return null;
        }
        Exp currentMemberArg = predFirstArgCall.getArg(0);
        Type currentMemberArgType = currentMemberArg.getType();
        if (!(currentMemberArgType instanceof DimensionType) && !(currentMemberArgType instanceof HierarchyType)) {
            return null;
        }
        Exp predSecondArg = predArgs[1];
        if (useIs) {
            if (!(predSecondArg instanceof MemberExpr)) {
                return null;
            }
            predSecondArgFun = null;
            predSecondArgList = new Exp[]{predSecondArg};
        } else {
            if (predSecondArg instanceof NamedSetExpr) {
                NamedSet namedSet = ((NamedSetExpr)predSecondArg).getNamedSet();
                predSecondArg = namedSet.getExp();
            }
            if (!(predSecondArg instanceof ResolvedFunCall)) {
                return null;
            }
            ResolvedFunCall predSecondArgCall = (ResolvedFunCall)predSecondArg;
            predSecondArgFun = predSecondArgCall.getFunDef();
            predSecondArgList = predSecondArgCall.getArgs();
        }
        CrossJoinArg[] predCJArgs = this.checkEnumeration(evaluator, predSecondArgFun, predSecondArgList, exclude);
        return predCJArgs;
    }

    private CrossJoinArg[] expandNonNative(RolapEvaluator evaluator, Exp exp) {
        ExpCompiler compiler = evaluator.getQuery().createCompiler();
        CrossJoinArg[] arg0 = null;
        if (this.shouldExpandNonEmpty(exp) && evaluator.getActiveNativeExpansions().add(exp)) {
            CrossJoinArg arg;
            ListCalc listCalc0 = compiler.compileList(exp);
            List<RolapMember> list0 = Util.cast(listCalc0.evaluateList(evaluator));
            if (list0 != null) {
                Util.checkCJResultLimit(list0.size());
            }
            if ((arg = MemberListCrossJoinArg.create(evaluator, list0, this.restrictMemberTypes(), false)) != null) {
                arg0 = new CrossJoinArg[]{arg};
            }
            evaluator.getActiveNativeExpansions().remove(exp);
        }
        return arg0;
    }

    private boolean shouldExpandNonEmpty(Exp exp) {
        return MondrianProperties.instance().ExpandNonNative.get() || this.isCheapSet(exp);
    }

    private boolean isCheapSet(Exp exp) {
        return this.isSet(exp) && this.allArgsCheapToExpand(exp);
    }

    private boolean allArgsCheapToExpand(Exp exp) {
        if (exp instanceof NamedSetExpr) {
            exp = ((NamedSetExpr)exp).getNamedSet().getExp();
        }
        for (Exp arg : ((ResolvedFunCall)exp).getArgs()) {
            if (!(arg instanceof ResolvedFunCall ? !cheapFuns.contains(((ResolvedFunCall)arg).getFunName()) : !(arg instanceof MemberExpr))) continue;
            return false;
        }
        return true;
    }

    private boolean isSet(Exp exp) {
        return exp instanceof ResolvedFunCall && ((ResolvedFunCall)exp).getFunName().equals("{}") || exp instanceof NamedSetExpr;
    }
}

