/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mondrian.calc.ResultStyle;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.HighCardSqlTupleReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TargetBase;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target
extends TargetBase {
    private final HighCardSqlTupleReader sqlTupleReader;
    private final MemberCache cache;
    private final TupleConstraint constraint;
    boolean parentChild;
    private RolapLevel[] levels;
    private int levelDepth;

    public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers, TupleConstraint constraint, HighCardSqlTupleReader sqlTupleReader) {
        super(srcMembers, level, memberBuilder);
        this.sqlTupleReader = sqlTupleReader;
        this.constraint = constraint;
        this.cache = memberBuilder.getMemberCache();
    }

    @Override
    public void open() {
        this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
        this.setList(new LinkedList<RolapMember>());
        this.levelDepth = this.level.getDepth();
        this.parentChild = this.level.isParentChild();
    }

    @Override
    int internalAddRow(SqlStatement stmt, int column) throws SQLException {
        RolapMember member = null;
        if (this.getCurrMember() != null) {
            member = this.getCurrMember();
        } else {
            boolean checkCacheStatus = true;
            List<SqlStatement.Accessor> accessors = stmt.getAccessors();
            for (int i = 0; i <= this.levelDepth; ++i) {
                RolapLevel childLevel = this.levels[i];
                if (childLevel.isAll()) {
                    member = this.memberBuilder.allMember();
                    continue;
                }
                if (childLevel.isParentChild()) {
                    // empty if block
                }
                int n = ++column;
                ++column;
                Object value = accessors.get(n).get();
                if (value == null) {
                    value = RolapUtil.sqlNullValue;
                }
                Object captionValue = childLevel.hasCaptionColumn() ? accessors.get(column++).get() : null;
                RolapMember parentMember = member;
                Object key = this.cache.makeKey(parentMember, value);
                member = this.cache.getMember(key, checkCacheStatus);
                checkCacheStatus = false;
                if (member == null) {
                    if (this.constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint && childLevel.isParentChild()) {
                        member = this.castToNonEmptyCJConstraint(this.constraint).findMember(value);
                    }
                    if (member == null) {
                        member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, stmt, key, column);
                    }
                }
                if (!childLevel.getOrdinalExp().equals(childLevel.getKeyExp())) {
                    ++column;
                }
                column += childLevel.getProperties().length;
            }
            this.setCurrMember(member);
        }
        this.getList().add(member);
        return column;
    }

    @Override
    public List<RolapMember> close() {
        final boolean asList = this.constraint.getEvaluator() != null && this.constraint.getEvaluator().getQuery().getResultStyle() == ResultStyle.LIST;
        final int limit = MondrianProperties.instance().ResultLimit.get();
        AbstractList<RolapMember> l = new AbstractList<RolapMember>(){
            private boolean moreRows = true;
            private int offset = 0;
            private RolapMember first = null;
            private boolean firstMemberAssigned = false;

            @Override
            public int size() {
                while (this.moreRows) {
                    this.moreRows = Target.this.sqlTupleReader.readNextTuple();
                    if (limit <= 0 || asList || Target.this.getList().size() <= limit) continue;
                    System.out.println("Target: 199, Ouch! Toooo big array..." + this.hashCode());
                    new Throwable().printStackTrace();
                }
                return Target.this.getList().size();
            }

            @Override
            public RolapMember get(int idx) {
                if (asList) {
                    return Target.this.getList().get(idx);
                }
                if (idx == 0 && this.firstMemberAssigned) {
                    return this.first;
                }
                int index = idx - this.offset;
                if (0 < limit && index < 0) {
                    throw new RuntimeException("Element " + idx + " has been forgotten");
                }
                while (index >= Target.this.getList().size() && this.moreRows) {
                    this.moreRows = Target.this.sqlTupleReader.readNextTuple();
                    if (limit <= 0 || Target.this.getList().size() <= limit) continue;
                    while (Target.this.getList().size() > limit) {
                        --index;
                        ++this.offset;
                        ((LinkedList)Target.this.getList()).removeFirst();
                    }
                }
                if (idx == 0) {
                    this.first = Target.this.getList().get(index);
                    this.firstMemberAssigned = true;
                    return this.first;
                }
                return Target.this.getList().get(index);
            }

            @Override
            public RolapMember set(int i, RolapMember e) {
                if (asList) {
                    return Target.this.getList().set(i, e);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                try {
                    this.get(0);
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                    return true;
                }
            }

            @Override
            public int hashCode() {
                return Target.this.hashCode();
            }

            @Override
            public Iterator<RolapMember> iterator() {
                return new Iterator<RolapMember>(){
                    private int cursor = 0;

                    @Override
                    public boolean hasNext() {
                        try {
                            this.get(this.cursor);
                            return true;
                        }
                        catch (IndexOutOfBoundsException ioobe) {
                            return false;
                        }
                    }

                    @Override
                    public RolapMember next() {
                        return this.get(this.cursor++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (asList) {
            l.size();
        }
        return l;
    }
}

