/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TargetBase;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.DescendantsCrossJoinArg;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTupleReader
implements TupleReader {
    protected final TupleConstraint constraint;
    List<TargetBase> targets = new ArrayList<TargetBase>();
    int maxRows = 0;
    private int missedMemberCount;
    private static final String UNION = " union ";

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReader.class);
        for (TargetBase target : this.targets) {
            if (target.srcMembers == null) continue;
            key.add(target.getLevel());
        }
        return key;
    }

    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (TargetBase target : this.targets) {
            if (target.getSrcMembers() == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    protected void prepareTuples(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        String message = "Populating member cache with members for " + this.targets;
        SqlStatement stmt = null;
        boolean execQuery = partialResult == null;
        try {
            boolean moreRows;
            ResultSet resultSet;
            if (execQuery) {
                ArrayList<TargetBase> partialTargets = new ArrayList<TargetBase>();
                for (TargetBase target : this.targets) {
                    if (target.srcMembers != null) continue;
                    partialTargets.add(target);
                }
                String sql = this.makeLevelMembersSql(dataSource);
                assert (sql != null && !sql.equals(""));
                stmt = RolapUtil.executeQuery(dataSource, sql, this.maxRows, 0, "SqlTupleReader.readTuples " + partialTargets, message, -1, -1);
                resultSet = stmt.getResultSet();
            } else {
                resultSet = null;
            }
            for (TargetBase target : this.targets) {
                target.open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int fetchCount = 0;
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                moreRows = resultSet.next();
                if (moreRows) {
                    ++stmt.rowCount;
                }
            } else {
                boolean bl = moreRows = currPartialResultIdx < partialResult.size();
            }
            while (moreRows) {
                if (limit > 0 && limit < ++fetchCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                if (enumTargetCount == 0) {
                    int column = 0;
                    for (TargetBase target : this.targets) {
                        target.setCurrMember(null);
                        column = target.addRow(stmt, column);
                    }
                } else {
                    int firstEnumTarget;
                    for (firstEnumTarget = 0; firstEnumTarget < this.targets.size() && this.targets.get((int)firstEnumTarget).srcMembers == null; ++firstEnumTarget) {
                    }
                    List<RolapMember> partialRow = execQuery ? null : partialResult.get(currPartialResultIdx);
                    this.resetCurrMembers(partialRow);
                    this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, stmt, message);
                    if (newPartialResult != null) {
                        this.savePartialResult(newPartialResult);
                    }
                }
                if (execQuery) {
                    moreRows = resultSet.next();
                    if (!moreRows) continue;
                    ++stmt.rowCount;
                    continue;
                }
                moreRows = ++currPartialResultIdx < partialResult.size();
            }
        }
        catch (SQLException e) {
            if (stmt == null) {
                throw Util.newError(e, message);
            }
            throw stmt.handle(e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<RolapMember> readMembers(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        block2: {
            int memberCountBefore;
            int memberCount = this.countMembers();
            do {
                this.missedMemberCount = 0;
                memberCountBefore = memberCount;
                this.prepareTuples(dataSource, partialResult, newPartialResult);
                memberCount = this.countMembers();
                if (this.missedMemberCount == 0) break block2;
            } while (memberCount != memberCountBefore);
            throw Util.newError("Parent-child hierarchy contains cyclic data");
        }
        assert (this.targets.size() == 1);
        return this.targets.get(0).close();
    }

    private int countMembers() {
        int n = 0;
        for (TargetBase target : this.targets) {
            if (target.getList() == null) continue;
            n += target.getList().size();
        }
        return n;
    }

    @Override
    public List<RolapMember[]> readTuples(DataSource jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        int n = this.targets.size();
        ArrayList<RolapMember[]> tupleList = new ArrayList<RolapMember[]>();
        Iterator[] iter = new Iterator[n];
        for (int i = 0; i < n; ++i) {
            TargetBase t = this.targets.get(i);
            iter[i] = t.close().iterator();
        }
        while (iter[0].hasNext()) {
            RolapMember[] tuples = new RolapMember[n];
            for (int i = 0; i < n; ++i) {
                tuples[i] = (RolapMember)iter[i].next();
            }
            tupleList.add(tuples);
        }
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            FunUtil.hierarchizeTupleList(Util.cast(tupleList), false, n);
        }
        return tupleList;
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (TargetBase target : this.targets) {
            if (target.srcMembers != null) continue;
            if (partialRow != null) {
                target.setCurrMember(partialRow.get(nativeTarget++));
                continue;
            }
            target.setCurrMember(null);
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, SqlStatement stmt, String message) {
        TargetBase currTarget = this.targets.get(currTargetIdx);
        for (int i = 0; i < currTarget.srcMembers.size(); ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && this.targets.get((int)nextTargetIdx).srcMembers == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, stmt, message);
                continue;
            }
            int column = 0;
            int enumTargetIdx = 0;
            for (TargetBase target : this.targets) {
                if (target.srcMembers == null) {
                    try {
                        column = target.addRow(stmt, column);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newError(e, message);
                    }
                }
                RolapMember member = target.srcMembers.get(srcMemberIdxes[enumTargetIdx++]);
                target.getList().add(member);
            }
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (TargetBase target : this.targets) {
            if (target.srcMembers != null) continue;
            row.add(target.getCurrMember());
        }
        partialResult.add(row);
    }

    String makeLevelMembersSql(DataSource dataSource) {
        RolapCube cube = null;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint) {
            SqlContextConstraint sqlConstraint = (SqlContextConstraint)this.constraint;
            Query query = this.constraint.getEvaluator().getQuery();
            cube = (RolapCube)query.getCube();
            if (sqlConstraint.isJoinRequired()) {
                virtualCube = cube.isVirtual();
            }
        }
        if (virtualCube) {
            Query query = this.constraint.getEvaluator().getQuery();
            Collection<RolapCube> baseCubes = this.getBaseCubeCollection(query);
            Collection<RolapCube> fullyJoiningBaseCubes = this.getFullyJoiningBaseCubes(baseCubes);
            if (fullyJoiningBaseCubes.size() == 0) {
                return this.sqlForEmptyTuple(dataSource, baseCubes);
            }
            int k = -1;
            Member originalMeasure = this.constraint.getEvaluator().getMembers()[0];
            String prependString = "";
            StringBuilder selectString = new StringBuilder();
            for (RolapCube baseCube : fullyJoiningBaseCubes) {
                Member measureInCurrentbaseCube = baseCube.getMeasures().get(0);
                this.constraint.getEvaluator().setContext(measureInCurrentbaseCube);
                WhichSelect whichSelect = ++k == fullyJoiningBaseCubes.size() - 1 ? WhichSelect.LAST : WhichSelect.NOT_LAST;
                selectString.append(prependString);
                selectString.append(this.generateSelectForLevels(dataSource, baseCube, whichSelect));
                prependString = UNION;
            }
            this.constraint.getEvaluator().setContext(originalMeasure);
            return selectString.toString();
        }
        return this.generateSelectForLevels(dataSource, cube, WhichSelect.ONLY);
    }

    private Collection<RolapCube> getFullyJoiningBaseCubes(Collection<RolapCube> baseCubes) {
        ArrayList<RolapCube> fullyJoiningCubes = new ArrayList<RolapCube>();
        for (RolapCube baseCube : baseCubes) {
            boolean allTargetsJoin = true;
            for (TargetBase target : this.targets) {
                if (this.targetIsOnBaseCube(target, baseCube)) continue;
                allTargetsJoin = false;
            }
            if (!allTargetsJoin) continue;
            fullyJoiningCubes.add(baseCube);
        }
        return fullyJoiningCubes;
    }

    Collection<RolapCube> getBaseCubeCollection(Query query) {
        RolapCube.CubeComparator cubeComparator = new RolapCube.CubeComparator();
        TreeSet<RolapCube> baseCubes = new TreeSet<RolapCube>(cubeComparator);
        baseCubes.addAll(query.getBaseCubes());
        return baseCubes;
    }

    String sqlForEmptyTuple(DataSource dataSource, Collection<RolapCube> baseCubes) {
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, null);
        sqlQuery.addSelect("0");
        sqlQuery.addFrom(baseCubes.iterator().next().getFact(), null, true);
        sqlQuery.addWhere("1 = 0");
        return sqlQuery.toString();
    }

    String generateSelectForLevels(DataSource dataSource, RolapCube baseCube, WhichSelect whichSelect) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, s);
        sqlQuery.setAllowHints(true);
        Evaluator evaluator = this.getEvaluator(this.constraint);
        AggStar aggStar = this.chooseAggStar(this.constraint, evaluator);
        for (TargetBase target : this.targets) {
            if (target.getSrcMembers() != null) continue;
            this.addLevelMemberSql(sqlQuery, target.getLevel(), baseCube, whichSelect, aggStar);
        }
        this.constraint.addConstraint(sqlQuery, baseCube, aggStar);
        return sqlQuery.toString();
    }

    boolean targetIsOnBaseCube(TargetBase target, RolapCube baseCube) {
        return baseCube == null || baseCube.findBaseCubeHierarchy(target.getLevel().getHierarchy()) != null;
    }

    private boolean isGroupByNeeded(SqlQuery sqlQuery, RolapHierarchy hierarchy, RolapLevel[] levels, int levelDepth) {
        boolean needsGroupBy = false;
        if (hierarchy.getUniqueKeyLevelName() == null) {
            needsGroupBy = true;
        } else {
            boolean foundUniqueKeyLevelName = false;
            for (int i = 0; i <= levelDepth; ++i) {
                RolapLevel lvl = levels[i];
                if (lvl.isAll()) continue;
                if (hierarchy.getUniqueKeyLevelName().equals(lvl.getName())) {
                    foundUniqueKeyLevelName = true;
                }
                for (RolapProperty p : lvl.getProperties()) {
                    if (p.dependsOnLevelValue()) continue;
                    needsGroupBy = true;
                    break;
                }
                if (needsGroupBy) break;
            }
            if (!foundUniqueKeyLevelName) {
                needsGroupBy = true;
            }
        }
        return needsGroupBy;
    }

    protected void addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level, RolapCube baseCube, WhichSelect whichSelect, AggStar aggStar) {
        RolapHierarchy hierarchy = level.getHierarchy();
        if (hierarchy instanceof RolapCubeHierarchy) {
            RolapCubeHierarchy cubeHierarchy = (RolapCubeHierarchy)hierarchy;
            if (baseCube != null && !cubeHierarchy.getCube().equals(baseCube)) {
                hierarchy = baseCube.findBaseCubeHierarchy(hierarchy);
            }
        }
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        boolean needsGroupBy = this.isGroupByNeeded(sqlQuery, hierarchy, levels, levelDepth);
        boolean levelCollapsed = aggStar != null && SqlMemberSource.isLevelCollapsed(aggStar, (RolapCubeLevel)level);
        boolean multipleCols = SqlMemberSource.levelContainsMultipleColumns(level);
        for (int i = 0; i <= levelDepth; ++i) {
            RolapProperty[] properties;
            RolapLevel currLevel = levels[i];
            if (currLevel.isAll()) continue;
            if (levelCollapsed && !multipleCols) {
                RolapStar.Column starColumn = ((RolapCubeLevel)currLevel).getStarKeyColumn();
                int bitPos = starColumn.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                String q = aggColumn.generateExprString(sqlQuery);
                sqlQuery.addSelectGroupBy(q);
                sqlQuery.addOrderBy(q, true, false, true);
                aggColumn.getTable().addToFrom(sqlQuery, false, true);
                continue;
            }
            MondrianDef.Expression keyExp = currLevel.getKeyExp();
            MondrianDef.Expression ordinalExp = currLevel.getOrdinalExp();
            MondrianDef.Expression captionExp = currLevel.getCaptionExp();
            MondrianDef.Expression parentExp = currLevel.getParentExp();
            if (parentExp != null) {
                if (!levelCollapsed) {
                    hierarchy.addToFrom(sqlQuery, parentExp);
                }
                String parentSql = parentExp.getExpression(sqlQuery);
                sqlQuery.addSelectGroupBy(parentSql);
                if (whichSelect.equals((Object)WhichSelect.LAST) || whichSelect.equals((Object)WhichSelect.ONLY)) {
                    sqlQuery.addOrderBy(parentSql, true, false, true);
                }
            }
            String keySql = keyExp.getExpression(sqlQuery);
            String ordinalSql = ordinalExp.getExpression(sqlQuery);
            if (!levelCollapsed) {
                hierarchy.addToFrom(sqlQuery, keyExp);
                hierarchy.addToFrom(sqlQuery, ordinalExp);
            }
            String captionSql = null;
            if (captionExp != null) {
                captionSql = captionExp.getExpression(sqlQuery);
                if (!levelCollapsed) {
                    hierarchy.addToFrom(sqlQuery, captionExp);
                }
            }
            String alias = sqlQuery.addSelect(keySql);
            if (needsGroupBy) {
                sqlQuery.addGroupBy(keySql, alias);
            }
            if (!ordinalSql.equals(keySql)) {
                alias = sqlQuery.addSelect(ordinalSql);
                if (needsGroupBy) {
                    sqlQuery.addGroupBy(ordinalSql, alias);
                }
            }
            if (captionSql != null) {
                alias = sqlQuery.addSelect(captionSql);
                if (needsGroupBy) {
                    sqlQuery.addGroupBy(captionSql, alias);
                }
            }
            this.constraint.addLevelConstraint(sqlQuery, baseCube, aggStar, currLevel);
            if (levelCollapsed) {
                hierarchy.addToFromInverse(sqlQuery, keyExp);
                RolapStar.Column starColumn = ((RolapCubeLevel)currLevel).getStarKeyColumn();
                int bitPos = starColumn.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                RolapStar.Condition condition = new RolapStar.Condition(keyExp, aggColumn.getExpression());
                sqlQuery.addWhere(condition.toString(sqlQuery));
            }
            switch (whichSelect) {
                case LAST: {
                    boolean nullable = true;
                    Dialect dialect = sqlQuery.getDialect();
                    if (dialect.requiresUnionOrderByExprToBeInSelectClause() || dialect.requiresUnionOrderByOrdinal()) {
                        nullable = false;
                    }
                    sqlQuery.addOrderBy(Integer.toString(sqlQuery.getCurrentSelectListSize()), true, false, nullable);
                    break;
                }
                case ONLY: {
                    sqlQuery.addOrderBy(ordinalSql, true, false, true);
                }
            }
            for (RolapProperty property : properties = currLevel.getProperties()) {
                String propSql = property.getExp().getExpression(sqlQuery);
                alias = sqlQuery.addSelect(propSql);
                if (!needsGroupBy || sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
                sqlQuery.addGroupBy(propSql, alias);
            }
        }
    }

    protected Evaluator getEvaluator(TupleConstraint constraint) {
        DescendantsConstraint descConstraint;
        MemberChildrenConstraint mcc;
        if (constraint instanceof SqlContextConstraint) {
            return constraint.getEvaluator();
        }
        if (constraint instanceof DescendantsConstraint && (mcc = (descConstraint = (DescendantsConstraint)constraint).getMemberChildrenConstraint(null)) instanceof SqlContextConstraint) {
            SqlContextConstraint scc = (SqlContextConstraint)mcc;
            return scc.getEvaluator();
        }
        return null;
    }

    AggStar chooseAggStar(TupleConstraint constraint, Evaluator evaluator) {
        RolapStar.Column[] columns;
        if (!MondrianProperties.instance().UseAggregates.get()) {
            return null;
        }
        if (evaluator == null) {
            return null;
        }
        RolapCube cube = (RolapCube)evaluator.getCube();
        if (cube.isVirtual()) {
            return null;
        }
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getNonAllMembers();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = ((RolapStar.Measure)measure.getStarMeasure()).getBitPosition();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        for (TargetBase target : this.targets) {
            RolapLevel level = target.level;
            if (level.isAll()) continue;
            RolapStar.Column column = ((RolapCubeLevel)level).getStarKeyColumn();
            levelBitKey.set(column.getBitPosition());
        }
        measureBitKey.set(bitPosition);
        if (constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint) {
            RolapNativeCrossJoin.NonEmptyCrossJoinConstraint necj = (RolapNativeCrossJoin.NonEmptyCrossJoinConstraint)constraint;
            for (CrossJoinArg arg : necj.args) {
                RolapLevel level;
                if (!(arg instanceof DescendantsCrossJoinArg) && !(arg instanceof MemberListCrossJoinArg) || (level = arg.getLevel()) == null || level.isAll()) continue;
                RolapStar.Column column = ((RolapCubeLevel)level).getStarKeyColumn();
                levelBitKey.set(column.getBitPosition());
            }
        }
        AggStar aggStar = AggregationManager.instance().findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
        return aggStar;
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private static RolapMember strip(RolapMember member) {
        return member instanceof RolapCubeMember ? ((RolapCubeMember)member).getRolapMember() : member;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WhichSelect {
        ONLY,
        NOT_LAST,
        LAST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Target
    extends TargetBase {
        final MemberCache cache;
        RolapLevel[] levels;
        int levelDepth;
        boolean parentChild;
        List<RolapMember> members;
        List<List<RolapMember>> siblings;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
            super(srcMembers, level, memberBuilder);
            this.cache = memberBuilder.getMemberCache();
        }

        @Override
        public void open() {
            int i;
            this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
            this.setList(new ArrayList<RolapMember>());
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            this.members = new ArrayList<RolapMember>();
            for (i = 0; i < this.levels.length; ++i) {
                this.members.add(null);
            }
            this.siblings = new ArrayList<List<RolapMember>>();
            for (i = 0; i < this.levels.length + 1; ++i) {
                this.siblings.add(new ArrayList());
            }
        }

        @Override
        int internalAddRow(SqlStatement stmt, int column) throws SQLException {
            RolapMember member = null;
            if (this.getCurrMember() != null) {
                this.setCurrMember(member);
            } else {
                boolean checkCacheStatus = true;
                for (int i = 0; i <= this.levelDepth; ++i) {
                    MemberChildrenConstraint mcc;
                    Object value;
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = this.memberBuilder.allMember();
                        continue;
                    }
                    RolapMember parentMember = member;
                    List<SqlStatement.Accessor> accessors = stmt.getAccessors();
                    if (this.parentChild) {
                        Object parentValue;
                        if ((parentValue = accessors.get(column++).get()) == null) {
                            parentValue = RolapUtil.sqlNullValue;
                        } else if (!parentValue.toString().equals(childLevel.getNullParentValue())) {
                            Object parentKey = this.cache.makeKey(member, parentValue);
                            parentMember = this.cache.getMember(parentKey);
                        }
                    }
                    if ((value = accessors.get(column++).get()) == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    Object captionValue = childLevel.hasCaptionColumn() ? accessors.get(column++).get() : null;
                    Object key = this.parentChild ? this.cache.makeKey(member, value) : this.cache.makeKey(parentMember, value);
                    member = this.cache.getMember(key, checkCacheStatus);
                    checkCacheStatus = false;
                    if (member == null) {
                        if (SqlTupleReader.this.constraint instanceof RolapNativeCrossJoin.NonEmptyCrossJoinConstraint && childLevel.isParentChild()) {
                            member = this.castToNonEmptyCJConstraint(SqlTupleReader.this.constraint).findMember(value);
                        }
                        if (member == null) {
                            member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, stmt, key, column);
                        }
                    }
                    if (!childLevel.getOrdinalExp().equals(childLevel.getKeyExp())) {
                        ++column;
                    }
                    column += childLevel.getProperties().length;
                    if (member == this.members.get(i)) continue;
                    List<RolapMember> children = this.siblings.get(i + 1);
                    if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members.get(i))) != null) {
                        this.cache.putChildren(this.members.get(i), mcc, children);
                    }
                    mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                    List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                    if (i < this.levelDepth && cachedChildren == null) {
                        this.siblings.set(i + 1, new ArrayList());
                    } else {
                        this.siblings.set(i + 1, null);
                    }
                    this.members.set(i, member);
                    if (this.siblings.get(i) == null) continue;
                    if (value == RolapUtil.sqlNullValue) {
                        this.addAsOldestSibling(this.siblings.get(i), member);
                        continue;
                    }
                    this.siblings.get(i).add(member);
                }
                this.setCurrMember(member);
            }
            this.getList().add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<RolapMember> close() {
            Object object = this.cacheLock;
            synchronized (object) {
                return this.internalClose();
            }
        }

        public List<RolapMember> internalClose() {
            for (int i = 0; i < this.members.size(); ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members.get(i);
                List<RolapMember> children = this.siblings.get(i + 1);
                if (member == null || children == null || member.getDepth() < this.level.getDepth() || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return this.getList();
        }

        private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }
    }
}

